/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal;

import java.awt.Font;
import java.awt.Paint;
import java.beans.PropertyEditor;
import java.util.Properties;
import org.cytoscape.application.swing.CyAction;
import org.cytoscape.service.util.AbstractCyActivator;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.EdgeViewTaskFactory;
import org.cytoscape.util.color.BrewerType;
import org.cytoscape.util.color.Palette;
import org.cytoscape.util.color.PaletteProvider;
import org.cytoscape.util.color.PaletteProviderManager;
import org.cytoscape.util.color.PaletteType;
import org.cytoscape.view.presentation.RenderingEngineFactory;
import org.cytoscape.view.vizmap.VisualMappingFunctionFactory;
import org.cytoscape.view.vizmap.gui.editor.ContinuousMappingCellRendererFactory;
import org.cytoscape.view.vizmap.gui.editor.ValueEditor;
import org.cytoscape.view.vizmap.gui.editor.VisualPropertyEditor;
import org.cytoscape.view.vizmap.gui.editor.VisualPropertyValueEditor;
import org.cytoscape.view.vizmap.gui.internal.ApplicationFacade;
import org.cytoscape.view.vizmap.gui.internal.CurrentTableService;
import org.cytoscape.view.vizmap.gui.internal.MappingFunctionFactoryManagerImpl;
import org.cytoscape.view.vizmap.gui.internal.action.ApplyVisualStyleAction;
import org.cytoscape.view.vizmap.gui.internal.action.EditSelectedDiscreteValuesAction;
import org.cytoscape.view.vizmap.gui.internal.action.RemoveSelectedDiscreteValuesAction;
import org.cytoscape.view.vizmap.gui.internal.controller.StartupCommand;
import org.cytoscape.view.vizmap.gui.internal.event.VizMapEventHandlerManagerImpl;
import org.cytoscape.view.vizmap.gui.internal.model.AttributeSetProxy;
import org.cytoscape.view.vizmap.gui.internal.model.MappingFunctionFactoryProxy;
import org.cytoscape.view.vizmap.gui.internal.model.PropsProxy;
import org.cytoscape.view.vizmap.gui.internal.model.VizMapperProxy;
import org.cytoscape.view.vizmap.gui.internal.task.ClearAllBendsForThisEdgeTaskFactory;
import org.cytoscape.view.vizmap.gui.internal.task.ClearColumnStyleTaskFactory;
import org.cytoscape.view.vizmap.gui.internal.task.CopyVisualStyleTaskFactory;
import org.cytoscape.view.vizmap.gui.internal.task.CreateLegendTaskFactory;
import org.cytoscape.view.vizmap.gui.internal.task.CreateNewVisualStyleTaskFactory;
import org.cytoscape.view.vizmap.gui.internal.task.MakeVisualStylesDefaultTaskFactory;
import org.cytoscape.view.vizmap.gui.internal.task.RefreshStyleTaskFactory;
import org.cytoscape.view.vizmap.gui.internal.task.RemoveVisualMappingsTaskFactory;
import org.cytoscape.view.vizmap.gui.internal.task.RemoveVisualStylesTaskFactory;
import org.cytoscape.view.vizmap.gui.internal.task.RenameVisualStyleTaskFactory;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.cytoscape.view.vizmap.gui.internal.util.mapgenerator.FitLabelMappingGenerator;
import org.cytoscape.view.vizmap.gui.internal.util.mapgenerator.NumberSeriesMappingGenerator;
import org.cytoscape.view.vizmap.gui.internal.util.mapgenerator.PaletteMappingWrapper;
import org.cytoscape.view.vizmap.gui.internal.util.mapgenerator.RandomNumberMappingGenerator;
import org.cytoscape.view.vizmap.gui.internal.view.VizMapPropertyBuilder;
import org.cytoscape.view.vizmap.gui.internal.view.VizMapperMainPanel;
import org.cytoscape.view.vizmap.gui.internal.view.VizMapperMediator;
import org.cytoscape.view.vizmap.gui.internal.view.VizMapperMenuMediator;
import org.cytoscape.view.vizmap.gui.internal.view.editor.BooleanVisualPropertyEditor;
import org.cytoscape.view.vizmap.gui.internal.view.editor.ColorVisualPropertyEditor;
import org.cytoscape.view.vizmap.gui.internal.view.editor.EditorManagerImpl;
import org.cytoscape.view.vizmap.gui.internal.view.editor.FontVisualPropertyEditor;
import org.cytoscape.view.vizmap.gui.internal.view.editor.NumberVisualPropertyEditor;
import org.cytoscape.view.vizmap.gui.internal.view.editor.StringVisualPropertyEditor;
import org.cytoscape.view.vizmap.gui.internal.view.editor.propertyeditor.CyColorPropertyEditor;
import org.cytoscape.view.vizmap.gui.internal.view.editor.propertyeditor.CyComboBoxPropertyEditor;
import org.cytoscape.view.vizmap.gui.internal.view.editor.propertyeditor.CyFontPropertyEditor;
import org.cytoscape.view.vizmap.gui.internal.view.editor.valueeditor.BooleanValueEditor;
import org.cytoscape.view.vizmap.gui.internal.view.editor.valueeditor.CyColorChooser;
import org.cytoscape.view.vizmap.gui.internal.view.editor.valueeditor.FontValueEditor;
import org.cytoscape.view.vizmap.gui.internal.view.editor.valueeditor.NumericValueEditor;
import org.cytoscape.view.vizmap.gui.internal.view.editor.valueeditor.StringValueEditor;
import org.cytoscape.view.vizmap.gui.util.DiscreteMappingGenerator;
import org.cytoscape.work.TaskFactory;
import org.osgi.framework.BundleContext;

public class CyActivator
extends AbstractCyActivator {
    public void start(BundleContext bc) {
        CyServiceRegistrar serviceRegistrar = (CyServiceRegistrar)this.getService(bc, CyServiceRegistrar.class);
        ServicesUtil servicesUtil = new ServicesUtil(serviceRegistrar, "ApplicationFacade");
        AttributeSetProxy attributeSetProxy = new AttributeSetProxy(servicesUtil);
        MappingFunctionFactoryProxy mappingFactoryProxy = new MappingFunctionFactoryProxy(servicesUtil);
        PaletteProviderManager paletteProviderManager = (PaletteProviderManager)this.getService(bc, PaletteProviderManager.class);
        this.generateColorMappingGenerators(serviceRegistrar, paletteProviderManager);
        EditorManagerImpl editorManager = new EditorManagerImpl(attributeSetProxy, mappingFactoryProxy, servicesUtil);
        this.registerServiceListener(bc, editorManager::addValueEditor, editorManager::removeValueEditor, ValueEditor.class);
        this.registerServiceListener(bc, editorManager::addVisualPropertyValueEditor, editorManager::removeVisualPropertyValueEditor, VisualPropertyValueEditor.class);
        this.registerServiceListener(bc, editorManager::addVisualPropertyEditor, editorManager::removeVisualPropertyEditor, VisualPropertyEditor.class);
        this.registerServiceListener(bc, editorManager::addRenderingEngineFactory, editorManager::removeRenderingEngineFactory, RenderingEngineFactory.class);
        this.registerAllServices(bc, editorManager);
        MappingFunctionFactoryManagerImpl mappingFunctionFactoryManager = new MappingFunctionFactoryManagerImpl();
        this.registerServiceListener(bc, mappingFunctionFactoryManager::addFactory, mappingFunctionFactoryManager::removeFactory, VisualMappingFunctionFactory.class);
        this.registerAllServices(bc, mappingFunctionFactoryManager);
        NumericValueEditor<Double> doubleValueEditor = new NumericValueEditor<Double>(Double.class);
        NumericValueEditor<Integer> integerValueEditor = new NumericValueEditor<Integer>(Integer.class);
        NumericValueEditor<Float> floatValueEditor = new NumericValueEditor<Float>(Float.class);
        StringValueEditor stringValueEditor = new StringValueEditor();
        BooleanValueEditor booleanValueEditor = new BooleanValueEditor();
        FontValueEditor fontValueEditor = new FontValueEditor(servicesUtil);
        CyColorChooser colorChooser = new CyColorChooser(serviceRegistrar);
        CyColorPropertyEditor cyColorPropertyEditor = new CyColorPropertyEditor(colorChooser, servicesUtil);
        CyFontPropertyEditor cyFontPropertyEditor = new CyFontPropertyEditor();
        ContinuousMappingCellRendererFactory cmCellRendererFactory = (ContinuousMappingCellRendererFactory)this.getService(bc, ContinuousMappingCellRendererFactory.class);
        ColorVisualPropertyEditor colorPropertyEditor = new ColorVisualPropertyEditor(Paint.class, editorManager, cyColorPropertyEditor, cmCellRendererFactory);
        NumberVisualPropertyEditor<Double> doublePropertyEditor = new NumberVisualPropertyEditor<Double>(Double.class, cmCellRendererFactory);
        NumberVisualPropertyEditor<Integer> integerPropertyEditor = new NumberVisualPropertyEditor<Integer>(Integer.class, cmCellRendererFactory);
        NumberVisualPropertyEditor<Float> floatPropertyEditor = new NumberVisualPropertyEditor<Float>(Float.class, cmCellRendererFactory);
        FontVisualPropertyEditor fontVisualPropertyEditor = new FontVisualPropertyEditor(Font.class, cyFontPropertyEditor, cmCellRendererFactory);
        StringVisualPropertyEditor stringPropertyEditor = new StringVisualPropertyEditor(cmCellRendererFactory, servicesUtil);
        CyComboBoxPropertyEditor booleanEditor = new CyComboBoxPropertyEditor();
        booleanEditor.setAvailableValues(new Boolean[]{true, false});
        BooleanVisualPropertyEditor booleanVisualPropertyEditor = new BooleanVisualPropertyEditor((PropertyEditor)((Object)booleanEditor), cmCellRendererFactory);
        Object factory = new ClearAllBendsForThisEdgeTaskFactory(servicesUtil);
        Properties props = new Properties();
        props.put("preferredMenu", "Edit[-1100]");
        props.put("title", "Clear All Bends For This Edge");
        props.put("menuGravity", "5.0");
        props.put("insertSeparatorBefore", "true");
        this.registerService(bc, factory, EdgeViewTaskFactory.class, props);
        this.registerAllServices(bc, (Object)attributeSetProxy);
        this.registerAllServices(bc, editorManager.getNodeEditor());
        this.registerAllServices(bc, editorManager.getEdgeEditor());
        this.registerAllServices(bc, editorManager.getNetworkEditor());
        this.registerAllServices(bc, colorChooser);
        this.registerAllServices(bc, doubleValueEditor);
        this.registerAllServices(bc, integerValueEditor);
        this.registerAllServices(bc, floatValueEditor);
        this.registerAllServices(bc, stringValueEditor);
        this.registerAllServices(bc, booleanValueEditor);
        this.registerAllServices(bc, fontValueEditor);
        this.registerAllServices(bc, colorPropertyEditor);
        this.registerAllServices(bc, doublePropertyEditor);
        this.registerAllServices(bc, floatPropertyEditor);
        this.registerAllServices(bc, integerPropertyEditor);
        this.registerAllServices(bc, fontVisualPropertyEditor);
        this.registerAllServices(bc, stringPropertyEditor);
        this.registerAllServices(bc, booleanVisualPropertyEditor);
        factory = new CreateNewVisualStyleTaskFactory(servicesUtil);
        props = new Properties();
        props.setProperty("service.type", "vizmapUI");
        props.setProperty("title", "Create New Style...");
        props.setProperty("menu", "main");
        props.setProperty("gravity", "1.0");
        this.registerAllServices(bc, factory, props);
        factory = new CopyVisualStyleTaskFactory(servicesUtil);
        props = new Properties();
        props.setProperty("service.type", "vizmapUI");
        props.setProperty("title", "Copy Style...");
        props.setProperty("menu", "main");
        props.setProperty("gravity", "2.0");
        this.registerAllServices(bc, factory, props);
        factory = new RefreshStyleTaskFactory(servicesUtil);
        props = new Properties();
        props.setProperty("service.type", "vizmapUI");
        props.setProperty("title", "Refresh Style");
        props.setProperty("menu", "main");
        props.setProperty("gravity", "2.5");
        this.registerAllServices(bc, factory, props);
        factory = new RenameVisualStyleTaskFactory(servicesUtil);
        props = new Properties();
        props.setProperty("service.type", "vizmapUI");
        props.setProperty("title", "Rename Style...");
        props.setProperty("menu", "main");
        props.setProperty("gravity", "3.0");
        this.registerAllServices(bc, factory, props);
        factory = new RemoveVisualStylesTaskFactory(servicesUtil);
        props = new Properties();
        props.setProperty("service.type", "vizmapUI");
        props.setProperty("title", "Remove Style");
        props.setProperty("menu", "main");
        props.setProperty("gravity", "4.0");
        this.registerAllServices(bc, factory, props);
        factory = new MakeVisualStylesDefaultTaskFactory(servicesUtil);
        props = new Properties();
        props.setProperty("service.type", "vizmapUI");
        props.setProperty("title", "Make Current Styles Default");
        props.setProperty("menu", "main");
        props.setProperty("gravity", "5.0");
        props.setProperty("insertSeparatorBefore", "true");
        this.registerAllServices(bc, factory, props);
        factory = new CreateLegendTaskFactory(servicesUtil);
        props = new Properties();
        props.setProperty("service.type", "vizmapUI");
        props.setProperty("title", "Create Legend...");
        props.setProperty("menu", "main");
        props.setProperty("gravity", "6.0");
        props.setProperty("insertSeparatorBefore", "true");
        this.registerAllServices(bc, factory, props);
        factory = new ClearColumnStyleTaskFactory(servicesUtil);
        props = new Properties();
        props.setProperty("service.type", "vizmapUI");
        props.setProperty("title", "Clear Current Style...");
        props.setProperty("menu", "table");
        props.setProperty("gravity", "1.0");
        this.registerAllServices(bc, factory, props);
        EditSelectedDiscreteValuesAction editAction = new EditSelectedDiscreteValuesAction(servicesUtil, editorManager);
        props = new Properties();
        props.setProperty("service.type", "vizmapUI");
        props.setProperty("title", "Edit Selected Discrete Mapping Values");
        props.setProperty("menu", "context");
        props.setProperty("gravity", "1.0");
        this.registerService(bc, (Object)editAction, CyAction.class, props);
        RemoveSelectedDiscreteValuesAction removeAction = new RemoveSelectedDiscreteValuesAction(servicesUtil);
        props = new Properties();
        props.setProperty("service.type", "vizmapUI");
        props.setProperty("title", "Remove Selected Discrete Mapping Values");
        props.setProperty("menu", "context");
        props.setProperty("gravity", "2.0");
        this.registerService(bc, (Object)removeAction, CyAction.class, props);
        factory = new RemoveVisualMappingsTaskFactory(servicesUtil);
        props = new Properties();
        props.setProperty("service.type", "vizmapUI");
        props.setProperty("title", "Remove Mappings from Selected Visual Properties");
        props.setProperty("menu", "context");
        props.setProperty("gravity", "3.0");
        props.setProperty("insertSeparatorBefore", "true");
        this.registerAllServices(bc, factory, props);
        NumberSeriesMappingGenerator<Number> seriesGenerator = new NumberSeriesMappingGenerator<Number>(Number.class);
        props = new Properties();
        props.setProperty("service.type", "vizmapUI.contextMenu");
        props.setProperty("title", "Number Series");
        props.setProperty("menu", "context");
        this.registerService(bc, seriesGenerator, DiscreteMappingGenerator.class, props);
        RandomNumberMappingGenerator randomNumberGenerator = new RandomNumberMappingGenerator();
        props = new Properties();
        props.setProperty("service.type", "vizmapUI.contextMenu");
        props.setProperty("title", "Random Numbers");
        props.setProperty("menu", "context");
        this.registerService(bc, randomNumberGenerator, DiscreteMappingGenerator.class, props);
        FitLabelMappingGenerator<Double> fitLabelMappingGenerator = new FitLabelMappingGenerator<Double>(Double.class, servicesUtil);
        props = new Properties();
        props.setProperty("service.type", "vizmapUI.contextMenu");
        props.setProperty("title", "Fit label width (only works with 'name' column to node size or width)");
        props.setProperty("menu", "context");
        this.registerService(bc, fitLabelMappingGenerator, DiscreteMappingGenerator.class, props);
        ApplyVisualStyleAction action = new ApplyVisualStyleAction(6.999f, servicesUtil);
        props = new Properties();
        props.setProperty("title", "Apply Style...");
        props.setProperty("inNetworkPanelContextMenu", "true");
        props.setProperty("enableFor", "networkAndView");
        this.registerService(bc, (Object)action, CyAction.class, props);
        VizMapperMainPanel vizMapperMainPanel = new VizMapperMainPanel(servicesUtil);
        VizMapperProxy vizMapperProxy = new VizMapperProxy(servicesUtil);
        PropsProxy propsProxy = new PropsProxy(servicesUtil);
        VizMapPropertyBuilder vizMapPropertyBuilder = new VizMapPropertyBuilder(editorManager, mappingFunctionFactoryManager, servicesUtil);
        VizMapperMediator vizMapperMediator = new VizMapperMediator(vizMapperMainPanel, servicesUtil, vizMapPropertyBuilder);
        VizMapperMenuMediator vizMapperMenuMediator = new VizMapperMenuMediator(vizMapperMainPanel, servicesUtil);
        StartupCommand startupCommand = new StartupCommand(vizMapperProxy, attributeSetProxy, mappingFactoryProxy, propsProxy, vizMapperMediator, vizMapperMenuMediator, servicesUtil);
        CurrentTableService currentTableService = new CurrentTableService(servicesUtil, vizMapperMediator, attributeSetProxy, vizMapperProxy);
        this.registerService(bc, currentTableService, CurrentTableService.class);
        this.registerAllServices(bc, (Object)vizMapperProxy);
        this.registerAllServices(bc, (Object)mappingFactoryProxy);
        this.registerAllServices(bc, (Object)propsProxy);
        this.registerAllServices(bc, vizMapperMediator);
        this.registerServiceListener(bc, vizMapperMediator::onCyActionRegistered, vizMapperMediator::onCyActionUnregistered, CyAction.class);
        this.registerServiceListener(bc, vizMapperMediator::onTaskFactoryRegistered, vizMapperMediator::onTaskFactoryUnregistered, TaskFactory.class);
        this.registerServiceListener(bc, vizMapperMediator::onMappingGeneratorRegistered, vizMapperMediator::onMappingGeneratorUnregistered, DiscreteMappingGenerator.class);
        this.registerServiceListener(bc, vizMapperMenuMediator::onRenderingEngineFactoryRegistered, vizMapperMenuMediator::onRenderingEngineFactoryUnregistered, RenderingEngineFactory.class);
        VizMapEventHandlerManagerImpl vizMapEventHandlerManager = new VizMapEventHandlerManagerImpl(editorManager, attributeSetProxy, servicesUtil, vizMapPropertyBuilder, vizMapperMediator);
        this.registerServiceListener(bc, vizMapEventHandlerManager::registerPCL, vizMapEventHandlerManager::unregisterPCL, RenderingEngineFactory.class);
        new ApplicationFacade(startupCommand).startup();
    }

    public void generateColorMappingGenerators(CyServiceRegistrar registrar, PaletteProviderManager paletteProviderMgr) {
        for (PaletteProvider provider : paletteProviderMgr.getPaletteProviders((PaletteType)BrewerType.QUALITATIVE, false)) {
            for (String paletteName : provider.listPaletteNames((PaletteType)BrewerType.QUALITATIVE, false)) {
                Palette palette = provider.getPalette(paletteName);
                this.registerNewGenerator(registrar, palette.toString(), palette);
            }
        }
    }

    private void registerNewGenerator(CyServiceRegistrar registrar, String name, Palette palette) {
        PaletteMappingWrapper generator = new PaletteMappingWrapper(name, palette);
        Properties props = new Properties();
        props.setProperty("service.type", "vizmapUI");
        props.setProperty("title", name);
        props.setProperty("menu", "context");
        registrar.registerService((Object)generator, DiscreteMappingGenerator.class, props);
    }
}

