/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal;

import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkTableManager;
import org.cytoscape.model.CyTable;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.RenderingEngine;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.gui.internal.VizMapperProperty;
import org.cytoscape.view.vizmap.gui.internal.model.AttributeSet;
import org.cytoscape.view.vizmap.gui.internal.model.AttributeSetProxy;
import org.cytoscape.view.vizmap.gui.internal.model.VizMapperProxy;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.cytoscape.view.vizmap.gui.internal.view.VisualPropertySheetItem;
import org.cytoscape.view.vizmap.gui.internal.view.VizMapperMediator;

public class CurrentTableService {
    private final ServicesUtil servicesUtil;
    private final VizMapperMediator vizMapperMediator;
    private final AttributeSetProxy attrProxy;
    private final VizMapperProxy vmProxy;

    public CurrentTableService(ServicesUtil servicesUtil, VizMapperMediator vizMapperMediator, AttributeSetProxy attrProxy, VizMapperProxy vmProxy) {
        this.servicesUtil = servicesUtil;
        this.vizMapperMediator = vizMapperMediator;
        this.attrProxy = attrProxy;
        this.vmProxy = vmProxy;
    }

    public RenderingEngine<?> getRenderingEngine(VisualProperty<?> vp) {
        Class type = vp.getTargetDataType();
        if (type == CyColumn.class || type == CyTable.class) {
            return this.vmProxy.getCurrentTableRenderingEngine();
        }
        return this.vmProxy.getCurrentRenderingEngine();
    }

    public VisualLexicon getCurrentVisualLexicon(VisualProperty<?> vp) {
        Class type = vp.getTargetDataType();
        CyApplicationManager appMgr = this.servicesUtil.get(CyApplicationManager.class);
        if (type == CyColumn.class || type == CyTable.class) {
            return appMgr.getDefaultTableViewRenderer().getRenderingEngineFactory("").getVisualLexicon();
        }
        return appMgr.getCurrentNetworkViewRenderer().getRenderingEngineFactory("").getVisualLexicon();
    }

    public VisualPropertySheetItem<?> getCurrentVisualPropertySheetItem() {
        return this.vizMapperMediator.getCurrentVisualPropertySheetItem();
    }

    public VizMapperProperty<?, ?, ?> getCurrentVizMapperProperty() {
        return this.vizMapperMediator.getCurrentVizMapperProperty();
    }

    public AttributeSet getAttributeSet(VisualProperty<?> vp) {
        Class type = vp.getTargetDataType();
        CyApplicationManager appMgr = this.servicesUtil.get(CyApplicationManager.class);
        if (type == CyColumn.class || type == CyTable.class) {
            CyTable table = appMgr.getCurrentTable();
            return table == null ? null : this.attrProxy.getAttributeSet(table);
        }
        CyNetwork currentNet = appMgr.getCurrentNetwork();
        return currentNet == null ? null : this.attrProxy.getAttributeSet(currentNet, vp.getTargetDataType());
    }

    public CyTable getCurrentTable(Class<? extends CyIdentifiable> targetDataType) {
        CyApplicationManager appMgr = this.servicesUtil.get(CyApplicationManager.class);
        if (targetDataType == CyColumn.class || targetDataType == CyTable.class) {
            return appMgr.getCurrentTable();
        }
        CyNetworkTableManager netTblMgr = this.servicesUtil.get(CyNetworkTableManager.class);
        return netTblMgr.getTable(appMgr.getCurrentNetwork(), targetDataType, "USER");
    }

    public VisualStyle getCurrentVisualStyle(Class<? extends CyIdentifiable> type) {
        return this.vizMapperMediator.getCurrentVisualStyle(type);
    }

    public VisualStyle getCurrentVisualStyle() {
        Class<CyIdentifiable> type = this.getCurrentVisualPropertySheetItem().getModel().getTargetDataType();
        return this.getCurrentVisualStyle(type);
    }

    public CyColumn getCurrentColumn() {
        return this.vizMapperMediator.getCurrentColumn();
    }
}

