/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.command.internal.available;

import java.lang.ref.WeakReference;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.command.AvailableCommands;
import org.cytoscape.command.internal.available.ArgHandler;
import org.cytoscape.command.internal.available.ArgRecorder;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkFactory;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.SavePolicy;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.NetworkTaskFactory;
import org.cytoscape.task.NetworkViewCollectionTaskFactory;
import org.cytoscape.task.NetworkViewTaskFactory;
import org.cytoscape.task.TableTaskFactory;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewFactory;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.work.AbstractTaskFactory;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskFactory;
import org.cytoscape.work.TaskIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvailableCommandsImpl
implements AvailableCommands {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private final Map<String, TaskFactory> commands;
    private final Map<String, String> descriptions;
    private final Map<String, String> longDescriptions;
    private final Map<String, String> exampleJSONs;
    private final Map<String, Boolean> supportsJSONs;
    private final Map<String, Map<String, Map<String, ArgHandler>>> argHandlers;
    private final ArgRecorder argRec;
    private final StaticTaskFactoryProvisioner factoryProvisioner;
    private final Map<Object, TaskFactory> provisioners;
    private final CyApplicationManager appMgr;
    private final CyServiceRegistrar serviceRegistrar;
    private final CyEventHelper eventHelper;
    private CyNetworkManager netMgr;
    private CyNetworkViewManager netViewMgr;
    private final Object lock = new Object();
    private CyNetwork emptyNetwork = null;
    private CyNetworkView emptyView = null;

    public AvailableCommandsImpl(ArgRecorder argRec, CyServiceRegistrar serviceRegistrar) {
        this.argRec = argRec;
        this.commands = new HashMap<String, TaskFactory>();
        this.descriptions = new HashMap<String, String>();
        this.longDescriptions = new HashMap<String, String>();
        this.exampleJSONs = new HashMap<String, String>();
        this.supportsJSONs = new HashMap<String, Boolean>();
        this.argHandlers = new HashMap<String, Map<String, Map<String, ArgHandler>>>();
        this.factoryProvisioner = new StaticTaskFactoryProvisioner();
        this.provisioners = new IdentityHashMap<Object, TaskFactory>();
        this.serviceRegistrar = serviceRegistrar;
        this.appMgr = (CyApplicationManager)serviceRegistrar.getService(CyApplicationManager.class);
        this.eventHelper = (CyEventHelper)serviceRegistrar.getService(CyEventHelper.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getNamespaces() {
        ArrayList<String> l;
        Object object = this.lock;
        synchronized (object) {
            l = new ArrayList<String>(this.argHandlers.keySet());
        }
        this.sort(l);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getCommands(String namespace) {
        Object object = this.lock;
        synchronized (object) {
            Map<String, Map<String, ArgHandler>> mm = this.argHandlers.get(namespace);
            if (mm == null) {
                return Collections.emptyList();
            }
            ArrayList<String> l = new ArrayList<String>(mm.keySet());
            this.sort(l);
            return l;
        }
    }

    private static String getCommandKey(String namespace, String command) {
        return namespace + " " + command;
    }

    public String getDescription(String namespace, String command) {
        if (this.descriptions.containsKey(AvailableCommandsImpl.getCommandKey(namespace, command))) {
            return this.descriptions.get(AvailableCommandsImpl.getCommandKey(namespace, command));
        }
        return "";
    }

    public String getLongDescription(String namespace, String command) {
        if (this.longDescriptions.containsKey(AvailableCommandsImpl.getCommandKey(namespace, command))) {
            return this.longDescriptions.get(AvailableCommandsImpl.getCommandKey(namespace, command));
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getArguments(String namespace, String command) {
        Object object = this.lock;
        synchronized (object) {
            Map<String, Map<String, ArgHandler>> mm = this.argHandlers.get(namespace);
            if (mm == null) {
                return Collections.emptyList();
            }
            Map<String, ArgHandler> ll = mm.get(command);
            if (ll == null) {
                if (this.commands.containsKey(namespace + " " + command)) {
                    ll = this.getArgs(this.commands.get(namespace + " " + command));
                    mm.put(command, ll);
                } else {
                    return Collections.emptyList();
                }
            }
            ArrayList<String> l = new ArrayList<String>();
            for (ArgHandler ah : ll.values()) {
                l.add(this.makeFirstLower(ah.getName()));
            }
            this.sort(l);
            return l;
        }
    }

    public boolean getArgRequired(String namespace, String command, String argument) {
        Map<String, ArgHandler> map = this.getArgMap(namespace, command, argument);
        if (map != null && map.containsKey(argument)) {
            return map.get(argument).getRequired();
        }
        return false;
    }

    public String getArgTooltip(String namespace, String command, String argument) {
        Map<String, ArgHandler> map = this.getArgMap(namespace, command, argument);
        if (map != null && map.containsKey(argument)) {
            return map.get(argument).getTooltip();
        }
        return null;
    }

    public String getArgDescription(String namespace, String command, String argument) {
        Map<String, ArgHandler> map = this.getArgMap(namespace, command, argument);
        if (map != null && map.containsKey(argument)) {
            return map.get(argument).getDescription();
        }
        return null;
    }

    public String getArgLongDescription(String namespace, String command, String argument) {
        Map<String, ArgHandler> map = this.getArgMap(namespace, command, argument);
        if (map != null && map.containsKey(argument)) {
            return map.get(argument).getLongDescription();
        }
        return null;
    }

    public String getArgExampleStringValue(String namespace, String command, String argument) {
        Map<String, ArgHandler> map = this.getArgMap(namespace, command, argument);
        if (map != null && map.containsKey(argument)) {
            return map.get(argument).getExampleStringValue();
        }
        return null;
    }

    public Class<?> getArgType(String namespace, String command, String argument) {
        Map<String, ArgHandler> map = this.getArgMap(namespace, command, argument);
        if (map != null && map.containsKey(argument)) {
            return map.get(argument).getType();
        }
        return null;
    }

    public Object getArgValue(String namespace, String command, String argument) {
        Map<String, ArgHandler> map = this.getArgMap(namespace, command, argument);
        if (map != null && map.containsKey(argument)) {
            try {
                return map.get(argument).getValue();
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public String getArgTypeString(String namespace, String command, String argument) {
        Map<String, ArgHandler> map = this.getArgMap(namespace, command, argument);
        if (map != null && map.containsKey(argument)) {
            return map.get(argument).getDesc();
        }
        return null;
    }

    public void addTaskFactory(TaskFactory tf, Map<?, ?> props) {
        this.addCommand(tf, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNetworkTaskFactory(NetworkTaskFactory tf, Map<?, ?> props) {
        TaskFactory provisioner = this.factoryProvisioner.createFor(tf);
        Object object = this.lock;
        synchronized (object) {
            this.provisioners.put(tf, provisioner);
            this.addCommand(provisioner, props);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNetworkViewTaskFactory(NetworkViewTaskFactory tf, Map<?, ?> props) {
        TaskFactory provisioner = this.factoryProvisioner.createFor(tf);
        Object object = this.lock;
        synchronized (object) {
            this.provisioners.put(tf, provisioner);
            this.addCommand(provisioner, props);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNetworkViewCollectionTaskFactory(NetworkViewCollectionTaskFactory tf, Map<?, ?> props) {
        TaskFactory provisioner = this.factoryProvisioner.createFor(tf);
        Object object = this.lock;
        synchronized (object) {
            this.provisioners.put(tf, provisioner);
            this.addCommand(provisioner, props);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTableTaskFactory(TableTaskFactory tf, Map<?, ?> props) {
        TaskFactory provisioner = this.factoryProvisioner.createFor(tf);
        Object object = this.lock;
        synchronized (object) {
            this.provisioners.put(tf, provisioner);
            this.addCommand(provisioner, props);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTaskFactory(TaskFactory tf, Map<?, ?> props) {
        Object object = this.lock;
        synchronized (object) {
            this.removeCommand(this.provisioners.remove(tf), props);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNetworkTaskFactory(NetworkTaskFactory tf, Map<?, ?> props) {
        Object object = this.lock;
        synchronized (object) {
            this.removeCommand(this.provisioners.remove(tf), props);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNetworkViewTaskFactory(NetworkViewTaskFactory tf, Map<?, ?> props) {
        Object object = this.lock;
        synchronized (object) {
            this.removeCommand(this.provisioners.remove(tf), props);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNetworkViewCollectionTaskFactory(NetworkViewCollectionTaskFactory tf, Map<?, ?> props) {
        Object object = this.lock;
        synchronized (object) {
            this.removeCommand(this.provisioners.remove(tf), props);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTableTaskFactory(TableTaskFactory tf, Map<?, ?> props) {
        Object object = this.lock;
        synchronized (object) {
            this.removeCommand(this.provisioners.remove(tf), props);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCommand(TaskFactory tf, Map<?, ?> properties) {
        String namespace = (String)properties.get("commandNamespace");
        String command = (String)properties.get("command");
        String description = (String)properties.get("commandDescription");
        String longDescription = (String)properties.get("commandLongDescription");
        String exampleJSON = (String)properties.get("commandExampleJSON");
        String supportsJSONString = (String)properties.get("commandSupportsJSON");
        Boolean supportsJSON = false;
        if (supportsJSONString != null) {
            supportsJSON = Boolean.parseBoolean(supportsJSONString);
        }
        if (command == null || namespace == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            String commandKey = AvailableCommandsImpl.getCommandKey(namespace, command);
            this.commands.put(commandKey, tf);
            this.descriptions.put(commandKey, description);
            this.longDescriptions.put(commandKey, longDescription);
            this.exampleJSONs.put(commandKey, exampleJSON);
            this.supportsJSONs.put(commandKey, supportsJSON);
            Object args = null;
            Map<String, Map<String, ArgHandler>> mm = this.argHandlers.get(namespace);
            if (mm == null) {
                mm = new HashMap<String, Map<String, ArgHandler>>();
                this.argHandlers.put(namespace, mm);
            }
            mm.put(command, (Map<String, ArgHandler>)args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCommand(TaskFactory tf, Map<?, ?> properties) {
        String namespace = (String)properties.get("commandNamespace");
        String command = (String)properties.get("command");
        Object object = this.lock;
        synchronized (object) {
            String commandKey = AvailableCommandsImpl.getCommandKey(namespace, command);
            this.descriptions.remove(commandKey);
            this.longDescriptions.remove(commandKey);
            this.supportsJSONs.remove(commandKey);
            this.exampleJSONs.remove(commandKey);
            TaskFactory l = this.commands.remove(commandKey);
            if (l == null) {
                return;
            }
            Map<String, Map<String, ArgHandler>> m = this.argHandlers.get(namespace);
            if (m != null) {
                m.remove(command);
            }
            if (m.isEmpty()) {
                this.argHandlers.remove(namespace);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ArgHandler> getArgMap(String namespace, String command, String arg) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.argHandlers.containsKey(namespace)) {
                return null;
            }
            if (!this.argHandlers.get(namespace).containsKey(command)) {
                return null;
            }
            Map<String, ArgHandler> map = this.argHandlers.get(namespace).get(command);
            if (map == null) {
                map = this.getArgs(this.commands.get(namespace + " " + command));
                this.argHandlers.get(namespace).put(command, map);
            }
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ArgHandler> getArgs(TaskFactory tf) {
        boolean resetNetwork = this.setCurrentNetwork();
        boolean resetView = this.setCurrentNetworkView();
        try {
            TaskIterator ti = tf.createTaskIterator();
            if (ti == null) {
                Map<String, ArgHandler> map = Collections.emptyMap();
                return map;
            }
            HashMap<String, ArgHandler> argMap = new HashMap<String, ArgHandler>();
            while (ti.hasNext()) {
                Task task = ti.next();
                List handlers = this.argRec.getHandlers(task);
                for (ArgHandler h : handlers) {
                    String context = h.getContext();
                    if (context.equals("gui")) continue;
                    argMap.put(this.makeFirstLower(h.getName()), h);
                }
            }
            HashMap<String, ArgHandler> hashMap = argMap;
            return hashMap;
        }
        catch (Exception e) {
            logger.debug("Could not create invocation string for command.", (Throwable)e);
            e.printStackTrace();
            Map<String, ArgHandler> map = Collections.emptyMap();
            return map;
        }
        finally {
            this.resetCurrentNetworkView(resetView);
            this.resetCurrentNetwork(resetNetwork);
        }
    }

    private void sort(List<String> list) {
        final Collator collator = Collator.getInstance(Locale.getDefault());
        Collections.sort(list, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return collator.compare(s1, s2);
            }
        });
    }

    private void getServices() {
        if (this.netMgr == null) {
            this.netMgr = (CyNetworkManager)this.serviceRegistrar.getService(CyNetworkManager.class);
            this.netViewMgr = (CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class);
        }
    }

    private CyNetwork getNetwork() {
        if (this.appMgr.getCurrentNetwork() != null) {
            return this.appMgr.getCurrentNetwork();
        }
        if (this.emptyNetwork == null) {
            this.emptyNetwork = ((CyNetworkFactory)this.serviceRegistrar.getService(CyNetworkFactory.class)).createNetwork(SavePolicy.DO_NOT_SAVE);
            this.emptyNetwork.getRow((CyIdentifiable)this.emptyNetwork).set("name", (Object)"cy:command_documentation_generation");
        }
        return this.emptyNetwork;
    }

    private boolean setCurrentNetwork() {
        if (this.appMgr.getCurrentNetwork() == null) {
            this.getServices();
            this.getNetwork();
            this.netMgr.addNetwork(this.emptyNetwork, true);
            return true;
        }
        return false;
    }

    private void resetCurrentNetwork(boolean reset) {
        if (!reset) {
            return;
        }
        this.appMgr.setCurrentNetwork(null);
        this.netMgr.destroyNetwork(this.emptyNetwork);
        this.emptyNetwork = null;
    }

    private CyNetworkView getNetworkView() {
        if (this.appMgr.getCurrentNetworkView() != null) {
            return this.appMgr.getCurrentNetworkView();
        }
        if (this.emptyView == null) {
            this.emptyView = ((CyNetworkViewFactory)this.serviceRegistrar.getService(CyNetworkViewFactory.class)).createNetworkView(this.getNetwork());
        }
        return this.emptyView;
    }

    private boolean setCurrentNetworkView() {
        if (this.appMgr.getCurrentNetworkView() == null) {
            this.getServices();
            this.getNetworkView();
            this.netViewMgr.addNetworkView(this.emptyView, true);
            return true;
        }
        return false;
    }

    private void resetCurrentNetworkView(boolean reset) {
        if (!reset) {
            return;
        }
        this.appMgr.setCurrentNetworkView(null);
        this.netViewMgr.destroyNetworkView(this.emptyView);
        this.emptyView = null;
    }

    public boolean getSupportsJSON(String namespace, String command) {
        if (this.supportsJSONs.containsKey(AvailableCommandsImpl.getCommandKey(namespace, command))) {
            return this.supportsJSONs.get(AvailableCommandsImpl.getCommandKey(namespace, command));
        }
        return false;
    }

    public String getExampleJSON(String namespace, String command) {
        if (this.exampleJSONs.containsKey(AvailableCommandsImpl.getCommandKey(namespace, command))) {
            return this.exampleJSONs.get(AvailableCommandsImpl.getCommandKey(namespace, command));
        }
        return "";
    }

    private String makeFirstLower(String string) {
        return Character.toLowerCase(string.charAt(0)) + (string.length() > 1 ? string.substring(1) : "");
    }

    class StaticTaskFactoryProvisioner {
        StaticTaskFactoryProvisioner() {
        }

        TaskFactory createFor(final NetworkTaskFactory factory) {
            return new AbstractTaskFactory(){

                public TaskIterator createTaskIterator() {
                    CyApplicationManager appMgr = (CyApplicationManager)AvailableCommandsImpl.this.serviceRegistrar.getService(CyApplicationManager.class);
                    WeakReference<CyNetwork> reference = new WeakReference<CyNetwork>(appMgr.getCurrentNetwork());
                    return factory.createTaskIterator((CyNetwork)reference.get());
                }
            };
        }

        TaskFactory createFor(final NetworkViewTaskFactory factory) {
            return new AbstractTaskFactory(){

                public TaskIterator createTaskIterator() {
                    CyApplicationManager appMgr = (CyApplicationManager)AvailableCommandsImpl.this.serviceRegistrar.getService(CyApplicationManager.class);
                    WeakReference<CyNetworkView> reference = new WeakReference<CyNetworkView>(appMgr.getCurrentNetworkView());
                    return factory.createTaskIterator((CyNetworkView)reference.get());
                }
            };
        }

        TaskFactory createFor(final NetworkViewCollectionTaskFactory factory) {
            return new AbstractTaskFactory(){

                public TaskIterator createTaskIterator() {
                    ArrayList<CyNetworkView> views = new ArrayList<CyNetworkView>();
                    CyApplicationManager appMgr = (CyApplicationManager)AvailableCommandsImpl.this.serviceRegistrar.getService(CyApplicationManager.class);
                    views.add(appMgr.getCurrentNetworkView());
                    WeakReference reference = new WeakReference(views);
                    return factory.createTaskIterator((Collection)reference.get());
                }
            };
        }

        TaskFactory createFor(final TableTaskFactory factory) {
            return new AbstractTaskFactory(){

                public TaskIterator createTaskIterator() {
                    CyApplicationManager appMgr = (CyApplicationManager)AvailableCommandsImpl.this.serviceRegistrar.getService(CyApplicationManager.class);
                    WeakReference<CyTable> reference = new WeakReference<CyTable>(appMgr.getCurrentNetwork().getDefaultNetworkTable());
                    return factory.createTaskIterator((CyTable)reference.get());
                }
            };
        }
    }
}

