/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.command.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.command.StringToModel;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringToModelImpl
implements StringToModel {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private static final String ALL = "all";
    private static final String CURRENT = "current";
    private static final String NAME = "name";
    private static final String SELECTED = "selected";
    private static final String SUID = "suid";
    private static final String UNSELECTED = "unselected";
    private final CyServiceRegistrar serviceRegistrar;

    public StringToModelImpl(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    public CyNetwork getNetwork(String strNet) {
        if (strNet == null || strNet.length() == 0 || strNet.equalsIgnoreCase(CURRENT)) {
            return ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetwork();
        }
        CyNetworkManager netMgr = (CyNetworkManager)this.serviceRegistrar.getService(CyNetworkManager.class);
        String[] splitString = strNet.split(":");
        if (splitString.length > 1) {
            if (SUID.equalsIgnoreCase(splitString[0])) {
                Long suid = this.getLong(splitString[1]);
                if (suid == null) {
                    return null;
                }
                return netMgr.getNetwork(suid.longValue());
            }
            if (NAME.equalsIgnoreCase(splitString[0])) {
                strNet = splitString[1];
            }
        }
        for (CyNetwork net : netMgr.getNetworkSet()) {
            if (!strNet.equalsIgnoreCase((String)net.getRow((CyIdentifiable)net).get(NAME, String.class))) continue;
            return net;
        }
        return null;
    }

    public CyNetworkView getNetworkView(String strNet) {
        if (strNet == null || strNet.length() == 0 || strNet.equalsIgnoreCase(CURRENT)) {
            return ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetworkView();
        }
        CyNetworkManager netMgr = (CyNetworkManager)this.serviceRegistrar.getService(CyNetworkManager.class);
        CyNetworkViewManager netViewMgr = (CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class);
        String[] splitString = strNet.split(":");
        if (splitString.length > 1) {
            if (SUID.equalsIgnoreCase(splitString[0])) {
                Long suid = this.getLong(splitString[1]);
                if (suid == null) {
                    return null;
                }
                for (CyNetworkView view : netViewMgr.getNetworkViewSet()) {
                    if (!view.getSUID().equals(suid)) continue;
                    return view;
                }
                return null;
            }
            if (NAME.equalsIgnoreCase(splitString[0])) {
                strNet = splitString[1];
            }
        }
        for (CyNetwork net : netMgr.getNetworkSet()) {
            Iterator iterator;
            if (!strNet.equalsIgnoreCase((String)net.getRow((CyIdentifiable)net).get(NAME, String.class)) || !netViewMgr.viewExists(net) || !(iterator = netViewMgr.getNetworkViews(net).iterator()).hasNext()) continue;
            CyNetworkView view = (CyNetworkView)iterator.next();
            return view;
        }
        return null;
    }

    public CyTable getTable(String strTable) {
        if (strTable == null || strTable.length() == 0 || strTable.equalsIgnoreCase(CURRENT)) {
            return ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentTable();
        }
        String[] splitString = strTable.split(":");
        if (splitString.length > 1) {
            CyNetwork network;
            if (splitString[0].equalsIgnoreCase("node") && (network = this.getNetwork(splitString[1])) != null) {
                return network.getDefaultNodeTable();
            }
            if (splitString[0].equalsIgnoreCase("edge") && (network = this.getNetwork(splitString[1])) != null) {
                return network.getDefaultEdgeTable();
            }
            if (splitString[0].equalsIgnoreCase("network") && (network = this.getNetwork(splitString[1])) != null) {
                return network.getDefaultNetworkTable();
            }
        } else {
            CyTableManager tableMgr = (CyTableManager)this.serviceRegistrar.getService(CyTableManager.class);
            for (CyTable tab : tableMgr.getGlobalTables()) {
                if (!tab.getTitle().contains(strTable)) continue;
                return tab;
            }
        }
        return null;
    }

    public List<CyNode> getNodeList(CyNetwork net, String nodeList) {
        if (net == null) {
            net = this.getNetwork(null);
        }
        if (nodeList.equalsIgnoreCase(ALL)) {
            return net.getNodeList();
        }
        if (nodeList.equalsIgnoreCase(SELECTED)) {
            return CyTableUtil.getNodesInState((CyNetwork)net, (String)SELECTED, (boolean)true);
        }
        if (nodeList.equalsIgnoreCase(UNSELECTED)) {
            return CyTableUtil.getNodesInState((CyNetwork)net, (String)SELECTED, (boolean)false);
        }
        CyTable table = net instanceof CyRootNetwork ? ((CyRootNetwork)net).getSharedNodeTable() : net.getDefaultNodeTable();
        Set<CyRow> rows = this.parseList(nodeList, table);
        if (rows == null) {
            return null;
        }
        ArrayList<CyNode> nodes = new ArrayList<CyNode>();
        for (CyRow row : rows) {
            Long suid = (Long)row.get("SUID", Long.class);
            nodes.add(net.getNode(suid.longValue()));
        }
        return nodes;
    }

    public List<CyEdge> getEdgeList(CyNetwork net, String edgeList) {
        if (net == null) {
            net = this.getNetwork(null);
        }
        if (edgeList.equalsIgnoreCase(ALL)) {
            return net.getEdgeList();
        }
        if (edgeList.equalsIgnoreCase(SELECTED)) {
            return CyTableUtil.getEdgesInState((CyNetwork)net, (String)SELECTED, (boolean)true);
        }
        if (edgeList.equalsIgnoreCase(UNSELECTED)) {
            return CyTableUtil.getEdgesInState((CyNetwork)net, (String)SELECTED, (boolean)false);
        }
        CyTable table = net instanceof CyRootNetwork ? ((CyRootNetwork)net).getSharedEdgeTable() : net.getDefaultEdgeTable();
        Set<CyRow> rows = this.parseList(edgeList, table);
        if (rows == null) {
            return null;
        }
        ArrayList<CyEdge> edges = new ArrayList<CyEdge>();
        for (CyRow row : rows) {
            Long suid = (Long)row.get("SUID", Long.class);
            edges.add(net.getEdge(suid.longValue()));
        }
        return edges;
    }

    public List<CyRow> getRowList(CyTable table, String rowList) {
        if (table == null) {
            return null;
        }
        if (rowList.equalsIgnoreCase(ALL)) {
            return table.getAllRows();
        }
        Set<CyRow> rows = this.parseList(rowList, table);
        if (rows == null) {
            return null;
        }
        return new ArrayList<CyRow>(rows);
    }

    private Set<CyRow> parseList(String list, CyTable table) {
        HashSet<CyRow> rows = new HashSet<CyRow>();
        HashMap<String, List<String>> columnMap = new HashMap<String, List<String>>();
        String[] split = list.split("(?<!\\\\),");
        for (String token : split) {
            String[] t = (token = token.replaceAll("\\\\,", ",")).trim().split("(?<!\\\\):");
            if (t.length >= 2) {
                String attribute = t[0];
                CharSequence[] slice = Arrays.copyOfRange(t, 1, t.length);
                String value = String.join((CharSequence)":", slice);
                attribute = attribute.replaceAll("\\\\:", ":");
                value = value.replaceAll("\\\\:", ":");
                if (SUID.equalsIgnoreCase(attribute)) {
                    Long suid = this.getLong(value);
                    if (suid == null || !table.rowExists((Object)suid)) continue;
                    rows.add(table.getRow((Object)suid));
                    continue;
                }
                this.updateMap(columnMap, attribute, value);
                continue;
            }
            String value = t[0];
            value = value.replaceAll("\\\\:", ":");
            this.updateMap(columnMap, NAME, value);
        }
        if (columnMap.size() == 0) {
            return rows;
        }
        for (CyRow row : table.getAllRows()) {
            for (String key : columnMap.keySet()) {
                Object rawValue;
                if (table.getColumn(key) == null || (rawValue = row.getRaw(key)) == null) continue;
                String rowValue = rawValue.toString();
                for (String value : (List)columnMap.get(key)) {
                    if (!rowValue.equalsIgnoreCase(value)) continue;
                    rows.add(row);
                }
            }
        }
        return rows;
    }

    private void updateMap(Map<String, List<String>> map, String key, String value) {
        if (!map.containsKey(key)) {
            map.put(key, new ArrayList());
        }
        map.get(key).add(value);
    }

    private Long getLong(String value) {
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

