/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.command.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import org.cytoscape.command.internal.CommandExecutorImpl;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.TaskObserver;
import org.cytoscape.work.Tunable;

public class CommandFileExecutorTask
extends AbstractTask {
    @Tunable(description="Select the command file:", params="input=true")
    public File file;
    private final CommandExecutorImpl cei;
    private final TaskObserver observer;

    public CommandFileExecutorTask(CommandExecutorImpl cei, TaskObserver observer) {
        this.cei = cei;
        this.observer = observer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TaskMonitor tm) throws Exception {
        if (this.file == null) {
            throw new NullPointerException("You must specify a non-null command file to load.");
        }
        FileReader fin = null;
        BufferedReader bin = null;
        try {
            String s;
            fin = new FileReader(this.file);
            bin = new BufferedReader(fin);
            ArrayList<String> lines = new ArrayList<String>();
            while ((s = bin.readLine()) != null) {
                lines.add(s.trim());
            }
            this.cei.executeList(lines, tm, this.observer);
        }
        finally {
            if (bin != null) {
                bin.close();
            }
            if (fin != null) {
                fin.close();
            }
        }
    }
}

