/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.command.internal;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cytoscape.command.CommandExecutorTaskFactory;
import org.cytoscape.command.internal.CommandExecutorImpl;
import org.cytoscape.command.internal.CommandExecutorTask;
import org.cytoscape.command.internal.CommandFileExecutorTask;
import org.cytoscape.command.internal.CommandStringsExecutorTask;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.work.AbstractTaskFactory;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskObserver;
import org.cytoscape.work.TunableSetter;

public class CommandExecutorTaskFactoryImpl
extends AbstractTaskFactory
implements CommandExecutorTaskFactory {
    private final CommandExecutorImpl commandExecutor;
    private final CyServiceRegistrar serviceRegistrar;

    public CommandExecutorTaskFactoryImpl(CommandExecutorImpl cei, CyServiceRegistrar serviceRegistrar) {
        this.commandExecutor = cei;
        this.serviceRegistrar = serviceRegistrar;
    }

    public TaskIterator createTaskIterator() {
        return this.createTaskIterator(null);
    }

    public TaskIterator createTaskIterator(TaskObserver observer) {
        return new TaskIterator(new Task[]{new CommandFileExecutorTask(this.commandExecutor, observer)});
    }

    public TaskIterator createTaskIterator(File file, TaskObserver observer) {
        HashMap<String, File> m = new HashMap<String, File>();
        m.put("file", file);
        return ((TunableSetter)this.serviceRegistrar.getService(TunableSetter.class)).createTaskIterator(this.createTaskIterator(observer), m, observer);
    }

    public TaskIterator createTaskIterator(TaskObserver observer, String ... commands) {
        return this.createTaskIterator(Arrays.asList(commands), observer);
    }

    public TaskIterator createTaskIterator(List<String> commands, TaskObserver observer) {
        return new TaskIterator(new Task[]{new CommandStringsExecutorTask(commands, this.commandExecutor, observer)});
    }

    public TaskIterator createTaskIterator(String namespace, String command, Map<String, Object> args, TaskObserver observer) {
        return new TaskIterator(new Task[]{new CommandExecutorTask(namespace, command, args, this.commandExecutor, observer)});
    }
}

