/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.model.internal.table;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.cytoscape.event.CyEvent;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.model.events.TableAboutToBeDeletedEvent;
import org.cytoscape.model.events.TableAboutToBeDeletedListener;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.events.TableViewAboutToBeDestroyedEvent;
import org.cytoscape.view.model.events.TableViewAddedEvent;
import org.cytoscape.view.model.events.TableViewDestroyedEvent;
import org.cytoscape.view.model.table.CyTableView;
import org.cytoscape.view.model.table.CyTableViewManager;
import org.cytoscape.view.presentation.property.table.BasicTableVisualLexicon;

public class CyTableViewManagerImpl
implements CyTableViewManager,
TableAboutToBeDeletedListener {
    private final CyServiceRegistrar registrar;
    private final Map<CyTable, CyTableView> tableViewMap;
    private final Set<CyTableView> viewsAboutToBeDestroyed;
    private final Object lock = new Object();

    public CyTableViewManagerImpl(CyServiceRegistrar registrar) {
        this.registrar = registrar;
        this.tableViewMap = new WeakHashMap<CyTable, CyTableView>();
        this.viewsAboutToBeDestroyed = new HashSet<CyTableView>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.lock;
        synchronized (object) {
            this.tableViewMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(TableAboutToBeDeletedEvent e) {
        CyTable table = e.getTable();
        Object object = this.lock;
        synchronized (object) {
            CyTableView view = this.getTableView(table);
            this.destroyTableView(view);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<CyTableView> getTableViewSet() {
        LinkedHashSet<CyTableView> views = new LinkedHashSet<CyTableView>();
        Object object = this.lock;
        synchronized (object) {
            views.addAll(this.tableViewMap.values());
            views.removeAll(this.viewsAboutToBeDestroyed);
        }
        return views;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CyTableView getTableView(CyTable table) {
        Object object = this.lock;
        synchronized (object) {
            return this.tableViewMap.get(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTableView(CyTableView view) {
        if (view == null) {
            return;
        }
        CyTable table = (CyTable)view.getModel();
        CyTableManager tableManager = (CyTableManager)this.registrar.getService(CyTableManager.class);
        Object object = this.lock;
        synchronized (object) {
            boolean gravitySet;
            if (tableManager.getTable(table.getSUID().longValue()) == null) {
                throw new IllegalArgumentException("Table view cannot be added, because its table (" + table + ") is not registered");
            }
            CyTableView existingView = this.getTableView(table);
            if (existingView != null) {
                this.destroyTableView(existingView);
            }
            View suidCol = view.getColumnView("SUID");
            View selectedCol = view.getColumnView("selected");
            if (suidCol != null) {
                suidCol.setVisualProperty(BasicTableVisualLexicon.COLUMN_VISIBLE, (Object)false);
            }
            if (selectedCol != null) {
                selectedCol.setVisualProperty(BasicTableVisualLexicon.COLUMN_VISIBLE, (Object)false);
            }
            if (!(gravitySet = view.getColumnViews().stream().anyMatch(c -> !((Double)BasicTableVisualLexicon.COLUMN_GRAVITY.getDefault()).equals(c.getVisualProperty(BasicTableVisualLexicon.COLUMN_GRAVITY))))) {
                if (suidCol != null) {
                    suidCol.setVisualProperty(BasicTableVisualLexicon.COLUMN_GRAVITY, (Object)((Double)BasicTableVisualLexicon.COLUMN_GRAVITY.getDefault() - 2.0));
                }
                if (selectedCol != null) {
                    selectedCol.setVisualProperty(BasicTableVisualLexicon.COLUMN_GRAVITY, (Object)((Double)BasicTableVisualLexicon.COLUMN_GRAVITY.getDefault() - 1.0));
                }
                double grav = (Double)BasicTableVisualLexicon.COLUMN_GRAVITY.getDefault();
                for (View colView : view.getColumnViews()) {
                    if (colView == null || colView == suidCol || colView == selectedCol) continue;
                    colView.setLockedValue(BasicTableVisualLexicon.COLUMN_GRAVITY, (Object)grav);
                    grav += 1.0;
                }
            }
            this.tableViewMap.put(table, view);
        }
        this.fireEvent((CyEvent<?>)new TableViewAddedEvent((CyTableViewManager)this, view));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyTableView(CyTableView view) {
        if (view == null) {
            return;
        }
        CyTable table = (CyTable)view.getModel();
        Object object = this.lock;
        synchronized (object) {
            if (!this.tableViewMap.containsKey(table)) {
                throw new IllegalArgumentException("table view is not recognized");
            }
            this.viewsAboutToBeDestroyed.add(view);
        }
        this.fireEvent((CyEvent<?>)new TableViewAboutToBeDestroyedEvent((CyTableViewManager)this, view));
        object = this.lock;
        synchronized (object) {
            if (!this.tableViewMap.containsKey(table)) {
                throw new IllegalArgumentException("table view is not recognized");
            }
            this.tableViewMap.remove(table);
            this.viewsAboutToBeDestroyed.remove(view);
            view.dispose();
        }
        this.fireEvent((CyEvent<?>)new TableViewDestroyedEvent((CyTableViewManager)this));
        view = null;
    }

    private void fireEvent(CyEvent<?> event) {
        ((CyEventHelper)this.registrar.getService(CyEventHelper.class)).fireEvent(event);
    }
}

