/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.model.internal.network.snapshot;

import io.vavr.collection.Map;
import io.vavr.collection.Set;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.model.CyNetworkViewSnapshot;
import org.cytoscape.view.model.SnapshotEdgeInfo;
import org.cytoscape.view.model.SnapshotNodeInfo;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.model.internal.base.VPStore;
import org.cytoscape.view.model.internal.network.CyEdgeViewImpl;
import org.cytoscape.view.model.internal.network.CyNetworkViewImpl;
import org.cytoscape.view.model.internal.network.CyNodeViewImpl;
import org.cytoscape.view.model.internal.network.VPEdgeStore;
import org.cytoscape.view.model.internal.network.VPNetworkStore;
import org.cytoscape.view.model.internal.network.VPNodeStore;
import org.cytoscape.view.model.internal.network.snapshot.CyEdgeViewSnapshotImpl;
import org.cytoscape.view.model.internal.network.snapshot.CyNodeViewSnapshotImpl;
import org.cytoscape.view.model.internal.network.snapshot.CyViewSnapshotBase;
import org.cytoscape.view.model.internal.network.spacial.SimpleSpacialIndex2DSnapshotImpl;
import org.cytoscape.view.model.spacial.NetworkSpacialIndex2D;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;

public class CyNetworkViewSnapshotImpl
extends CyViewSnapshotBase<CyNetwork>
implements CyNetworkViewSnapshot {
    private final String rendererId;
    private final CyNetworkViewImpl networkView;
    private final Map<Long, CyNodeViewImpl> dataSuidToNode;
    private final Map<Long, CyNodeViewImpl> viewSuidToNode;
    private final Map<Long, CyEdgeViewImpl> dataSuidToEdge;
    private final Map<Long, CyEdgeViewImpl> viewSuidToEdge;
    private final Map<Long, Set<CyEdgeViewImpl>> adjacentEdgeMap;
    protected final VPNodeStore nodeVPs;
    protected final VPEdgeStore edgeVPs;
    protected final VPNetworkStore netVPs;
    private final NetworkSpacialIndex2D spacialIndex;
    private final boolean isBVL;
    private final java.util.Map<Long, CyNodeViewSnapshotImpl> snapshotNodeViews = new ConcurrentHashMap<Long, CyNodeViewSnapshotImpl>();
    private final java.util.Map<Long, CyEdgeViewSnapshotImpl> snapshotEdgeViews = new ConcurrentHashMap<Long, CyEdgeViewSnapshotImpl>();
    private final boolean isNeverHidden;

    public CyNetworkViewSnapshotImpl(CyNetworkViewImpl networkView, String rendererId, Map<Long, CyNodeViewImpl> dataSuidToNode, Map<Long, CyNodeViewImpl> viewSuidToNode, Map<Long, CyEdgeViewImpl> dataSuidToEdge, Map<Long, CyEdgeViewImpl> viewSuidToEdge, Map<Long, Set<CyEdgeViewImpl>> adjacentEdgeMap, VPNodeStore nodeVPs, VPEdgeStore edgeVPs, VPNetworkStore netVPs, VisualLexicon lexicon) {
        super(networkView.getSUID());
        this.networkView = networkView;
        this.rendererId = rendererId;
        this.viewSuidToNode = viewSuidToNode;
        this.dataSuidToNode = dataSuidToNode;
        this.viewSuidToEdge = viewSuidToEdge;
        this.dataSuidToEdge = dataSuidToEdge;
        this.adjacentEdgeMap = adjacentEdgeMap;
        this.nodeVPs = nodeVPs;
        this.edgeVPs = edgeVPs;
        this.netVPs = netVPs;
        this.isBVL = lexicon instanceof BasicVisualLexicon;
        this.isNeverHidden = networkView.isNeverHidden();
        this.spacialIndex = new SimpleSpacialIndex2DSnapshotImpl(this);
    }

    @Override
    public VPStore getVPStore() {
        return this.netVPs;
    }

    public boolean isBVL() {
        return this.isBVL;
    }

    private boolean isNodeVisible(Long nodeSuid) {
        if (!this.isBVL) {
            return true;
        }
        if (this.isNeverHidden) {
            return true;
        }
        return Boolean.TRUE.equals(this.nodeVPs.getVisualProperty(nodeSuid, BasicVisualLexicon.NODE_VISIBLE));
    }

    private boolean isNodeVisible(CyNodeViewImpl node) {
        if (!this.isBVL) {
            return true;
        }
        if (this.isNeverHidden) {
            return true;
        }
        return node.isVisible();
    }

    private boolean isEdgeVisible(CyEdgeViewImpl mutableEdgeView) {
        if (!this.isBVL) {
            return true;
        }
        if (this.isNeverHidden) {
            return true;
        }
        if (!mutableEdgeView.isVisible()) {
            return false;
        }
        if (!this.isNodeVisible(mutableEdgeView.getSourceSuid())) {
            return false;
        }
        return this.isNodeVisible(mutableEdgeView.getTargetSuid());
    }

    @Override
    protected <T> T getSpecialVisualProperty(Long suid, VisualProperty<T> vp) {
        if (this.getSUID().equals(suid)) {
            return this.netVPs.getSpecialVisualProperty(suid, vp);
        }
        return null;
    }

    protected CyNodeViewSnapshotImpl getSnapshotNodeView(CyNodeViewImpl mutableNodeView) {
        Long suid = mutableNodeView.getSUID();
        CyNodeViewSnapshotImpl view = this.snapshotNodeViews.get(suid);
        if (view == null && this.isNodeVisible(mutableNodeView)) {
            view = new CyNodeViewSnapshotImpl(this, mutableNodeView);
            this.snapshotNodeViews.put(suid, view);
        }
        return view;
    }

    protected CyEdgeViewSnapshotImpl getSnapshotEdgeView(CyEdgeViewImpl mutableEdgeView) {
        Long suid = mutableEdgeView.getSUID();
        CyEdgeViewSnapshotImpl view = this.snapshotEdgeViews.get(suid);
        if (view == null && this.isEdgeVisible(mutableEdgeView)) {
            view = new CyEdgeViewSnapshotImpl(this, mutableEdgeView);
            this.snapshotEdgeViews.put(suid, view);
        }
        return view;
    }

    @Override
    public CyNetworkViewSnapshotImpl getNetworkSnapshot() {
        return this;
    }

    public CyNetworkViewImpl getMutableNetworkView() {
        return this.networkView;
    }

    public NetworkSpacialIndex2D getSpacialIndex2D() {
        return this.spacialIndex;
    }

    public <T> T getViewDefault(VisualProperty<T> vp) {
        if (vp.getTargetDataType().equals(CyNode.class)) {
            return this.nodeVPs.getViewDefault(vp);
        }
        if (vp.getTargetDataType().equals(CyEdge.class)) {
            return this.edgeVPs.getViewDefault(vp);
        }
        if (vp.getTargetDataType().equals(CyNetwork.class)) {
            return this.netVPs.getViewDefault(vp);
        }
        return (T)vp.getDefault();
    }

    public View<CyNode> getNodeView(CyNode node) {
        CyNodeViewImpl view = (CyNodeViewImpl)this.dataSuidToNode.getOrElse((Object)node.getSUID(), null);
        return view == null ? null : this.getSnapshotNodeView(view);
    }

    public View<CyEdge> getEdgeView(CyEdge edge) {
        CyEdgeViewImpl view = (CyEdgeViewImpl)this.dataSuidToEdge.getOrElse((Object)edge.getSUID(), null);
        return view == null ? null : this.getSnapshotEdgeView(view);
    }

    public CyNodeViewSnapshotImpl getNodeView(long suid) {
        CyNodeViewImpl view = (CyNodeViewImpl)this.viewSuidToNode.getOrElse((Object)suid, null);
        return view == null ? null : this.getSnapshotNodeView(view);
    }

    public CyEdgeViewSnapshotImpl getEdgeView(long suid) {
        CyEdgeViewImpl view = (CyEdgeViewImpl)this.viewSuidToEdge.getOrElse((Object)suid, null);
        return view == null ? null : this.getSnapshotEdgeView(view);
    }

    public View<CyNode> getMutableNodeView(long suid) {
        return this.getMutableNetworkView().getNodeView(suid);
    }

    public View<CyEdge> getMutableEdgeView(long suid) {
        return this.getMutableNetworkView().getEdgeView(suid);
    }

    public List<View<CyNode>> getNodeViews() {
        ArrayList<View<CyNode>> nodeViews = new ArrayList<View<CyNode>>(this.viewSuidToNode.size());
        for (CyNodeViewImpl view : this.viewSuidToNode.values()) {
            CyNodeViewSnapshotImpl nv = this.getSnapshotNodeView(view);
            if (nv == null) continue;
            nodeViews.add(nv);
        }
        return nodeViews;
    }

    public List<CyNodeViewSnapshotImpl> getSnapshotNodeViews() {
        ArrayList<CyNodeViewSnapshotImpl> nodeViews = new ArrayList<CyNodeViewSnapshotImpl>(this.viewSuidToNode.size());
        for (CyNodeViewImpl view : this.viewSuidToNode.values()) {
            CyNodeViewSnapshotImpl nv = this.getSnapshotNodeView(view);
            if (nv == null) continue;
            nodeViews.add(nv);
        }
        return nodeViews;
    }

    public Collection<View<CyEdge>> getEdgeViews() {
        ArrayList<View<CyEdge>> edgeViews = new ArrayList<View<CyEdge>>(this.viewSuidToEdge.size());
        for (CyEdgeViewImpl view : this.viewSuidToEdge.values()) {
            CyEdgeViewSnapshotImpl ev = this.getSnapshotEdgeView(view);
            if (ev == null) continue;
            edgeViews.add(ev);
        }
        return edgeViews;
    }

    public Collection<View<? extends CyIdentifiable>> getAllViews() {
        ArrayList<View<? extends CyIdentifiable>> list = new ArrayList<View<? extends CyIdentifiable>>();
        list.addAll(this.getNodeViews());
        list.addAll(this.getEdgeViews());
        list.add(this);
        return list;
    }

    public Double getNodeZ(Long nodeViewSuid) {
        return (Double)this.nodeVPs.getVisualProperty(nodeViewSuid, BasicVisualLexicon.NODE_Z_LOCATION);
    }

    public Double getEdgeZ(Long edgeViewSuid) {
        return (Double)this.edgeVPs.getVisualProperty(edgeViewSuid, BasicVisualLexicon.EDGE_Z_ORDER);
    }

    public boolean hasEdgeZ() {
        return this.edgeVPs.hasZ();
    }

    public String getRendererId() {
        return this.rendererId;
    }

    public int getNodeCount() {
        return this.viewSuidToNode.size();
    }

    public boolean isEmpty() {
        return this.viewSuidToNode.isEmpty();
    }

    public int getEdgeCount() {
        return this.viewSuidToEdge.size();
    }

    public Iterable<View<CyEdge>> getAdjacentEdgeIterable(View<CyNode> nodeView) {
        return this.getAdjacentEdgeIterable(nodeView.getSUID());
    }

    public Iterable<View<CyEdge>> getAdjacentEdgeIterable(long nodeSuid) {
        ArrayList<View<CyEdge>> result = new ArrayList<View<CyEdge>>();
        for (CyEdgeViewImpl edgeViewImpl : (Set)this.adjacentEdgeMap.getOrElse((Object)nodeSuid, (Object)io.vavr.collection.HashSet.empty())) {
            CyEdgeViewSnapshotImpl ev = this.getSnapshotEdgeView(edgeViewImpl);
            if (ev == null) continue;
            result.add(ev);
        }
        return result;
    }

    public SnapshotEdgeInfo getEdgeInfo(View<CyEdge> edge) {
        return (SnapshotEdgeInfo)edge;
    }

    public SnapshotNodeInfo getNodeInfo(View<CyNode> node) {
        return (SnapshotNodeInfo)node;
    }

    public Collection<View<CyNode>> getTrackedNodes(Object key) {
        HashSet<View<CyNode>> nodes = new HashSet<View<CyNode>>();
        for (Long suid : this.nodeVPs.getTracked(key)) {
            CyNodeViewSnapshotImpl nv = this.getNodeView(suid);
            if (nv == null) continue;
            nodes.add(nv);
        }
        return nodes;
    }

    public int getTrackedNodeCount(Object key) {
        return this.nodeVPs.getTracked(key).size();
    }

    public boolean isTrackedNodeKey(Object key) {
        return this.nodeVPs.isTrackedKey(key);
    }

    public Collection<View<CyEdge>> getTrackedEdges(Object key) {
        HashSet<View<CyEdge>> edges = new HashSet<View<CyEdge>>();
        for (Long suid : this.edgeVPs.getTracked(key)) {
            CyEdgeViewSnapshotImpl ev = this.getEdgeView(suid);
            if (ev == null) continue;
            edges.add(ev);
        }
        return edges;
    }

    public int getTrackedEdgeCount(Object key) {
        return this.edgeVPs.getTracked(key).size();
    }

    public boolean isTrackedEdgeKey(Object key) {
        return this.edgeVPs.isTrackedKey(key);
    }

    public <T, V extends T> void setViewDefault(VisualProperty<? extends T> vp, V defaultValue) {
        throw new UnsupportedOperationException("Cannot modify view snapshot");
    }

    public void dispose() {
    }

    public void fitContent() {
    }

    public void fitSelected() {
    }

    public void updateView() {
    }
}

