/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.model.internal.network;

import io.vavr.collection.HashSet;
import io.vavr.collection.Set;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.model.internal.base.VPStore;
import org.cytoscape.view.model.internal.network.CyNetworkViewFactoryConfigImpl;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;

public class VPNetworkStore
extends VPStore {
    public static final Set<VisualProperty<?>> NETWORK_PROPS = HashSet.of((Object[])new VisualProperty[]{BasicVisualLexicon.NETWORK_CENTER_X_LOCATION, BasicVisualLexicon.NETWORK_CENTER_Y_LOCATION, BasicVisualLexicon.NETWORK_SCALE_FACTOR});
    private double networkCenterXLocation = (Double)BasicVisualLexicon.NETWORK_CENTER_X_LOCATION.getDefault();
    private double networkCenterYLocation = (Double)BasicVisualLexicon.NETWORK_CENTER_Y_LOCATION.getDefault();
    private double networkScaleFactor = (Double)BasicVisualLexicon.NETWORK_SCALE_FACTOR.getDefault();
    private boolean networkCenterXLocationSet = false;
    private boolean networkCenterYLocationSet = false;
    private boolean networkScaleFactorSet = false;

    public VPNetworkStore(VisualLexicon visualLexicon, CyNetworkViewFactoryConfigImpl config) {
        super(CyNetwork.class, visualLexicon, config);
    }

    private VPNetworkStore(VPNetworkStore other) {
        super(other);
        this.networkCenterXLocation = other.networkCenterXLocation;
        this.networkCenterYLocation = other.networkCenterYLocation;
        this.networkScaleFactor = other.networkScaleFactor;
        this.networkCenterXLocationSet = other.networkCenterXLocationSet;
        this.networkCenterYLocationSet = other.networkCenterYLocationSet;
        this.networkScaleFactorSet = other.networkScaleFactorSet;
    }

    @Override
    public VPNetworkStore createSnapshot() {
        return new VPNetworkStore(this);
    }

    @Override
    protected <T, V extends T> boolean setSpecialVisualProperty(Long suid, VisualProperty<? extends T> vp, V value) {
        if (vp == BasicVisualLexicon.NETWORK_CENTER_X_LOCATION) {
            if (value == null) {
                this.networkCenterXLocation = (Double)BasicVisualLexicon.NETWORK_CENTER_X_LOCATION.getDefault();
                this.networkCenterXLocationSet = false;
            } else {
                this.networkCenterXLocation = ((Number)value).doubleValue();
                this.networkCenterXLocationSet = true;
            }
            return true;
        }
        if (vp == BasicVisualLexicon.NETWORK_CENTER_Y_LOCATION) {
            if (value == null) {
                this.networkCenterYLocation = (Double)BasicVisualLexicon.NETWORK_CENTER_Y_LOCATION.getDefault();
                this.networkCenterYLocationSet = false;
            } else {
                this.networkCenterYLocation = ((Number)value).doubleValue();
                this.networkCenterYLocationSet = true;
            }
            return true;
        }
        if (vp == BasicVisualLexicon.NETWORK_SCALE_FACTOR) {
            if (value == null) {
                this.networkScaleFactor = (Double)BasicVisualLexicon.NETWORK_SCALE_FACTOR.getDefault();
                this.networkScaleFactorSet = false;
            } else {
                this.networkScaleFactor = ((Number)value).doubleValue();
                this.networkScaleFactorSet = true;
            }
            return true;
        }
        return false;
    }

    @Override
    public <T> T getSpecialVisualProperty(Long suid, VisualProperty<T> vp) {
        if (vp == BasicVisualLexicon.NETWORK_CENTER_X_LOCATION && this.networkCenterXLocationSet) {
            return (T)Double.valueOf(this.networkCenterXLocation);
        }
        if (vp == BasicVisualLexicon.NETWORK_CENTER_Y_LOCATION && this.networkCenterYLocationSet) {
            return (T)Double.valueOf(this.networkCenterYLocation);
        }
        if (vp == BasicVisualLexicon.NETWORK_SCALE_FACTOR && this.networkScaleFactorSet) {
            return (T)Double.valueOf(this.networkScaleFactor);
        }
        return null;
    }
}

