/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.model.internal.base;

import io.vavr.collection.HashMap;
import io.vavr.collection.HashSet;
import io.vavr.collection.Map;
import io.vavr.collection.Set;
import java.util.Objects;
import java.util.function.Predicate;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualLexiconNode;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.model.internal.base.NullViewConfigImpl;
import org.cytoscape.view.model.internal.base.VPStoreViewConfig;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;

public class VPStore {
    private final VisualLexicon visualLexicon;
    private Map<Long, Map<VisualProperty<?>, Object>> visualProperties = HashMap.empty();
    private Map<Long, Map<VisualProperty<?>, Object>> allLocks = HashMap.empty();
    private Map<Long, Map<VisualProperty<?>, Object>> directLocks = HashMap.empty();
    private Map<VisualProperty<?>, Object> defaultValues = HashMap.empty();
    private final VPStoreViewConfig config;
    private final Class<?> type;
    private Map<Object, Set<Long>> tracked = HashMap.empty();

    public VPStore(Class<?> type, VisualLexicon visualLexicon, VPStoreViewConfig config) {
        this.type = type;
        this.visualLexicon = visualLexicon;
        this.config = config == null ? new NullViewConfigImpl() : config;
    }

    protected VPStore(VPStore other) {
        this.type = other.type;
        this.visualLexicon = other.visualLexicon;
        this.visualProperties = other.visualProperties;
        this.allLocks = other.allLocks;
        this.directLocks = other.directLocks;
        this.defaultValues = other.defaultValues;
        this.tracked = other.tracked;
        this.config = other.config;
    }

    public VPStore createSnapshot() {
        return new VPStore(this);
    }

    public VPStoreViewConfig getConfig() {
        return this.config;
    }

    public Map<VisualProperty<?>, Object> getVisualPropertiesMap(Long suid) {
        return (Map)this.visualProperties.getOrElse((Object)suid, (Object)HashMap.empty());
    }

    public Map<VisualProperty<?>, Object> getAllLocksMap(Long suid) {
        return (Map)this.allLocks.getOrElse((Object)suid, (Object)HashMap.empty());
    }

    public Map<VisualProperty<?>, Object> getDirectLocksMap(Long suid) {
        return (Map)this.directLocks.getOrElse((Object)suid, (Object)HashMap.empty());
    }

    public Map<VisualProperty<?>, Object> getDefaultValues() {
        return this.defaultValues;
    }

    protected <T> T getSpecialVisualProperty(Long suid, VisualProperty<T> vp) {
        return null;
    }

    protected <T, V extends T> boolean setSpecialVisualProperty(Long suid, VisualProperty<? extends T> vp, V value) {
        return false;
    }

    private static <T, V extends T> Map<Long, Map<VisualProperty<?>, Object>> put(Map<Long, Map<VisualProperty<?>, Object>> map, Long suid, VisualProperty<? extends T> vp, V value) {
        Map values = (Map)map.getOrElse((Object)suid, (Object)HashMap.empty());
        Map map2 = values = value == null ? values.remove(vp) : values.put(vp, value);
        if (values.isEmpty()) {
            return map.remove((Object)suid);
        }
        return map.put((Object)suid, (Object)values);
    }

    public void remove(Long suid) {
        this.visualProperties = this.visualProperties.remove((Object)suid);
        this.allLocks = this.allLocks.remove((Object)suid);
        this.directLocks = this.directLocks.remove((Object)suid);
        this.removeTrackedVPs(suid);
    }

    public Set<VisualProperty<?>> getClearableVisualProperties(Long suid) {
        return ((Map)this.visualProperties.getOrElse((Object)suid, (Object)HashMap.empty())).keySet().removeAll(this.config.getNoClearVPs());
    }

    protected <T, V extends T> boolean setVisualProperty(Long suid, VisualProperty<? extends T> vp, V value) {
        if (this.setSpecialVisualProperty(suid, vp, value)) {
            return true;
        }
        if ("CELL_CUSTOMGRAPHICS".equals(vp.getIdString()) && value != null && value.getClass().getName().contains(".NullCellCustomGraphics")) {
            return false;
        }
        Object prevValue = this.getVisualPropertiesMap(suid).getOrElse(vp, null);
        if (!Objects.equals(prevValue, value)) {
            this.visualProperties = VPStore.put(this.visualProperties, suid, vp, value);
            this.updateTrackedVP(suid, vp);
            return true;
        }
        return false;
    }

    public <T> T getVisualProperty(Long suid, VisualProperty<T> vp) {
        Object value = this.getDirectLocksMap(suid).getOrElse(vp, null);
        if (value != null) {
            return (T)value;
        }
        value = this.getAllLocksMap(suid).getOrElse(vp, null);
        if (value != null) {
            return (T)value;
        }
        value = this.getSpecialVisualProperty(suid, vp);
        if (value != null) {
            return (T)value;
        }
        value = this.getVisualPropertiesMap(suid).getOrElse(vp, null);
        if (value != null) {
            return (T)value;
        }
        return (T)this.getDefaultValues().getOrElse(vp, vp.getDefault());
    }

    public boolean isSet(Long suid, VisualProperty<?> vp) {
        if (this.getDirectLocksMap(suid).containsKey(vp)) {
            return true;
        }
        if (this.getAllLocksMap(suid).containsKey(vp)) {
            return true;
        }
        if (this.getSpecialVisualProperty(suid, vp) != null) {
            return true;
        }
        return this.getVisualPropertiesMap(suid).containsKey(vp);
    }

    public <T, V extends T> boolean setLockedValue(Long suid, VisualProperty<? extends T> parentVP, V value) {
        boolean[] changed = new boolean[]{false};
        if (parentVP == BasicVisualLexicon.NODE_SELECTED || parentVP == BasicVisualLexicon.EDGE_SELECTED) {
            return false;
        }
        changed[0] = changed[0] | VPStore.isChanged(this.directLocks, suid, parentVP, value);
        this.directLocks = VPStore.put(this.directLocks, suid, parentVP, value);
        changed[0] = changed[0] | VPStore.isChanged(this.allLocks, suid, parentVP, value);
        this.allLocks = VPStore.put(this.allLocks, suid, parentVP, value);
        this.updateTrackedVP(suid, parentVP);
        VisualLexiconNode node = this.visualLexicon.getVisualLexiconNode(parentVP);
        node.visitDescendants(n -> {
            VisualProperty vp = n.getVisualProperty();
            if (!this.isDirectlyLocked(suid, vp) && parentVP.getClass() == vp.getClass()) {
                changed[0] = changed[0] | VPStore.isChanged(this.allLocks, suid, vp, value);
                this.allLocks = VPStore.put(this.allLocks, suid, vp, value);
                this.updateTrackedVP(suid, vp);
            }
        });
        return changed[0];
    }

    private static boolean isChanged(Map<Long, Map<VisualProperty<?>, Object>> map, Long suid, VisualProperty<?> vp, Object value) {
        Object prevValue = ((Map)map.getOrElse((Object)suid, (Object)HashMap.empty())).getOrElse(vp, null);
        return !Objects.equals(value, prevValue);
    }

    private void removeTrackedVPs(Long suid) {
        for (VisualProperty<?> vp : this.config.getTrackedVPs(this.type)) {
            for (Object key : this.config.getTrackingKeys(vp)) {
                Set suids = (Set)this.tracked.getOrElse(key, (Object)HashSet.empty());
                suids = suids.remove((Object)suid);
                this.tracked = this.tracked.put(key, (Object)suids);
            }
        }
    }

    public void updateTrackedVP(Long suid, VisualProperty<?> vp) {
        java.util.Set<Object> keys = this.config.getTrackingKeys(vp);
        if (keys.isEmpty()) {
            return;
        }
        Object value = this.getVisualProperty(suid, vp);
        for (Object e : keys) {
            boolean track;
            Set suids = (Set)this.tracked.getOrElse(e, (Object)HashSet.empty());
            Predicate predicate = this.config.getPredicate(e);
            boolean bl = track = predicate != null && predicate.test(value);
            if (track) {
                this.tracked = this.tracked.put(e, (Object)suids.add((Object)suid));
                continue;
            }
            if (suids.isEmpty()) continue;
            this.tracked = this.tracked.put(e, (Object)suids.remove((Object)suid));
        }
    }

    public Set<Long> getTracked(Object key) {
        return (Set)this.tracked.getOrElse(key, (Object)HashSet.empty());
    }

    public boolean isTrackedKey(Object key) {
        return this.config.isTrackedKey(key);
    }

    public boolean isValueLocked(Long suid, VisualProperty<?> vp) {
        return this.getAllLocksMap(suid).containsKey(vp);
    }

    public boolean isDirectlyLocked(Long suid, VisualProperty<?> vp) {
        return this.getDirectLocksMap(suid).containsKey(vp);
    }

    public <T, V extends T> void setViewDefault(VisualProperty<? extends T> vp, V value) {
        this.defaultValues = this.defaultValues.put(vp, value);
    }

    public <T> T getViewDefault(VisualProperty<T> vp) {
        return (T)this.defaultValues.getOrElse(vp, vp.getDefault());
    }
}

