/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cyndex2.internal.util;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.cytoscape.cyndex2.internal.CyServiceModule;
import org.cytoscape.cyndex2.internal.util.NDExNetworkManager;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CyRootNetworkManager;
import org.ndexbio.model.exceptions.NdexException;
import org.ndexbio.model.object.Permissions;
import org.ndexbio.model.object.network.NetworkSummary;
import org.ndexbio.rest.client.NdexRestClient;
import org.ndexbio.rest.client.NdexRestClientModelAccessLayer;

public class UpdateUtil {
    private static CyNetwork getRootNetwork(Long suid, CyNetworkManager networkManager, CyRootNetworkManager rootNetworkManager) {
        Optional<CyRootNetwork> optional = networkManager.getNetworkSet().stream().map(net -> rootNetworkManager.getRootNetwork(net)).findFirst();
        return optional.isPresent() ? (CyNetwork)optional.get() : null;
    }

    public static CyNetwork getNetworkForSUID(Long suid, boolean isCollection) {
        CyNetworkManager network_manager = CyServiceModule.getService(CyNetworkManager.class);
        CyRootNetworkManager root_network_manager = CyServiceModule.getService(CyRootNetworkManager.class);
        return isCollection ? UpdateUtil.getRootNetwork(suid, network_manager, root_network_manager) : network_manager.getNetwork(suid.longValue());
    }

    public static UUID updateIsPossible(CyNetwork network, UUID uuid, NdexRestClient nc, NdexRestClientModelAccessLayer mal) throws Exception {
        return UpdateUtil.updateIsPossible(network, uuid, nc, mal, true);
    }

    public static UUID updateIsPossible(CyNetwork network, UUID uuid, NdexRestClient nc, NdexRestClientModelAccessLayer mal, boolean checkTimestamp) throws Exception {
        if (uuid == null) {
            throw new Exception("UUID unknown. Can't find current Network in NDEx.");
        }
        try {
            Map permissionTable = mal.getUserNetworkPermission(nc.getUserUid(), uuid, false);
            if (permissionTable == null || permissionTable.size() == 0) {
                throw new Exception("Cannot find network.");
            }
            if (permissionTable.get(uuid.toString()) == Permissions.READ) {
                throw new Exception("You don't have permission to write to this network.");
            }
        }
        catch (IOException | NdexException e) {
            throw new Exception("Unable to read network permissions. " + e.getMessage());
        }
        NetworkSummary ns = null;
        try {
            ns = mal.getNetworkSummaryById(uuid);
            if (ns.getIsReadOnly()) {
                throw new Exception("The network is read only.");
            }
            if (checkTimestamp) {
                Timestamp serverTimestamp = ns.getModificationTime();
                Timestamp localTimestamp = NDExNetworkManager.getModificationTimeStamp(network);
                if (localTimestamp == null) {
                    throw new Exception("Session file is missing timestamp.");
                }
                int timestampCompare = serverTimestamp.compareTo(localTimestamp);
                if (timestampCompare > 0) {
                    throw new Exception("Network was modified on remote server.");
                }
            }
        }
        catch (IOException | NdexException e) {
            throw new Exception("An error occurred while checking permissions. " + e.getMessage());
        }
        return uuid;
    }

    public static UUID updateIsPossibleHelper(Long suid, boolean isCollection, NdexRestClient nc, NdexRestClientModelAccessLayer mal) throws Exception {
        return UpdateUtil.updateIsPossibleHelper(suid, isCollection, nc, mal, true);
    }

    public static UUID updateIsPossibleHelper(Long suid, boolean isCollection, NdexRestClient nc, NdexRestClientModelAccessLayer mal, boolean checkTimestamp) throws Exception {
        CyNetwork network = UpdateUtil.getNetworkForSUID(suid, isCollection);
        UUID ndexNetworkId = NDExNetworkManager.getUUID(network);
        return UpdateUtil.updateIsPossible(network, ndexNetworkId, nc, mal, checkTimestamp);
    }
}

