/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cyndex2.internal.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.cytoscape.cyndex2.internal.CyServiceModule;
import org.cytoscape.cyndex2.internal.util.Server;
import org.cytoscape.cyndex2.internal.util.ServerKey;
import org.cytoscape.cyndex2.internal.util.ServerList;

public class ServerManager {
    public static ServerManager INSTANCE = new ServerManager();
    private PropertyChangeSupport mPcs = new PropertyChangeSupport(this);
    private final ServerList availableServers;
    private ServerKey selectedServer;

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.mPcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.mPcs.removePropertyChangeListener(listener);
    }

    private ServerManager() {
        File configDir = CyServiceModule.INSTANCE.getConfigDir();
        File addedServersJsonFile = new File(configDir, "added-servers.json");
        this.availableServers = ServerList.readServerList(addedServersJsonFile);
        this.selectedServer = ServerManager.readSelectedServer();
        if (this.selectedServer == null) {
            this.selectNextAvailableServer();
        }
    }

    private void selectNextAvailableServer() {
        if (this.availableServers.getSize() > 0) {
            this.selectedServer = new ServerKey(this.availableServers.getElementAt(0));
        }
    }

    public ServerList getAvailableServers() {
        return this.availableServers;
    }

    public Server getSelectedServer() {
        return this.selectedServer != null ? this.availableServers.getServer(this.selectedServer) : null;
    }

    public Server getServer() {
        return this.selectedServer != null ? this.availableServers.getServer(this.selectedServer) : Server.DEFAULT_SERVER;
    }

    public static String addHttpProtocol(String url) {
        return url.toLowerCase().startsWith("http://") || url.toLowerCase().startsWith("https://") ? url : "http://" + url;
    }

    public static String addHttpsProtocol(String url) {
        return url.toLowerCase().startsWith("http://") || url.toLowerCase().startsWith("https://") ? url : "https://" + url;
    }

    public static String getBaseRoute(String url) {
        return String.valueOf(ServerManager.addHttpProtocol(url)) + "/v2";
    }

    public void addServer(String username, String password, String serverUrl) throws Exception {
        String baseroute = ServerManager.getBaseRoute(serverUrl);
        if (username == null && password == null) {
            System.out.println("Anonymous access");
        } else if (username != null && password != null) {
            System.out.println("Accessing as " + username);
            BasicCredentialsProvider provider = new BasicCredentialsProvider();
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(username, password);
            provider.setCredentials(AuthScope.ANY, (Credentials)credentials);
            CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)provider).build();
            String url = baseroute.concat("/user?valid=true");
            HttpGet get = new HttpGet(url);
            HttpResponse response = httpClient.execute((HttpUriRequest)get);
            HttpEntity entity = response.getEntity();
            String result = EntityUtils.toString((HttpEntity)entity);
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode jsonNode = (JsonNode)objectMapper.readValue(result, JsonNode.class);
            if (response.getStatusLine().getStatusCode() != 200) {
                try {
                    String message = jsonNode.get("message").asText();
                    throw new Exception(message);
                }
                catch (Exception e) {
                    throw new Exception(e);
                }
            }
        } else {
            if (password == null) {
                System.out.println("no password");
                throw new Exception("Password must be provided");
            }
            if (username == null) {
                System.out.println("no username");
                throw new Exception("Passwords are not used for anonymous access.");
            }
        }
        Server server = this.availableServers.getServer(new ServerKey(username, serverUrl));
        if (server == null) {
            server = new Server();
            server.setUrl(serverUrl);
            server.setUsername(username);
            server.setPassword(password);
            this.availableServers.add(server);
            this.availableServers.writeServerList(ServerManager.getServerListFile());
        }
        this.setSelectedServer(new ServerKey(server));
        this.saveSelectedServer();
    }

    private static File getServerListFile() {
        File configDir = CyServiceModule.INSTANCE.getConfigDir();
        File addedServersFile = new File(configDir, "added-servers.json");
        return addedServersFile;
    }

    public void removeServer(Server server) {
        this.availableServers.delete(server);
        this.availableServers.writeServerList(ServerManager.getServerListFile());
        ServerKey oldValue = this.selectedServer;
        this.selectedServer = null;
        this.selectNextAvailableServer();
        this.saveSelectedServer();
        PropertyChangeEvent event = new PropertyChangeEvent(this, "selectedServer", oldValue, this.selectedServer);
        this.mPcs.firePropertyChange(event);
    }

    public void saveSelectedServer() {
        File configDir = CyServiceModule.INSTANCE.getConfigDir();
        File selectedServersFile = new File(configDir, "selected-server.json");
        ServerManager.saveSelectedServerKey(this.selectedServer, selectedServersFile.getAbsolutePath());
    }

    private static void saveSelectedServerKey(ServerKey serverKey, String filePath) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson((Object)serverKey);
        File serverFile = new File(filePath);
        try {
            Files.asCharSink((File)serverFile, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)json);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void setSelectedServer(ServerKey serverKey) {
        if (this.availableServers.getServer(serverKey) == null) {
            throw new IllegalArgumentException("No profile exists for " + serverKey);
        }
        ServerKey oldValue = this.selectedServer;
        this.selectedServer = serverKey;
        this.saveSelectedServer();
        PropertyChangeEvent event = new PropertyChangeEvent(this, "selectedServer", oldValue, serverKey);
        this.mPcs.firePropertyChange(event);
    }

    private static ServerKey readSelectedServer() {
        File configDir = CyServiceModule.INSTANCE.getConfigDir();
        File selectedServerJsonFile = new File(configDir, "selected-server.json");
        return ServerManager.readSelectedServer(selectedServerJsonFile);
    }

    private static ServerKey readSelectedServer(File jsonFile) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedReader br = new BufferedReader(new FileReader(jsonFile));){
                Gson gson = new Gson();
                ServerKey result = (ServerKey)gson.fromJson((Reader)br, ServerKey.class);
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ServerManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }
}

