/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cyndex2.internal.ui.swing;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.cytoscape.cyndex2.internal.CyServiceModule;
import org.cytoscape.cyndex2.internal.ui.swing.PreferencesDialog;
import org.cytoscape.cyndex2.internal.util.CxPreferences;
import org.cytoscape.cyndex2.internal.util.Server;
import org.cytoscape.cyndex2.internal.util.ServerManager;
import org.cytoscape.util.swing.IconManager;
import org.ndexbio.cxio.metadata.MetaDataCollection;
import org.ndexbio.model.exceptions.NdexException;
import org.ndexbio.model.object.network.NetworkSummary;
import org.ndexbio.rest.client.NdexRestClientModelAccessLayer;

public class LargeNetworkDialog
extends JDialog {
    private final NetworkSummary networkSummary;
    private boolean hasView;
    final int ICON_FONT_SIZE = 22;
    private final String CREATE_VIEW_LABEL = "<html><p width=\"200px\"><b>Create View</b> (Resource Intensive, preserve layout and visual properties)</p></html>";
    private final String CREATE_VIEW_TIP = "<html><p width=\"200px\">Choose this option to import the network and display it <u>preserving existing layout and visual styling info</u>. Your computer might crash if it's older or not powerful enough.</p></html>";
    private final String DONT_CREATE_VIEW_LABEL = "<html><p width=\"200px\"><b>Don\u2019t Create View</b> (Faster, discard layout and visual properties)</p></html>";
    private final String DONT_CREATE_VIEW_TIP = "<html><p width=\"200px\">Choose this option to import the network without generating a graphic rendering. The <u>original layout and visual styling info will be lost</u>. You can decide to generate a graphic rendering later if desired.</p></html>";
    private final String CREATE_VIEW_LABEL_NO_EXISTING = "<html><p width=\"180px\"><b>Create View</b> (Resource Intensive)</p></html>";
    private final String CREATE_VIEW_TIP_NO_EXISTING = "<html><p width=\"200px\">Choose this option to import the network and display it with Cytoscape\u2019s default layout and visual styling info. Your computer might crash if it's older or not powerful enough.</p></html>";
    private final String DONT_CREATE_VIEW_LABEL_NO_EXISTING = "<html><p width=\"180px\"><b>Don\u2019t Create View</b> (Faster)</p></html>";
    private final String DONT_CREATE_VIEW_TIP_NO_EXISTING = "<html><p width=\"200px\">Choose this option to import the network without generating a graphic view. You can decide to generate a graphic view later if desired.</p></html>";
    private JButton cancelButton;
    private JLabel createViewInfo;
    private JRadioButton createViewRadioButton;
    private JLabel dontCreateViewInfo;
    private JRadioButton dontCreateViewRadioButton;
    private JLabel jLabel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JButton okButton;
    private ButtonGroup viewButtonGroup;
    private boolean importNetwork = false;

    public LargeNetworkDialog(Dialog parent, boolean modal, NetworkSummary networkSummary) {
        super(parent, modal);
        this.networkSummary = networkSummary;
        Server selectedServer = ServerManager.INSTANCE.getServer();
        try {
            NdexRestClientModelAccessLayer mal = selectedServer.getModelAccessLayer();
            MetaDataCollection metaDataCollection = mal.getNetworkMetadata(networkSummary.getExternalId());
            this.hasView = metaDataCollection.getMetaDataElement("cyVisualProperties") != null;
        }
        catch (IOException | NdexException e) {
            e.printStackTrace();
            this.hasView = true;
        }
        this.initComponents();
    }

    private String getCreateViewLabel() {
        return this.hasView || this.networkSummary.getHasLayout() ? "<html><p width=\"200px\"><b>Create View</b> (Resource Intensive, preserve layout and visual properties)</p></html>" : "<html><p width=\"180px\"><b>Create View</b> (Resource Intensive)</p></html>";
    }

    private String getCreateViewTooltip() {
        return this.hasView || this.networkSummary.getHasLayout() ? "<html><p width=\"200px\">Choose this option to import the network and display it <u>preserving existing layout and visual styling info</u>. Your computer might crash if it's older or not powerful enough.</p></html>" : "<html><p width=\"200px\">Choose this option to import the network and display it with Cytoscape\u2019s default layout and visual styling info. Your computer might crash if it's older or not powerful enough.</p></html>";
    }

    private String getDontCreateViewLabel() {
        return this.hasView || this.networkSummary.getHasLayout() ? "<html><p width=\"200px\"><b>Don\u2019t Create View</b> (Faster, discard layout and visual properties)</p></html>" : "<html><p width=\"180px\"><b>Don\u2019t Create View</b> (Faster)</p></html>";
    }

    private String getDontCreateViewTooltip() {
        return this.hasView || this.networkSummary.getHasLayout() ? "<html><p width=\"200px\">Choose this option to import the network without generating a graphic rendering. The <u>original layout and visual styling info will be lost</u>. You can decide to generate a graphic rendering later if desired.</p></html>" : "<html><p width=\"200px\">Choose this option to import the network without generating a graphic view. You can decide to generate a graphic view later if desired.</p></html>";
    }

    private void validateOK() {
        this.okButton.setEnabled(this.createViewRadioButton.isSelected() || this.dontCreateViewRadioButton.isSelected());
    }

    private void updateHeadingAndMessage() {
        if (this.willCreateView()) {
            this.createViewRadioButton.setSelected(true);
        } else {
            this.dontCreateViewRadioButton.setSelected(true);
        }
    }

    private void initComponents() {
        this.viewButtonGroup = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.jPanel2 = new JPanel();
        this.jPanel2.setLayout(new FlowLayout(0));
        this.createViewRadioButton = new JRadioButton();
        this.createViewInfo = new JLabel();
        this.jPanel3 = new JPanel();
        this.jPanel3.setLayout(new FlowLayout(0));
        this.dontCreateViewRadioButton = new JRadioButton();
        this.dontCreateViewInfo = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Network Import Confirmation");
        this.setSize(new Dimension(480, 254));
        this.jLabel1.setHorizontalAlignment(2);
        this.jLabel1.setText("<html><p width=\"300px\">You are about to import a large network. Creating a view for a network of this size requires large amounts of memory and could cause problems on less powerful computers. Please choose one of the following options.</p></html>");
        this.jLabel1.setMaximumSize(new Dimension(420, 68));
        this.jLabel1.setName("");
        this.jLabel1.setPreferredSize(new Dimension(420, 68));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LargeNetworkDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.setEnabled(false);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LargeNetworkDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.viewButtonGroup.add(this.createViewRadioButton);
        this.createViewRadioButton.setText(this.getCreateViewLabel());
        this.createViewRadioButton.setToolTipText("<html><p width=\"200px\">Choose this option to import the network and display it <u>preserving existing layout and visual styling info</u>. Your computer might crash if it's older or not powerful enough.</p></html>");
        this.createViewRadioButton.setHorizontalAlignment(2);
        this.createViewRadioButton.setHorizontalTextPosition(4);
        this.createViewRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                LargeNetworkDialog.this.createViewRadioButtonStateChanged(evt);
            }
        });
        this.createViewRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LargeNetworkDialog.this.createViewRadioButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.createViewRadioButton);
        this.createViewInfo.setFont(CyServiceModule.getService(IconManager.class).getIconFont(17.0f));
        this.createViewInfo.setText("\uf29c");
        this.createViewInfo.setToolTipText(this.getCreateViewTooltip());
        this.createViewInfo.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.createViewInfo.setMaximumSize(new Dimension(32, 32));
        this.createViewInfo.setMinimumSize(new Dimension(24, 24));
        this.createViewInfo.setPreferredSize(new Dimension(24, 24));
        this.createViewInfo.setFont(CyServiceModule.getService(IconManager.class).getIconFont(17.0f));
        this.createViewInfo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LargeNetworkDialog.this.createViewInfoMouseClicked(evt);
            }
        });
        this.jPanel2.add(this.createViewInfo);
        this.viewButtonGroup.add(this.dontCreateViewRadioButton);
        this.dontCreateViewRadioButton.setText(this.getDontCreateViewLabel());
        this.dontCreateViewRadioButton.setToolTipText("<html><p width=\"200px\">Choose this option to import the network without generating a graphic rendering. The <u>original layout and visual styling info will be lost</u>. You can decide to generate a graphic rendering later if desired.</p></html>");
        this.dontCreateViewRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                LargeNetworkDialog.this.dontCreateViewRadioButtonStateChanged(evt);
            }
        });
        this.dontCreateViewRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LargeNetworkDialog.this.dontCreateViewRadioButtonActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.dontCreateViewRadioButton);
        this.dontCreateViewInfo.setFont(CyServiceModule.getService(IconManager.class).getIconFont(17.0f));
        this.dontCreateViewInfo.setText("\uf29c");
        this.dontCreateViewInfo.setToolTipText(this.getDontCreateViewTooltip());
        this.dontCreateViewInfo.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.dontCreateViewInfo.setMaximumSize(new Dimension(32, 32));
        this.dontCreateViewInfo.setMinimumSize(new Dimension(24, 24));
        this.dontCreateViewInfo.setPreferredSize(new Dimension(24, 24));
        this.dontCreateViewInfo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LargeNetworkDialog.this.dontCreateViewInfoMouseClicked(evt);
            }
        });
        this.jPanel3.add(this.dontCreateViewInfo);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1, -2, 390, -2).addGap(12, 12, 12)).addGroup(layout.createSequentialGroup().addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton).addGap(12, 12, 12)))).addGroup(layout.createSequentialGroup().addGap(32, 32, 32).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addGap(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(14, 14, 14).addComponent(this.jLabel1, -2, 68, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 24, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton).addComponent(this.cancelButton)).addContainerGap()));
        this.pack();
    }

    private void dontCreateViewRadioButtonActionPerformed(ActionEvent evt) {
    }

    private void dontCreateViewRadioButtonStateChanged(ChangeEvent evt) {
        this.validateOK();
    }

    private void createViewInfoMouseClicked(MouseEvent evt) {
        JOptionPane.showMessageDialog(this, this.getCreateViewTooltip(), "Create View", 1);
    }

    private void createViewRadioButtonStateChanged(ChangeEvent evt) {
        this.validateOK();
    }

    private void dontCreateViewInfoMouseClicked(MouseEvent evt) {
        JOptionPane.showMessageDialog(this, this.getDontCreateViewTooltip(), "Don't Create View", 1);
    }

    private void createViewRadioButtonActionPerformed(ActionEvent evt) {
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.setImportNetwork(true);
        this.setVisible(false);
    }

    private void preferencesButtonActionPerformed(ActionEvent evt) {
        PreferencesDialog preferencesDialog = new PreferencesDialog(null, true);
        preferencesDialog.setLocationRelativeTo(this);
        preferencesDialog.setVisible(true);
        this.updateHeadingAndMessage();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setImportNetwork(false);
        this.setVisible(false);
    }

    public static void main(String[] args) {
        try {
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
            int n = lookAndFeelInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
                if ("Nimbus".equals(info.getName())) {
                    UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
                ++n2;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(LargeNetworkDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(LargeNetworkDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(LargeNetworkDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(LargeNetworkDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                NetworkSummary networkSummary = new NetworkSummary();
                networkSummary.setNodeCount(1000000);
                networkSummary.setEdgeCount(1000000);
                LargeNetworkDialog dialog = new LargeNetworkDialog(null, true, networkSummary);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    private boolean willCreateView() {
        long networkSize = this.networkSummary.getNodeCount() + this.networkSummary.getEdgeCount();
        long viewThreshold = CxPreferences.getViewThreshold();
        CxPreferences.CreateViewEnum createViewPreference = CxPreferences.getCreateView();
        return createViewPreference.equals((Object)CxPreferences.CreateViewEnum.ALWAYS) || networkSize < viewThreshold;
    }

    private void setImportNetwork(boolean importNetwork) {
        this.importNetwork = importNetwork;
    }

    public boolean getImportNetwork() {
        return this.importNetwork;
    }

    public boolean getCreateView() {
        return this.createViewRadioButton.isSelected();
    }
}

