/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cyndex2.internal.task;

import java.util.Collection;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.cyndex2.external.SaveParameters;
import org.cytoscape.cyndex2.internal.task.OpenDialogTaskFactory;
import org.cytoscape.cyndex2.internal.util.ExternalAppManager;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.task.NetworkCollectionTaskFactory;
import org.cytoscape.work.TaskIterator;

public class OpenSaveTaskFactory
extends OpenDialogTaskFactory
implements NetworkCollectionTaskFactory {
    private final CyApplicationManager appManager;

    public OpenSaveTaskFactory(CyApplicationManager appManager) {
        super("save");
        this.appManager = appManager;
    }

    @Override
    public TaskIterator createTaskIterator() {
        return this.createTaskIterator(this.appManager.getCurrentNetwork());
    }

    @Override
    public boolean isReady() {
        if (ExternalAppManager.loadFailed()) {
            return false;
        }
        return this.appManager.getCurrentNetwork() != null;
    }

    public TaskIterator createTaskIterator(Collection<CyNetwork> nets) {
        if (nets.isEmpty()) {
            return null;
        }
        return this.createTaskIterator(nets.iterator().next());
    }

    public boolean isReady(Collection<CyNetwork> nets) {
        return this.isReady() && nets.size() == 1;
    }

    private TaskIterator createTaskIterator(CyNetwork net) {
        SaveParameters.INSTANCE.suid = net.getSUID();
        SaveParameters.INSTANCE.saveType = "network";
        return super.createTaskIterator();
    }
}

