/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cyndex2.internal.task;

import java.io.IOException;
import java.util.UUID;
import javax.ws.rs.core.Response;
import org.cytoscape.cyndex2.internal.CyServiceModule;
import org.cytoscape.cyndex2.internal.rest.errors.ErrorBuilder;
import org.cytoscape.cyndex2.internal.rest.errors.ErrorType;
import org.cytoscape.cyndex2.internal.rest.parameter.NDExImportParameters;
import org.cytoscape.cyndex2.internal.task.NetworkImportTask;
import org.cytoscape.cyndex2.internal.util.UserAgentUtil;
import org.cytoscape.work.AbstractTaskFactory;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.ndexbio.model.exceptions.NdexException;
import org.ndexbio.rest.client.NdexRestClient;
import org.ndexbio.rest.client.NdexRestClientModelAccessLayer;

public class NDExImportTaskFactory
extends AbstractTaskFactory {
    private ErrorBuilder errorBuilder;
    private NDExImportParameters params;
    private NetworkImportTask importer;

    public NDExImportTaskFactory(NDExImportParameters params) {
        this.params = params;
        this.errorBuilder = CyServiceModule.INSTANCE.getErrorBuilder();
    }

    private NetworkImportTask buildImportTask() throws IOException, NdexException {
        UUID uuid = this.validateImportParameters(this.params);
        if (this.params.username != null && this.params.password != null) {
            String serverUrl = this.params.serverUrl == null ? "http://ndexbio.org/v2/" : this.params.serverUrl;
            NdexRestClient client = new NdexRestClient(this.params.username, this.params.password, serverUrl, UserAgentUtil.getUserAgent());
            NdexRestClientModelAccessLayer mal = new NdexRestClientModelAccessLayer(client);
            return new NetworkImportTask(mal, uuid, this.params.accessKey, this.params.createView);
        }
        NdexRestClient client = new NdexRestClient(null, null, this.params.serverUrl, UserAgentUtil.getUserAgent());
        if (this.params.idToken != null) {
            client.signIn(this.params.idToken);
        }
        NdexRestClientModelAccessLayer mal = new NdexRestClientModelAccessLayer(client);
        return new NetworkImportTask(mal, uuid, this.params.accessKey, this.params.createView);
    }

    public TaskIterator createTaskIterator() {
        try {
            this.importer = this.buildImportTask();
            return new TaskIterator(new Task[]{this.importer});
        }
        catch (IOException | NdexException e) {
            String message = "Failed to connect to server and retrieve network. " + e.getMessage();
            throw this.errorBuilder.buildException(Response.Status.INTERNAL_SERVER_ERROR, message, ErrorType.INTERNAL);
        }
    }

    private UUID validateImportParameters(NDExImportParameters params) {
        if (params == null) {
            String message = "No import parameters found.";
            throw this.errorBuilder.buildException(Response.Status.BAD_REQUEST, "No import parameters found.", ErrorType.INVALID_PARAMETERS);
        }
        if (params.serverUrl == null) {
            params.serverUrl = "http://ndexbio.org/v2";
        }
        if (params.uuid == null) {
            String message = "Must provide a uuid to import a network";
            throw this.errorBuilder.buildException(Response.Status.BAD_REQUEST, "Must provide a uuid to import a network", ErrorType.INVALID_PARAMETERS);
        }
        try {
            return UUID.fromString(params.uuid);
        }
        catch (IllegalArgumentException e) {
            String message = "Invalid UUID parameter: " + params.uuid + ". Must conform to UUID standards";
            throw this.errorBuilder.buildException(Response.Status.BAD_REQUEST, message, ErrorType.INVALID_PARAMETERS);
        }
    }

    public long getSUID() {
        return this.importer.getSUID();
    }
}

