/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cyndex2.internal.task;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.UUID;
import javax.ws.rs.core.Response;
import org.cytoscape.cyndex2.internal.CxTaskFactoryManager;
import org.cytoscape.cyndex2.internal.CyServiceModule;
import org.cytoscape.cyndex2.internal.rest.errors.ErrorBuilder;
import org.cytoscape.cyndex2.internal.rest.errors.ErrorType;
import org.cytoscape.cyndex2.internal.rest.parameter.NDExBasicSaveParameters;
import org.cytoscape.cyndex2.internal.rest.parameter.NDExSaveParameters;
import org.cytoscape.cyndex2.internal.task.NetworkExportTask;
import org.cytoscape.cyndex2.internal.util.UserAgentUtil;
import org.cytoscape.io.write.CyNetworkViewWriterFactory;
import org.cytoscape.io.write.CyWriter;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.task.NetworkTaskFactory;
import org.cytoscape.task.NetworkViewTaskFactory;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;
import org.ndexbio.rest.client.NdexRestClient;
import org.ndexbio.rest.client.NdexRestClientModelAccessLayer;

public class NDExExportTaskFactory
implements NetworkViewTaskFactory,
NetworkTaskFactory {
    private final NDExBasicSaveParameters params;
    private final boolean isUpdate;
    private CyWriter writer;
    private NetworkExportTask exporter;

    public NDExExportTaskFactory(NDExBasicSaveParameters params, boolean isUpdate) {
        this.params = params;
        this.isUpdate = isUpdate;
    }

    private void setTunables(CyWriter writer, boolean collection) {
        Class<?> writerClass = writer.getClass();
        Method[] writerMethods = writerClass.getMethods();
        Method setWriteSiblingsMethod = null;
        Method setUseCxIdMethod = null;
        Method[] methodArray = writerMethods;
        int n = writerMethods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().equals("setWriteSiblings")) {
                if (method.getParameterTypes().length == 1 && method.getReturnType() == Void.TYPE && method.getParameterTypes()[0].equals(Boolean.class)) {
                    setWriteSiblingsMethod = method;
                }
            } else if (method.getName().equals("setUseCxId") && method.getParameterTypes().length == 1 && method.getReturnType() == Void.TYPE && method.getParameterTypes()[0].equals(Boolean.class)) {
                setUseCxIdMethod = method;
            }
            ++n2;
        }
        if (setWriteSiblingsMethod != null) {
            try {
                setWriteSiblingsMethod.invoke((Object)writer, collection);
                System.out.println("setWriteSiblingsMethod(" + collection + ")");
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        if (setWriteSiblingsMethod != null) {
            try {
                setUseCxIdMethod.invoke((Object)writer, !collection);
                System.out.println("setUseCxIdMethod(" + !collection + ")");
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private AbstractTask getTaskWrapper(final CyNetwork network, final boolean writeCollection) {
        AbstractTask wrapper = new AbstractTask(){
            ByteArrayOutputStream out = new ByteArrayOutputStream();

            public void run(TaskMonitor taskMonitor) throws Exception {
                CyNetworkViewWriterFactory writerFactory = CxTaskFactoryManager.INSTANCE.getCxWriterFactory();
                NDExExportTaskFactory.this.writer = writerFactory.createWriter((OutputStream)this.out, network);
                NDExExportTaskFactory.this.setTunables(NDExExportTaskFactory.this.writer, writeCollection);
                NDExExportTaskFactory.this.writer.run(taskMonitor);
                byte[] bytes = this.out.toByteArray();
                ByteArrayInputStream in = new ByteArrayInputStream(bytes);
                NdexRestClient client = new NdexRestClient(NDExExportTaskFactory.this.params.username, NDExExportTaskFactory.this.params.password, NDExExportTaskFactory.this.params.serverUrl, UserAgentUtil.getUserAgent());
                NdexRestClientModelAccessLayer mal = new NdexRestClientModelAccessLayer(client);
                NDExExportTaskFactory.this.exporter = new NetworkExportTask(mal, network.getSUID(), in, NDExExportTaskFactory.this.params, writeCollection, NDExExportTaskFactory.this.isUpdate);
                this.getTaskIterator().append((Task)NDExExportTaskFactory.this.exporter);
            }

            public void cancel() {
                super.cancel();
                try {
                    this.out.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Task cancelled");
                }
            }
        };
        return wrapper;
    }

    public TaskIterator createTaskIterator(CyNetworkView networkView) {
        this.validateSaveParameters(this.params);
        CyNetwork network = (CyNetwork)networkView.getModel();
        for (String column : this.params.metadata.keySet()) {
            NDExExportTaskFactory.saveMetadata(column, this.params.metadata.get(column), network);
        }
        return new TaskIterator(new Task[]{this.getTaskWrapper(network, false)});
    }

    public TaskIterator createTaskIterator(CyNetwork network) {
        this.validateSaveParameters(this.params);
        for (String column : this.params.metadata.keySet()) {
            NDExExportTaskFactory.saveMetadata(column, this.params.metadata.get(column), network);
        }
        boolean writeCollection = network instanceof CyRootNetwork;
        if (writeCollection) {
            network = ((CyRootNetwork)network).getBaseNetwork();
        }
        return new TaskIterator(new Task[]{this.getTaskWrapper(network, writeCollection)});
    }

    private void validateSaveParameters(NDExBasicSaveParameters params) {
        ErrorBuilder errorBuilder = CyServiceModule.INSTANCE.getErrorBuilder();
        if (params == null || params.username == null || params.password == null) {
            throw errorBuilder.buildException(Response.Status.BAD_REQUEST, "Must provide save parameters (username and password)", ErrorType.INVALID_PARAMETERS);
        }
        if (params.serverUrl == null) {
            params.serverUrl = "http://ndexbio.org/v2";
        }
        if (params.metadata == null) {
            params.metadata = new HashMap<String, String>();
        }
        if (params instanceof NDExSaveParameters && ((NDExSaveParameters)params).isPublic == null) {
            ((NDExSaveParameters)params).isPublic = true;
        }
    }

    private static final void saveMetadata(String columnName, String value, CyNetwork network) {
        CyTable localTable = network.getTable(CyNetwork.class, "LOCAL_ATTRS");
        CyRow row = localTable.getRow((Object)network.getSUID());
        CyColumn col = localTable.getColumn(columnName);
        if (col == null) {
            if (value == null || value.isEmpty()) {
                return;
            }
            localTable.createColumn(columnName, String.class, false);
        }
        row.set(columnName, (Object)value);
    }

    public UUID getUUID() {
        return this.exporter.getUUID();
    }

    public boolean isReady(CyNetwork network) {
        return network != null;
    }

    public boolean isReady(CyNetworkView networkView) {
        return networkView != null;
    }
}

