/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cyndex2.internal.rest.errors;

import java.io.File;
import java.net.URI;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.cytoscape.application.CyApplicationConfiguration;
import org.cytoscape.ci.model.CIError;
import org.cytoscape.cyndex2.internal.rest.errors.ErrorType;
import org.cytoscape.cyndex2.internal.util.CIServiceManager;

public class ErrorBuilder {
    private final CIServiceManager ciServiceManager;
    private final URI logFileUri;

    public ErrorBuilder(CIServiceManager ciServiceManager, CyApplicationConfiguration appConfig) {
        this.ciServiceManager = ciServiceManager;
        File configDir = appConfig.getConfigurationDirectoryLocation();
        File cy3Dir = new File(configDir, "3");
        File logFile = new File(cy3Dir, "framework-cytoscape.log");
        this.logFileUri = logFile.toURI();
    }

    public CIError buildErrorResponse(Response.Status status, String message, ErrorType type) {
        return this.ciServiceManager.getCIErrorFactory().getCIError(Integer.valueOf(status.getStatusCode()), type.getUrn(), message, this.logFileUri);
    }

    public WebApplicationException buildException(Response.Status status, String message, ErrorType type) {
        return this.ciServiceManager.getCIExceptionFactory().getCIException(status.getStatusCode(), new CIError[]{this.buildErrorResponse(status, message, type)});
    }
}

