/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.diffusion.internal.util;

import java.util.Collection;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;

public class DiffusionResult {
    private final String rankName;
    private final String heatName;
    private final CyNetwork network;

    public DiffusionResult(CyNetwork network, String rankName, String heatName) {
        this.rankName = rankName;
        this.heatName = heatName;
        this.network = network;
    }

    public String getHeatColumnName() {
        return this.heatName;
    }

    public String getRankColumnName() {
        return this.rankName;
    }

    public Double getMaxHeat() {
        return this.rankToHeat(1);
    }

    public Double getMinHeat() {
        return this.rankToHeat(this.getMaxRank());
    }

    public Integer getMinRank() {
        return 1;
    }

    public Integer getMaxRank() {
        return this.network.getNodeCount();
    }

    public Double rankToHeat(Integer rank) {
        if (rank == null) {
            return new Double(0.0);
        }
        CyRow row = this.getRowForRank(rank);
        if (row == null) {
            return new Double(0.0);
        }
        return (Double)row.get(this.heatName, Double.class);
    }

    public Integer heatToRank(Double heat) {
        return (Integer)this.getRowForHeat(heat).get(this.rankName, Integer.class);
    }

    public CyRow getRowForHeat(Double heat) {
        return this.getFirstMatchingRow(this.heatName, heat);
    }

    public CyRow getRowForRank(Integer rank) {
        return this.getFirstMatchingRow(this.rankName, rank);
    }

    public CyRow getFirstMatchingRow(String columnName, Object value) {
        CyTable table = this.network.getTable(CyNode.class, "LOCAL_ATTRS");
        Collection matchedRows = table.getMatchingRows(columnName, value);
        if (matchedRows.isEmpty()) {
            return null;
        }
        return (CyRow)matchedRows.iterator().next();
    }
}

