/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.diffusion.internal.ui;

import java.beans.PropertyChangeEvent;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.cytoscape.diffusion.internal.ui.AbstractSliderPanel;
import org.cytoscape.diffusion.internal.util.DiffusionTable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;

public class RankSelectionPanel
extends AbstractSliderPanel {
    RankSelectionPanel(DiffusionTable diffusionTable, String title) {
        super(diffusionTable, title, "Node ", "");
    }

    private final void setThreshold(Integer index) {
        String rankColName = this.diffusionTable.getCurrentResult().getRankColumnName();
        CyNetwork network = this.diffusionTable.getAssociatedNetwork();
        CyTable localTable = network.getTable(CyNode.class, "LOCAL_ATTRS");
        for (CyRow row : localTable.getAllRows()) {
            Integer rank = (Integer)row.get(rankColName, Integer.class);
            if (rank == null) continue;
            if (rank < index) {
                row.set("selected", (Object)Boolean.TRUE);
                continue;
            }
            row.set("selected", (Object)Boolean.FALSE);
        }
    }

    @Override
    protected JSlider createSlider() {
        Integer rankMax = this.diffusionTable.getCurrentResult().getMaxRank();
        final JSlider slider = new JSlider(1, rankMax);
        slider.setOpaque(false);
        int delta = Math.max(1, rankMax / 4);
        Hashtable<Integer, JComponent> labels = slider.createStandardLabels(delta);
        slider.setLabelTable(labels);
        slider.setMajorTickSpacing(delta);
        slider.setPaintTicks(true);
        slider.setPaintLabels(true);
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!slider.getValueIsAdjusting()) {
                    int newVal = slider.getValue();
                    RankSelectionPanel.this.setThreshold(newVal);
                    RankSelectionPanel.this.valuePanel.setValue(newVal);
                }
            }
        });
        Double maxRank = this.diffusionTable.getCurrentResult().getMaxRank().doubleValue();
        Integer ninteithPercentile = Double.valueOf(maxRank * 0.1).intValue();
        this.setThreshold(ninteithPercentile);
        slider.setValue(ninteithPercentile);
        this.valuePanel.setValue(ninteithPercentile);
        return slider;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!evt.getPropertyName().equals("VALUE_SET")) {
            return;
        }
        Double value = (Double)evt.getNewValue();
        Integer max = this.diffusionTable.getCurrentResult().getMaxRank();
        if (1.0 <= value && (double)max.intValue() >= value) {
            this.thresholdSlider.setValue(value.intValue());
        } else if ((double)max.intValue() < value) {
            this.thresholdSlider.setValue(max);
        } else {
            this.thresholdSlider.setValue(1);
        }
    }
}

