/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.diffusion.internal.task;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.diffusion.internal.client.DiffusionServiceClient;
import org.cytoscape.diffusion.internal.task.DiffuseSelectedTask;
import org.cytoscape.diffusion.internal.ui.OutputPanel;
import org.cytoscape.diffusion.internal.util.DiffusionTableManager;
import org.cytoscape.io.write.CyNetworkViewWriterFactory;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.TunableSetter;
import org.cytoscape.work.TunableValidator;
import org.cytoscape.work.util.ListSingleSelection;

public class DiffuseSelectedWithOptionsTask
extends DiffuseSelectedTask
implements TunableValidator {
    private static final String FROM_SELECTION_MENU = "(Use selected nodes)";
    public static final Double DEFAULT_TIME = 0.1;
    @Tunable(description="Time:", longDescription="The extent of spread over the network. This corresponds to t in the diffusion equation.", exampleStringValue="0.1")
    public Double time = DEFAULT_TIME;
    @Tunable(description="Heat Column:", longDescription="A node column name intended to override the default table column 'diffusion_input'. This represents the query vector and corresponds to h in the diffusion equation.", exampleStringValue="diffusion_input")
    public ListSingleSelection<String> heatColumnName;

    public DiffuseSelectedWithOptionsTask(DiffusionTableManager tableManager, CyNetwork network, CyNetworkViewWriterFactory writerFactory, OutputPanel outputPanel, CySwingApplication swingApplication, CyApplicationManager appManager, DiffusionServiceClient client, TunableSetter setter) {
        super(tableManager, network, writerFactory, outputPanel, swingApplication, appManager, client, setter);
        this.initColumnList();
    }

    private final void initColumnList() {
        CyNetwork targetNetwork = this.network;
        CyTable localTbl = targetNetwork.getTable(CyNode.class, "LOCAL_ATTRS");
        Collection cols = localTbl.getColumns();
        List colNames = cols.stream().filter(col -> col.getType() == Double.class).map(col -> col.getName()).collect(Collectors.toList());
        colNames.add(FROM_SELECTION_MENU);
        this.heatColumnName = new ListSingleSelection(colNames);
        this.heatColumnName.setSelectedValue((Object)FROM_SELECTION_MENU);
    }

    @Override
    public void run(TaskMonitor tm) throws Exception {
        this.tm = tm;
        tm.setTitle("Running Heat Diffusion");
        tm.setStatusMessage("Running heat diffusion service.  Please wait...");
        String selectedColumnName = (String)this.heatColumnName.getSelectedValue();
        if (selectedColumnName.equals(FROM_SELECTION_MENU)) {
            this.diffuse(null, this.time);
        } else {
            this.diffuse(selectedColumnName, this.time);
        }
    }

    public TunableValidator.ValidationState getValidationState(Appendable message) {
        if (this.time < 0.0) {
            try {
                message.append("Please enter positive value for time parameter.");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return TunableValidator.ValidationState.INVALID;
        }
        return TunableValidator.ValidationState.OK;
    }
}

