/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.diffusion.internal.rest;

import java.util.ArrayList;
import javax.ws.rs.core.Response;
import org.cytoscape.ci.model.CIResponse;
import org.cytoscape.diffusion.internal.rest.DiffusionResource;
import org.cytoscape.diffusion.internal.rest.DiffusionResultColumns;
import org.cytoscape.work.FinishStatus;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskObserver;

public class DiffusionTaskObserver
implements TaskObserver {
    private final DiffusionResource diffusionResource;
    CIResponse<?> response;
    DiffusionResultColumns diffusionResultColumns;
    private String resourcePath;
    private String errorCode;

    public CIResponse<?> getResponse() {
        return this.response;
    }

    public DiffusionTaskObserver(DiffusionResource diffusionResource, String resourcePath, String errorCode) {
        this.diffusionResource = diffusionResource;
        this.response = null;
        this.resourcePath = resourcePath;
        this.errorCode = errorCode;
    }

    public void allFinished(FinishStatus arg0) {
        if (arg0.getType() == FinishStatus.Type.SUCCEEDED || arg0.getType() == FinishStatus.Type.CANCELLED) {
            this.response = new CIResponse();
            this.response.data = this.diffusionResultColumns;
            this.response.errors = new ArrayList();
        } else {
            this.response = this.diffusionResource.buildCIErrorResponse(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.resourcePath, this.errorCode, arg0.getException().getMessage(), arg0.getException());
        }
    }

    public void taskFinished(ObservableTask arg0) {
        DiffusionResultColumns jsonResult;
        this.diffusionResultColumns = jsonResult = (DiffusionResultColumns)arg0.getResults(DiffusionResultColumns.class);
    }
}

