/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.diffusion.internal.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cxio.core.CxReader;
import org.cxio.core.interfaces.AspectElement;
import org.cxio.util.CxioUtil;
import org.cytoscape.ci.model.CIError;
import org.cytoscape.ci.model.CIResponse;
import org.cytoscape.diffusion.internal.client.DiffusionServiceException;
import org.cytoscape.io.write.CyNetworkViewWriterFactory;
import org.cytoscape.io.write.CyWriter;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.work.TunableSetter;

public class DiffusionResultParser {
    private CyNetworkViewWriterFactory writerFactory;
    private final TunableSetter tunableSetter;

    public DiffusionResultParser(CyNetworkViewWriterFactory writerFactory, TunableSetter setter) {
        this.writerFactory = writerFactory;
        this.tunableSetter = setter;
    }

    public String encode(CyNetwork network, String inputHeatColumn) throws IOException {
        Object fieldValue;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        CyWriter writer = this.writerFactory.createWriter((OutputStream)stream, network);
        Class<?> cxWriterClass = writer.getClass();
        ArrayList<String> nodeFilter = new ArrayList<String>();
        nodeFilter.add("name");
        nodeFilter.add(inputHeatColumn);
        ArrayList<String> aspects = new ArrayList<String>();
        aspects.add("nodes");
        aspects.add("edges");
        aspects.add("nodeAttributes");
        try {
            Field aspectFilter = cxWriterClass.getField("aspectFilter");
            aspectFilter.setAccessible(true);
            fieldValue = aspectFilter.get(writer);
            Class<?> fieldClass = fieldValue.getClass();
            Method setMethod = fieldClass.getDeclaredMethod("setSelectedValues", List.class);
            setMethod.invoke(fieldValue, aspects);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Field colFilter = cxWriterClass.getField("nodeColFilter");
            colFilter.setAccessible(true);
            fieldValue = colFilter.get(writer);
            Method myMethod = fieldValue.getClass().getDeclaredMethod("setSelectedValues", List.class);
            myMethod.invoke(fieldValue, nodeFilter);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        HashMap<String, Boolean> m = new HashMap<String, Boolean>();
        m.put("writeSiblings", false);
        this.tunableSetter.applyTunables((Object)writer, m);
        String jsonString = null;
        try {
            writer.run(null);
            jsonString = stream.toString("UTF-8");
            stream.close();
        }
        catch (Exception e) {
            throw new IOException();
        }
        return jsonString;
    }

    public Map<String, List<AspectElement>> decode(String response) throws IOException, DiffusionServiceException {
        ObjectMapper objectMapper = new ObjectMapper();
        CIResponse res = (CIResponse)objectMapper.readValue(response, CIResponse.class);
        if (res.errors.size() != 0) {
            Object errStrings = "";
            for (CIError err : res.errors) {
                errStrings = (String)errStrings + err.type + ":\n  " + err.message;
            }
            throw new DiffusionServiceException("Diffusion Service returned errors:\n" + (String)errStrings + "\n", res.errors);
        }
        CxReader reader = CxReader.createInstance((Object)objectMapper.writeValueAsString(res.data), (Set)CxioUtil.getAllAvailableAspectFragmentReaders());
        return CxReader.parseAsMap((CxReader)reader);
    }
}

