/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.diffusion.internal;

import java.util.Properties;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.events.SetCurrentNetworkListener;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.diffusion.internal.ViewWriterFactoryManager;
import org.cytoscape.diffusion.internal.client.DiffusionServiceClient;
import org.cytoscape.diffusion.internal.rest.DiffusionResource;
import org.cytoscape.diffusion.internal.rest.RemoteLogger;
import org.cytoscape.diffusion.internal.task.DiffusionContextMenuTaskFactory;
import org.cytoscape.diffusion.internal.task.EdgeContextMenuTaskFactory;
import org.cytoscape.diffusion.internal.ui.OutputPanel;
import org.cytoscape.diffusion.internal.util.DiffusionTableManager;
import org.cytoscape.io.write.CyNetworkViewWriterFactory;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.events.NetworkAboutToBeDestroyedListener;
import org.cytoscape.property.CyProperty;
import org.cytoscape.service.util.AbstractCyActivator;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.create.NewNetworkSelectedNodesOnlyTaskFactory;
import org.cytoscape.task.read.LoadVizmapFileTaskFactory;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.presentation.RenderingEngineManager;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.work.SynchronousTaskManager;
import org.cytoscape.work.TunableSetter;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class CyActivator
extends AbstractCyActivator {
    private static final String DIFFUSION_MENU = "Tools.Diffuse[2100]";
    private ServiceTracker ciResponseFactoryTracker = null;
    private ServiceTracker ciExceptionFactoryTracker = null;
    private ServiceTracker ciErrorFactoryTracker = null;

    public void start(BundleContext context) throws Exception {
        CyServiceRegistrar registrar = (CyServiceRegistrar)this.getService(context, CyServiceRegistrar.class);
        ViewWriterFactoryManager viewWriterManager = new ViewWriterFactoryManager();
        this.registerServiceListener(context, viewWriterManager, "addFactory", "removeFactory", CyNetworkViewWriterFactory.class);
        TunableSetter tunableSetterServiceRef = (TunableSetter)this.getService(context, TunableSetter.class);
        VisualMappingManager vmm = (VisualMappingManager)this.getService(context, VisualMappingManager.class);
        NewNetworkSelectedNodesOnlyTaskFactory createSubnetworkFactory = (NewNetworkSelectedNodesOnlyTaskFactory)this.getService(context, NewNetworkSelectedNodesOnlyTaskFactory.class);
        CyApplicationManager cyApplicationManagerService = (CyApplicationManager)this.getService(context, CyApplicationManager.class);
        SynchronousTaskManager synchronousTaskManager = (SynchronousTaskManager)this.getService(context, SynchronousTaskManager.class);
        CyNetworkManager cyNetworkManager = (CyNetworkManager)this.getService(context, CyNetworkManager.class);
        CyNetworkViewManager cyNetworkViewManager = (CyNetworkViewManager)this.getService(context, CyNetworkViewManager.class);
        RenderingEngineManager renderingEngineMgr = (RenderingEngineManager)this.getService(context, RenderingEngineManager.class);
        CySwingApplication swingApplication = (CySwingApplication)this.getService(context, CySwingApplication.class);
        LoadVizmapFileTaskFactory vizmapLoader = (LoadVizmapFileTaskFactory)this.getService(context, LoadVizmapFileTaskFactory.class);
        CyProperty props = (CyProperty)this.getService(context, CyProperty.class, "(cyPropertyName=cytoscape3.props)");
        RemoteLogger.configureFromCyProperties((CyProperty<Properties>)props);
        DiffusionTableManager tableManager = new DiffusionTableManager();
        this.registerAllServices(context, tableManager, new Properties());
        DiffusionServiceClient client = new DiffusionServiceClient((CyProperty<Properties>)props);
        OutputPanel outputPanel = new OutputPanel(registrar, tableManager, vizmapLoader, cyApplicationManagerService, vmm, createSubnetworkFactory, renderingEngineMgr, swingApplication);
        Properties outputPanelProps = new Properties();
        this.registerService(context, outputPanel, SetCurrentNetworkListener.class, outputPanelProps);
        this.registerService(context, outputPanel, NetworkAboutToBeDestroyedListener.class);
        DiffusionContextMenuTaskFactory diffusionContextMenuTaskFactory = new DiffusionContextMenuTaskFactory(registrar, tableManager, outputPanel, viewWriterManager, swingApplication, cyApplicationManagerService, client, tunableSetterServiceRef);
        String exampleJson = "{\n    \"heatColumn\": \"diffusion_output_heat\",\n    \"rankColumn\": \"diffusion_output_rank\"\n}";
        Properties diffusionTaskFactoryProps = new Properties();
        diffusionTaskFactoryProps.setProperty("commandNamespace", "diffusion");
        diffusionTaskFactoryProps.setProperty("command", "diffuse");
        diffusionTaskFactoryProps.setProperty("commandDescription", "Execute Diffusion on Selected Nodes");
        diffusionTaskFactoryProps.setProperty("commandLongDescription", "Diffusion will send the selected network view and its selected nodes to a web-based REST service to calculate network propagation. Results are returned and represented by columns in the node table.\n\nColumns are created for each execution of Diffusion and their names are returned in the response.\n\nThe nodes you would like to use as input should be selected. This will be used to generate the contents of the **diffusion\\_input** column, which represents the query vector and corresponds to h in the diffusion equation.\n\n");
        diffusionTaskFactoryProps.setProperty("commandSupportsJSON", "true");
        diffusionTaskFactoryProps.setProperty("commandExampleJSON", exampleJson);
        diffusionTaskFactoryProps.setProperty("preferredMenu", "Diffuse");
        diffusionTaskFactoryProps.setProperty("inMenuBar", "false");
        diffusionTaskFactoryProps.setProperty("inContextMenu", "true");
        diffusionTaskFactoryProps.setProperty("title", "Selected Nodes");
        diffusionTaskFactoryProps.setProperty("enableFor", "selectedNodes");
        DiffusionContextMenuTaskFactory withOptionsTaskFactory = new DiffusionContextMenuTaskFactory(registrar, tableManager, outputPanel, viewWriterManager, swingApplication, cyApplicationManagerService, client, tunableSetterServiceRef, true);
        Properties wOptsProps = new Properties();
        wOptsProps.setProperty("commandNamespace", "diffusion");
        wOptsProps.setProperty("command", "diffuse_advanced");
        wOptsProps.setProperty("commandDescription", "Execute Diffusion with Options");
        wOptsProps.setProperty("commandLongDescription", "Diffusion will send the selected network view and its selected nodes to a web-based REST service to calculate network propagation. Results are returned and represented by columns in the node table.\n\nColumns are created for each execution of Diffusion and their names are returned in the response.\n\n");
        wOptsProps.setProperty("commandSupportsJSON", "true");
        wOptsProps.setProperty("commandExampleJSON", exampleJson);
        wOptsProps.setProperty("preferredMenu", "Diffuse");
        wOptsProps.setProperty("inMenuBar", "false");
        wOptsProps.setProperty("inContextMenu", "true");
        wOptsProps.setProperty("title", "Selected Nodes with Options");
        this.ciResponseFactoryTracker = new ServiceTracker(context, context.createFilter("(objectClass=org.cytoscape.ci.CIResponseFactory)"), null);
        this.ciResponseFactoryTracker.open();
        this.ciExceptionFactoryTracker = new ServiceTracker(context, context.createFilter("(objectClass=org.cytoscape.ci.CIExceptionFactory)"), null);
        this.ciExceptionFactoryTracker.open();
        this.ciErrorFactoryTracker = new ServiceTracker(context, context.createFilter("(objectClass=org.cytoscape.ci.CIErrorFactory)"), null);
        this.ciErrorFactoryTracker.open();
        DiffusionResource diffusionResource = new DiffusionResource(cyApplicationManagerService, (SynchronousTaskManager<Object>)synchronousTaskManager, cyNetworkManager, cyNetworkViewManager, diffusionContextMenuTaskFactory, withOptionsTaskFactory, this.ciResponseFactoryTracker, this.ciExceptionFactoryTracker, this.ciErrorFactoryTracker);
        this.registerService(context, diffusionResource, DiffusionResource.class, new Properties());
        wOptsProps.setProperty("enableFor", "selectedNodes");
        EdgeContextMenuTaskFactory edgeContextMenuTaskFactory = new EdgeContextMenuTaskFactory(registrar, tableManager, outputPanel, viewWriterManager, swingApplication, cyApplicationManagerService, client, tunableSetterServiceRef, false);
        Properties edgeProps = new Properties();
        edgeProps.setProperty("preferredMenu", "Diffuse");
        edgeProps.setProperty("inMenuBar", "false");
        edgeProps.setProperty("inContextMenu", "true");
        edgeProps.setProperty("title", "Selected Nodes");
        edgeProps.setProperty("enableFor", "selectedNodes");
        EdgeContextMenuTaskFactory edgeContextMenuTaskFactoryOpt = new EdgeContextMenuTaskFactory(registrar, tableManager, outputPanel, viewWriterManager, swingApplication, cyApplicationManagerService, client, tunableSetterServiceRef, true);
        Properties edgePropsOpt = new Properties();
        edgePropsOpt.setProperty("preferredMenu", "Diffuse");
        edgePropsOpt.setProperty("inMenuBar", "false");
        edgePropsOpt.setProperty("inContextMenu", "true");
        edgePropsOpt.setProperty("title", "Selected Nodes with Options");
        edgePropsOpt.setProperty("enableFor", "selectedNodes");
        DiffusionContextMenuTaskFactory noOptionsTaskFactoryTool = new DiffusionContextMenuTaskFactory(registrar, tableManager, outputPanel, viewWriterManager, swingApplication, cyApplicationManagerService, client, tunableSetterServiceRef, false);
        Properties diffusionTaskFactoryPropsTool1 = new Properties();
        diffusionTaskFactoryPropsTool1.setProperty("preferredMenu", DIFFUSION_MENU);
        diffusionTaskFactoryPropsTool1.setProperty("menuGravity", "1.0");
        diffusionTaskFactoryPropsTool1.setProperty("inContextMenu", "false");
        diffusionTaskFactoryPropsTool1.setProperty("title", "Selected Nodes");
        diffusionTaskFactoryPropsTool1.setProperty("enableFor", "selectedNodes");
        DiffusionContextMenuTaskFactory withOptionsTaskFactoryTool = new DiffusionContextMenuTaskFactory(registrar, tableManager, outputPanel, viewWriterManager, swingApplication, cyApplicationManagerService, client, tunableSetterServiceRef, true);
        Properties diffusionTaskFactoryPropsTool2 = new Properties();
        diffusionTaskFactoryPropsTool2.setProperty("preferredMenu", DIFFUSION_MENU);
        diffusionTaskFactoryPropsTool2.setProperty("menuGravity", "1.0");
        diffusionTaskFactoryPropsTool2.setProperty("inContextMenu", "false");
        diffusionTaskFactoryPropsTool2.setProperty("title", "Selected Nodes with Options");
        diffusionTaskFactoryPropsTool2.setProperty("enableFor", "selectedNodes");
        this.registerAllServices(context, (Object)diffusionContextMenuTaskFactory, diffusionTaskFactoryProps);
        this.registerAllServices(context, (Object)withOptionsTaskFactory, wOptsProps);
        this.registerAllServices(context, (Object)edgeContextMenuTaskFactory, edgeProps);
        this.registerAllServices(context, (Object)edgeContextMenuTaskFactoryOpt, edgePropsOpt);
        this.registerAllServices(context, (Object)noOptionsTaskFactoryTool, diffusionTaskFactoryPropsTool1);
        this.registerAllServices(context, (Object)withOptionsTaskFactoryTool, diffusionTaskFactoryPropsTool2);
    }

    public void shutDown() {
        if (this.ciResponseFactoryTracker != null) {
            this.ciResponseFactoryTracker.close();
        }
        if (this.ciExceptionFactoryTracker != null) {
            this.ciExceptionFactoryTracker.close();
        }
        if (this.ciErrorFactoryTracker != null) {
            this.ciErrorFactoryTracker.close();
        }
        super.shutDown();
    }
}

