/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.webservice.biomart.ui;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.io.webservice.TableImportWebServiceClient;
import org.cytoscape.io.webservice.biomart.BiomartClient;
import org.cytoscape.io.webservice.biomart.BiomartQuery;
import org.cytoscape.io.webservice.biomart.rest.Attribute;
import org.cytoscape.io.webservice.biomart.rest.Dataset;
import org.cytoscape.io.webservice.biomart.rest.Filter;
import org.cytoscape.io.webservice.biomart.rest.XMLQueryBuilder;
import org.cytoscape.io.webservice.biomart.task.ImportAttributeListTask;
import org.cytoscape.io.webservice.biomart.task.ImportFilterTask;
import org.cytoscape.io.webservice.biomart.task.LoadRepositoryResult;
import org.cytoscape.io.webservice.biomart.task.LoadRepositoryTask;
import org.cytoscape.io.webservice.biomart.task.ShowBiomartDialogTask;
import org.cytoscape.io.webservice.biomart.ui.AttributeImportPanel;
import org.cytoscape.io.webservice.biomart.ui.CheckBoxJList;
import org.cytoscape.io.webservice.swing.WebServiceGUI;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.swing.DialogTaskManager;

public class BiomartAttrMappingPanel
extends AttributeImportPanel {
    private static final long serialVersionUID = 3574198525811249639L;
    private static final Icon LOGO = new ImageIcon(BiomartAttrMappingPanel.class.getResource("/images/BioMartLogo.png"));
    private Map<String, String> datasourceMap;
    private Map<String, Map<String, String[]>> attributeMap;
    private Map<String, List<String>> attributeListOrder;
    private Map<String, Map<String, String>> attrNameMap;
    private Map<String, Map<String, String>> filterMap;
    private BiomartClient client;
    private int globalTableCounter;
    private boolean initialized;
    private WebServiceGUI webServiceGUI;

    public BiomartAttrMappingPanel(WebServiceGUI webServiceGUI, CyServiceRegistrar serviceRegistrar) {
        super(LOGO, null, "Import Settings", serviceRegistrar);
        this.webServiceGUI = webServiceGUI;
    }

    public void setClient(BiomartClient client) {
        this.client = client;
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorRemoved(AncestorEvent arg0) {
            }

            @Override
            public void ancestorMoved(AncestorEvent arg0) {
            }

            @Override
            public void ancestorAdded(AncestorEvent arg0) {
                if (!BiomartAttrMappingPanel.this.initialized) {
                    BiomartAttrMappingPanel.this.initPanel();
                }
            }
        });
    }

    private void initPanel() {
        LoadRepositoryTask firstTask = new LoadRepositoryTask(this.client.getRestClient());
        ShowBiomartDialogTask showDialogTask = new ShowBiomartDialogTask(this, firstTask);
        Window parentWindow = this.webServiceGUI.getWindow(TableImportWebServiceClient.class);
        DialogTaskManager taskManager = (DialogTaskManager)this.serviceRegistrar.getService(DialogTaskManager.class);
        taskManager.setExecutionContext((Object)parentWindow);
        taskManager.execute(new TaskIterator(new Task[]{firstTask, showDialogTask}));
        this.initialized = true;
    }

    public void initDataSources(LoadRepositoryResult res) {
        this.attributeMap = new HashMap<String, Map<String, String[]>>();
        this.attributeListOrder = new HashMap<String, List<String>>();
        this.filterMap = new HashMap<String, Map<String, String>>();
        this.attrNameMap = new HashMap<String, Map<String, String>>();
        this.setMartServiceList(res);
    }

    public void setMartServiceList(LoadRepositoryResult res) {
        this.databaseComboBox.removeAllItems();
        this.datasourceMap = res.getDatasourceMap();
        List<String> dsList = res.getSortedDataSourceList();
        for (String ds : dsList) {
            this.databaseComboBox.addItem(ds);
        }
    }

    public void loadFilter() {
        Object selected = this.databaseComboBox.getSelectedItem();
        if (selected == null) {
            return;
        }
        this.attributeTypeComboBox.removeAllItems();
        String selectedDB = selected.toString();
        String selectedDBName = this.datasourceMap.get(selectedDB);
        this.fetchData(selectedDBName, SourceType.FILTER);
    }

    @Override
    protected void selectAllButtonActionPerformed(ActionEvent e) {
        Object[] elements = ((DefaultListModel)this.attrCheckboxList.getModel()).toArray();
        if (elements != null && elements.length >= 0) {
            this.attrCheckboxList.setSelectedItems(Arrays.asList(elements));
        }
    }

    @Override
    protected void selectNoneButtonActionPerformed(ActionEvent e) {
        this.attrCheckboxList.setSelectedItems(Collections.EMPTY_LIST);
    }

    @Override
    protected void databaseComboBoxActionPerformed(ActionEvent evt) {
        this.updateAttributeList();
        this.loadFilter();
    }

    private void updateAttributeList() {
        Object selected = this.databaseComboBox.getSelectedItem();
        if (selected == null) {
            return;
        }
        String selectedDB = selected.toString();
        String selectedDBName = this.datasourceMap.get(selectedDB);
        List<String> order = this.attributeListOrder.get(selectedDBName);
        this.attrCheckboxListModel = new DefaultListModel();
        this.attrCheckboxList = new CheckBoxJList();
        if (order != null) {
            for (String dispAttrName : order) {
                this.attrCheckboxListModel.addElement(dispAttrName);
            }
            this.attrCheckboxList.setModel(this.attrCheckboxListModel);
            this.availableAttrScrollPane.setViewportView(this.attrCheckboxList);
            this.availableAttrScrollPane.repaint();
        } else {
            this.fetchData(selectedDBName, SourceType.ATTRIBUTE);
        }
    }

    private void fetchData(String datasourceName, SourceType type) {
        DialogTaskManager taskManager = (DialogTaskManager)this.serviceRegistrar.getService(DialogTaskManager.class);
        taskManager.setExecutionContext(null);
        if (type.equals((Object)SourceType.ATTRIBUTE)) {
            ImportAttributeListTask firstTask = new ImportAttributeListTask(datasourceName, this.client.getRestClient());
            SetAttributeTask setAttrTask = new SetAttributeTask(firstTask);
            taskManager.execute(new TaskIterator(new Task[]{firstTask, setAttrTask}));
        } else if (type.equals((Object)SourceType.FILTER)) {
            ImportFilterTask firstTask = new ImportFilterTask(datasourceName, this.client.getRestClient());
            SetFilterTask setFilterTask = new SetFilterTask(firstTask);
            taskManager.execute(new TaskIterator(new Task[]{firstTask, setFilterTask}));
        }
    }

    private String getIDFilterString(String keyAttrName) {
        CyApplicationManager applicationManager = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class);
        CyNetwork curNetwork = applicationManager.getCurrentNetwork();
        List nodes = curNetwork.getNodeList();
        StringBuilder builder = new StringBuilder();
        CyTable defTable = curNetwork.getDefaultNodeTable();
        CyColumn column = defTable.getColumn(keyAttrName);
        Class attrDataType = column.getType();
        for (CyNode node : nodes) {
            CyRow row = defTable.getRow((Object)node.getSUID());
            Object value = row.get(keyAttrName, attrDataType);
            if (value instanceof List) {
                List values = (List)value;
                for (Object val : values) {
                    builder.append(val.toString());
                    builder.append(",");
                }
                continue;
            }
            builder.append(value.toString());
            builder.append(",");
        }
        String filterStr = builder.toString();
        filterStr = filterStr.substring(0, filterStr.length() - 1);
        return filterStr;
    }

    @Override
    protected void importAttributes() {
        BiomartQuery query = this.getTableImportQuery();
        if (query != null) {
            TaskIterator ti = this.client.createTaskIterator(query);
            ti.append((Task)new ResetAttributesTask());
            DialogTaskManager taskManager = (DialogTaskManager)this.serviceRegistrar.getService(DialogTaskManager.class);
            taskManager.execute(ti);
        }
    }

    public BiomartQuery getTableImportQuery() {
        if (this.datasourceMap == null) {
            return null;
        }
        String datasource = this.datasourceMap.get(this.databaseComboBox.getSelectedItem());
        Map<String, String> attrMap = this.attrNameMap.get(datasource);
        Map<String, String> fMap = this.filterMap.get(datasource);
        String keyAttrName = this.columnNameComboBox.getSelectedItem().toString();
        Dataset dataset = new Dataset(datasource);
        List selectedAttr = this.attrCheckboxList.getSelectedValuesList();
        Attribute[] attrs = new Attribute[selectedAttr.size() + 1];
        String filterName = fMap.get(this.attributeTypeComboBox.getSelectedItem());
        String dbName = this.databaseComboBox.getSelectedItem().toString();
        attrs[0] = dbName.contains("VARIATION") ? new Attribute(filterName + "_stable_id") : new Attribute(filterName);
        for (int i = 1; i <= selectedAttr.size(); ++i) {
            attrs[i] = new Attribute(attrMap.get(selectedAttr.get(i - 1)));
        }
        Filter[] filters = new Filter[]{new Filter(filterName, this.getIDFilterString(keyAttrName))};
        String keyInHeader = null;
        for (String key : attrMap.keySet()) {
            if (!attrMap.get(key).equals(filterName)) continue;
            keyInHeader = key.split("\\t")[1];
        }
        return this.importAttributesFromService(dataset, attrs, filters, keyInHeader);
    }

    private BiomartQuery importAttributesFromService(Dataset dataset, Attribute[] attrs, Filter[] filters, String keyInHeader) {
        String query = XMLQueryBuilder.getQueryString(dataset, attrs, filters);
        String tableName = "BioMart Annotation: " + ++this.globalTableCounter;
        return new BiomartQuery(query, keyInHeader, tableName);
    }

    @Override
    protected void refreshButtonActionPerformed(ActionEvent evt) {
        this.initPanel();
    }

    private final class ResetAttributesTask
    extends AbstractTask {
        private ResetAttributesTask() {
        }

        public void run(TaskMonitor taskMonitor) throws Exception {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BiomartAttrMappingPanel.this.updateAttributeList();
                }
            });
        }
    }

    private final class SetFilterTask
    extends AbstractTask {
        private final ImportFilterTask firstTask;

        public SetFilterTask(ImportFilterTask firstTask) {
            this.firstTask = firstTask;
        }

        public void run(TaskMonitor taskMonitor) throws Exception {
            String selectedDB = BiomartAttrMappingPanel.this.databaseComboBox.getSelectedItem().toString();
            String selectedDBName = BiomartAttrMappingPanel.this.datasourceMap.get(selectedDB);
            Map<String, String> returnValMap = this.firstTask.getFilters();
            BiomartAttrMappingPanel.this.filterMap.put(selectedDBName, returnValMap);
            final ArrayList<String> filterNames = new ArrayList<String>(returnValMap.keySet());
            Collections.sort(filterNames);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (String filter : filterNames) {
                        BiomartAttrMappingPanel.this.attributeTypeComboBox.addItem(filter);
                    }
                }
            });
        }
    }

    private final class SetAttributeTask
    extends AbstractTask {
        private final ImportAttributeListTask firstTask;

        public SetAttributeTask(ImportAttributeListTask firstTask) {
            this.firstTask = firstTask;
        }

        public void run(TaskMonitor taskMonitor) throws Exception {
            ArrayList<CallSite> order = new ArrayList<CallSite>();
            String selectedDB = BiomartAttrMappingPanel.this.databaseComboBox.getSelectedItem().toString();
            String selectedDBName = BiomartAttrMappingPanel.this.datasourceMap.get(selectedDB);
            Map<String, String[]> attributeVals = this.firstTask.getAttributeValues();
            HashMap<CallSite, String> names = new HashMap<CallSite, String>();
            BiomartAttrMappingPanel.this.attributeMap.put(selectedDBName, attributeVals);
            for (String string : attributeVals.keySet()) {
                String[] entry = attributeVals.get(string);
                if (entry == null || entry[0] == null) continue;
                String dispNameWithCategory = entry.length > 2 && entry[2] != null ? entry[2] + ": \t" + entry[0] + "\t  (" + string + ")" : " \t" + entry[0] + "\t  (" + string + ")";
                names.put((CallSite)((Object)dispNameWithCategory), string);
                order.add((CallSite)((Object)dispNameWithCategory));
            }
            BiomartAttrMappingPanel.this.attrNameMap.put(selectedDBName, names);
            Collections.sort(order);
            BiomartAttrMappingPanel.this.attrCheckboxListModel.removeAllElements();
            for (String string : order) {
                BiomartAttrMappingPanel.this.attrCheckboxListModel.addElement(string);
            }
            BiomartAttrMappingPanel.this.attributeListOrder.put(selectedDBName, order);
            BiomartAttrMappingPanel.this.attrCheckboxList.setModel(BiomartAttrMappingPanel.this.attrCheckboxListModel);
            BiomartAttrMappingPanel.this.availableAttrScrollPane.setViewportView(BiomartAttrMappingPanel.this.attrCheckboxList);
            BiomartAttrMappingPanel.this.availableAttrScrollPane.repaint();
        }
    }

    public static enum SourceType {
        DATABASE,
        ATTRIBUTE,
        FILTER;

    }
}

