/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.webservice.biomart;

import java.util.Properties;
import org.cytoscape.io.webservice.biomart.BiomartClient;
import org.cytoscape.io.webservice.biomart.rest.BiomartRestClient;
import org.cytoscape.io.webservice.biomart.ui.BiomartAttrMappingPanel;
import org.cytoscape.io.webservice.swing.WebServiceGUI;
import org.cytoscape.model.CyTableFactory;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.property.CyProperty;
import org.cytoscape.service.util.AbstractCyActivator;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.edit.ImportDataTableTaskFactory;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CyActivator
extends AbstractCyActivator {
    private static final Logger logger = LoggerFactory.getLogger(BiomartRestClient.class);
    private static final String MART_URL_PROP_NAME = "biomart.url";
    private static final String DEF_MART = "http://www.ensembl.org/biomart/martservice";

    public void start(BundleContext bc) {
        CyProperty cyProp = (CyProperty)this.getService(bc, CyProperty.class, "(cyPropertyName=cytoscape3.props)");
        CyServiceRegistrar serviceRegistrar = (CyServiceRegistrar)this.getService(bc, CyServiceRegistrar.class);
        CyTableManager cyTableManagerServiceRef = (CyTableManager)this.getService(bc, CyTableManager.class);
        CyTableFactory cyTableFactoryServiceRef = (CyTableFactory)this.getService(bc, CyTableFactory.class);
        ImportDataTableTaskFactory importAttrTFServiceRef = (ImportDataTableTaskFactory)this.getService(bc, ImportDataTableTaskFactory.class);
        WebServiceGUI webServiceGUI = (WebServiceGUI)this.getService(bc, WebServiceGUI.class);
        String martUrl = ((Properties)cyProp.getProperties()).getProperty(MART_URL_PROP_NAME);
        if (martUrl == null || martUrl.equals("")) {
            martUrl = DEF_MART;
            ((Properties)cyProp.getProperties()).setProperty(MART_URL_PROP_NAME, martUrl);
        }
        logger.info("Biomart Service URL is: " + martUrl);
        BiomartRestClient biomartRestClient = new BiomartRestClient(martUrl);
        BiomartAttrMappingPanel biomartAttrMappingPanel = new BiomartAttrMappingPanel(webServiceGUI, serviceRegistrar);
        BiomartClient biomartClient = new BiomartClient("BioMart Client", "REST version of BioMart Web Service Client.", biomartRestClient, cyTableFactoryServiceRef, cyTableManagerServiceRef, biomartAttrMappingPanel, importAttrTFServiceRef);
        biomartAttrMappingPanel.setClient(biomartClient);
        this.registerAllServices(bc, biomartAttrMappingPanel, new Properties());
        this.registerAllServices(bc, (Object)biomartClient, new Properties());
    }
}

