/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.linkout.internal;

import org.cytoscape.linkout.internal.LinkoutTask;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.task.AbstractEdgeViewTaskFactory;
import org.cytoscape.util.swing.OpenBrowser;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;

public class EdgeLinkoutTaskFactory
extends AbstractEdgeViewTaskFactory {
    private String link;
    private final OpenBrowser browser;

    public EdgeLinkoutTaskFactory(OpenBrowser browser, String link) {
        this.link = link;
        this.browser = browser;
    }

    public TaskIterator createTaskIterator(View<CyEdge> edgeView, CyNetworkView netView) {
        return new TaskIterator(new Task[]{this.createTask(edgeView, netView)});
    }

    private LinkoutTask createTask(View<CyEdge> edgeView, CyNetworkView netView) {
        return new LinkoutTask(this.link, this.browser, (CyNetwork)netView.getModel(), new CyIdentifiable[]{((CyEdge)edgeView.getModel()).getSource(), ((CyEdge)edgeView.getModel()).getTarget(), (CyIdentifiable)edgeView.getModel()});
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public boolean isReady(View<CyEdge> edgeView, CyNetworkView netView) {
        if (!super.isReady(edgeView, netView)) {
            return false;
        }
        LinkoutTask task = this.createTask(edgeView, netView);
        return task.isValidUrl();
    }
}

