/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.search.internal;

import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.store.RAMDirectory;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.search.internal.EnhancedSearch;

public class EnhancedSearchManager
implements EnhancedSearch {
    private Map<CyNetwork, RAMDirectory> networkIndexMap = new HashMap<CyNetwork, RAMDirectory>();
    private Map<CyNetwork, EnhancedSearch.Status> networkIndexStatusMap = new HashMap<CyNetwork, EnhancedSearch.Status>();

    @Override
    public synchronized void removeNetworkIndex(CyNetwork network) {
        this.networkIndexMap.remove(network);
        this.networkIndexStatusMap.remove(network);
    }

    @Override
    public synchronized RAMDirectory getNetworkIndex(CyNetwork network) {
        return this.networkIndexMap.get(network);
    }

    @Override
    public synchronized EnhancedSearch.Status getNetworkIndexStatus(CyNetwork network) {
        return this.networkIndexStatusMap.get(network);
    }

    @Override
    public synchronized void setNetworkIndex(CyNetwork network, RAMDirectory index) {
        this.networkIndexMap.put(network, index);
        this.networkIndexStatusMap.put(network, EnhancedSearch.Status.INDEX_SET);
    }

    @Override
    public synchronized void setNetworkIndexStatus(CyNetwork network, EnhancedSearch.Status status) {
        if (status == EnhancedSearch.Status.INDEX_SET || status == EnhancedSearch.Status.REINDEX) {
            this.networkIndexStatusMap.put(network, status);
        } else {
            System.out.println("Invalid status '" + status + "'");
        }
    }

    public void clear() {
        this.networkIndexMap.clear();
        this.networkIndexStatusMap.clear();
    }
}

