/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.util.internal.color;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cytoscape.util.color.BrewerType;
import org.cytoscape.util.color.Palette;
import org.cytoscape.util.color.PaletteProvider;
import org.cytoscape.util.color.PaletteType;
import org.cytoscape.util.internal.color.AbstractPalette;
import org.cytoscape.util.internal.color.Viridis;

public class ViridisPaletteProvider
implements PaletteProvider {
    Map<String, Viridis> paletteMap = new HashMap<String, Viridis>();

    public ViridisPaletteProvider() {
        this.paletteMap.put(Viridis.Viridis.getName(), Viridis.Viridis);
        this.paletteMap.put(Viridis.Magma.getName(), Viridis.Magma);
        this.paletteMap.put(Viridis.Inferno.getName(), Viridis.Inferno);
        this.paletteMap.put(Viridis.Plasma.getName(), Viridis.Plasma);
    }

    public String getProviderName() {
        return "Viridis";
    }

    public List<PaletteType> getPaletteTypes() {
        return Arrays.asList(BrewerType.SEQUENTIAL);
    }

    public List<String> listPaletteNames(PaletteType type, boolean colorBlindSafe) {
        if (type != BrewerType.SEQUENTIAL && type != BrewerType.ANY) {
            return null;
        }
        return new ArrayList<String>(this.paletteMap.keySet());
    }

    public List<Object> listPaletteIdentifiers(PaletteType type, boolean colorBlindSafe) {
        if (type != BrewerType.SEQUENTIAL && type != BrewerType.ANY) {
            return null;
        }
        return new ArrayList<Viridis>(this.paletteMap.values());
    }

    public Palette getPalette(String paletteName) {
        return this.getPalette(paletteName, -1);
    }

    public Palette getPalette(String paletteName, int size) {
        for (String name : this.paletteMap.keySet()) {
            if (!name.equalsIgnoreCase(paletteName)) continue;
            return new PaletteWrapper(this, this.paletteMap.get(name), size);
        }
        return null;
    }

    public Palette getPalette(Object paletteIdentifier) {
        return this.getPalette(paletteIdentifier, -1);
    }

    public Palette getPalette(Object paletteIdentifier, int size) {
        for (Viridis cb : this.paletteMap.values()) {
            if (!paletteIdentifier.equals((Object)cb)) continue;
            return new PaletteWrapper(this, cb, size);
        }
        return null;
    }

    class PaletteWrapper
    extends AbstractPalette {
        Viridis palette;
        PaletteProvider provider;

        public PaletteWrapper(PaletteProvider provider, Viridis cbPalette, int size) {
            super(provider, cbPalette.getName(), size, (PaletteType)BrewerType.SEQUENTIAL, true);
            this.palette = cbPalette;
            if (size < 0) {
                size = cbPalette.getColors().length;
            }
            this.provider = provider;
        }

        @Override
        public String getName() {
            if (this.reversed) {
                return this.palette.getDescription() + " (R)";
            }
            return this.palette.getDescription();
        }

        @Override
        public Object getIdentifier() {
            return this.palette;
        }

        @Override
        public boolean isColorBlindSafe() {
            return true;
        }

        @Override
        public boolean isReversable() {
            return true;
        }

        @Override
        public PaletteType getType() {
            return this.type;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public Color[] getColors(int nColors) {
            if (this.reversed) {
                return this.reverseColors(this.palette.getColorPalette(nColors));
            }
            return this.palette.getColorPalette(nColors);
        }

        @Override
        public Color[] getColors() {
            return this.getColors(this.size);
        }

        public String toString() {
            return "Viridis " + this.getName();
        }

        @Override
        public PaletteProvider getPaletteProvider() {
            return this.provider;
        }
    }
}

