/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.util.internal.color;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.cytoscape.util.color.BrewerType;
import org.cytoscape.util.color.Palette;
import org.cytoscape.util.color.PaletteProvider;
import org.cytoscape.util.color.PaletteType;
import org.cytoscape.util.internal.color.AbstractPalette;

public class RainbowPaletteProvider
implements PaletteProvider {
    public String getProviderName() {
        return "Rainbow";
    }

    public List<PaletteType> getPaletteTypes() {
        return Collections.singletonList(BrewerType.QUALITATIVE);
    }

    public List<String> listPaletteNames(PaletteType type, boolean colorBlindSafe) {
        if (type.equals(BrewerType.QUALITATIVE) || type.equals(BrewerType.ANY)) {
            return Arrays.asList("Rainbow");
        }
        return new ArrayList<String>();
    }

    public List<Object> listPaletteIdentifiers(PaletteType type, boolean colorBlindSafe) {
        return this.listPaletteNames(type, colorBlindSafe);
    }

    public Palette getPalette(String paletteName) {
        return this.getPalette(paletteName, 8);
    }

    public Palette getPalette(String paletteName, int size) {
        if (paletteName.equalsIgnoreCase("Rainbow") || paletteName.equalsIgnoreCase(" ")) {
            return new RainbowPalette(this, size);
        }
        return null;
    }

    public Palette getPalette(Object paletteIdentifier) {
        return this.getPalette((String)paletteIdentifier);
    }

    public Palette getPalette(Object paletteIdentifier, int size) {
        return this.getPalette((String)paletteIdentifier, size);
    }

    class RainbowPalette
    extends AbstractPalette {
        RainbowPalette(PaletteProvider provider, int size) {
            super(provider, "Rainbow", size, (PaletteType)BrewerType.QUALITATIVE, false);
        }

        @Override
        public Color[] getColors() {
            return this.getColors(this.size);
        }

        @Override
        public boolean isReversable() {
            return false;
        }

        @Override
        public Color[] getColors(int nColors) {
            Color[] colors = new Color[nColors];
            float increment = 1.0f / (float)nColors;
            float hue = 0.0f;
            for (int i = 0; i < nColors; ++i) {
                colors[i] = new Color(Color.HSBtoRGB(hue += increment, 1.0f, 1.0f));
            }
            return colors;
        }

        public String toString() {
            return "Rainbow";
        }
    }
}

