/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.work.internal.sync;

import java.util.Map;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.TaskObserver;
import org.cytoscape.work.TunableRecorder;
import org.cytoscape.work.internal.sync.DelegatingTaskMonitor;
import org.cytoscape.work.internal.sync.SyncTunableMutator;
import org.cytoscape.work.internal.sync.TunableRecorderManager;

public class DelegateTask
extends AbstractTask {
    private final SyncTunableMutator stm;
    private final TunableRecorderManager trm;
    private final TaskIterator ti;
    private final TaskObserver observer;
    private final Map<String, Object> tunableValues;
    private volatile Task currentTask = null;

    public DelegateTask(SyncTunableMutator stm, TunableRecorderManager trm, TaskIterator ti, Map<String, Object> tunableValues, TaskObserver observer) {
        this.stm = stm;
        this.trm = trm;
        this.ti = ti;
        this.tunableValues = tunableValues;
        this.observer = observer;
    }

    public void run(TaskMonitor tm) throws Exception {
        DelegatingTaskMonitor dtm = new DelegatingTaskMonitor(tm, this.ti.getNumTasks());
        this.stm.setConfigurationContext(this.tunableValues);
        while (this.ti.hasNext()) {
            Task task = this.ti.next();
            dtm.setTask(task);
            if (!this.setTunables(task)) {
                return;
            }
            this.currentTask = task;
            task.run((TaskMonitor)dtm);
            if (this.currentTask instanceof ObservableTask && this.observer != null) {
                this.observer.taskFinished((ObservableTask)this.currentTask);
            }
            this.currentTask = null;
        }
    }

    public void cancel() {
        this.cancelled = true;
        if (this.currentTask != null) {
            this.currentTask.cancel();
        }
    }

    private boolean setTunables(Object task) throws Exception {
        if (task == null) {
            return true;
        }
        boolean ret = this.stm.validateAndWriteBack(task);
        for (TunableRecorder ti : this.trm.getRecorders()) {
            ti.recordTunableState(task);
        }
        return ret;
    }
}

