/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.work.internal.properties;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.cytoscape.work.AbstractTunableInterceptor;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.TunableHandler;
import org.cytoscape.work.properties.TunablePropertyHandler;
import org.cytoscape.work.properties.TunablePropertySerializer;

public class TunablePropertySerializerImpl
extends AbstractTunableInterceptor<TunablePropertyHandler>
implements TunablePropertySerializer {
    public void setTunables(Object objectWithTunables, Properties properties) {
        this.getHandlers(objectWithTunables);
        Map propertyToHandler = TunablePropertySerializerImpl.getHandlerMap(objectWithTunables, this.handlerMap);
        for (Map.Entry entry : propertyToHandler.entrySet()) {
            String propValue = properties.getProperty(entry.getKey());
            if (propValue == null) continue;
            TunablePropertyHandler handler = (TunablePropertyHandler)entry.getValue();
            handler.parseAndSetValue(propValue);
        }
    }

    public Properties toProperties(Object objectWithTunables) {
        this.getHandlers(objectWithTunables);
        Map propertyToHandler = TunablePropertySerializerImpl.getHandlerMap(objectWithTunables, this.handlerMap);
        Properties properties = new Properties();
        for (Map.Entry entry : propertyToHandler.entrySet()) {
            properties.setProperty(entry.getKey(), ((TunablePropertyHandler)entry.getValue()).toPropertyValue());
        }
        return properties;
    }

    private static <T extends TunableHandler> Map<String, T> getHandlerMap(Object objectWithTunables, Map<Object, List<T>> handlerMap) {
        HashMap<Object, List<T>> handlers = new HashMap<Object, List<T>>(handlerMap);
        HashMap propertyToHandler = new HashMap();
        try {
            TunablePropertySerializerImpl.recursivleyApplyHandlers(objectWithTunables, handlers, propertyToHandler, new LinkedList<String>());
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        return propertyToHandler;
    }

    private static <T extends TunableHandler> void recursivleyApplyHandlers(Object object, Map<Object, List<T>> handlers, Map<String, T> propertyToHandler, LinkedList<String> path) throws IllegalAccessException, InvocationTargetException {
        for (Field field : object.getClass().getFields()) {
            if (!field.isAnnotationPresent(ContainsTunables.class)) continue;
            String name = field.getName();
            path.addLast(name);
            Object tunableContainer = field.get(object);
            TunablePropertySerializerImpl.recursivleyApplyHandlers(tunableContainer, handlers, propertyToHandler, path);
            path.removeLast();
        }
        for (TunableHandler handler : handlers.get(object)) {
            String prefix = path.isEmpty() ? "" : path.stream().collect(Collectors.joining(".", "", "."));
            String key = prefix + handler.getName();
            propertyToHandler.put(key, handler);
        }
        TunablePropertySerializerImpl.removeHandlers(object, handlers);
    }

    private static <T extends TunableHandler> void removeHandlers(Object object, Map<Object, List<T>> handlers) {
        List<T> handlersForObject = handlers.remove(object);
        for (Object key : handlers.keySet()) {
            handlers.get(key).removeAll(handlersForObject);
        }
    }
}

