/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.work.internal.properties;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import org.cytoscape.work.AbstractTunableHandler;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.internal.properties.BasicTypePropertyHandler;
import org.cytoscape.work.properties.TunablePropertyHandler;

public abstract class ParameterizedTypePropertyHandler<T>
extends AbstractTunableHandler
implements TunablePropertyHandler {
    private final ParameterizedType genericType;

    public ParameterizedTypePropertyHandler(Field field, Object instance, Tunable tunable) {
        super(field, instance, tunable);
        this.genericType = (ParameterizedType)field.getGenericType();
    }

    public ParameterizedTypePropertyHandler(Method getter, Method setter, Object instance, Tunable tunable) {
        super(getter, setter, instance, tunable);
        this.genericType = (ParameterizedType)getter.getGenericReturnType();
    }

    protected abstract List<?> getElementValues();

    protected abstract void setElementValues(T var1, List<?> var2);

    protected T getContainer() {
        try {
            return (T)this.getValue();
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalArgumentException("Could not get value for tunable '" + this.getQualifiedName() + "'", e);
        }
    }

    public String toPropertyValue() {
        StringJoiner joiner = new StringJoiner(",");
        for (Object o : this.getElementValues()) {
            String value = BasicTypePropertyHandler.toPropertyValue(o);
            joiner.add(value);
        }
        return joiner.toString();
    }

    public void parseAndSetValue(String propertyValue) {
        T container = this.getContainer();
        Type[] typeArguments = this.genericType.getActualTypeArguments();
        if (typeArguments == null || typeArguments.length != 1) {
            throw new IllegalArgumentException("Must be a parameterized type with 1 type parameter: " + this.genericType);
        }
        Type listElementType = typeArguments[0];
        if (listElementType instanceof Class) {
            Class c = (Class)listElementType;
            String name = this.getName();
            String[] strings = propertyValue.split(",");
            ArrayList<Object> values = new ArrayList<Object>(strings.length);
            for (String s : strings) {
                values.add(BasicTypePropertyHandler.parseValue(name, s, c));
            }
            this.setElementValues(container, values);
            try {
                this.setValue(container);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalArgumentException("Bad object", e);
            }
        } else {
            throw new IllegalArgumentException("Element type is not supported: " + this.genericType);
        }
    }
}

