/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.copycatLayout.internal.rest;

import java.util.ArrayList;
import javax.ws.rs.core.Response;
import org.cytoscape.ci.model.CIResponse;
import org.cytoscape.copycatLayout.internal.rest.CopycatLayoutResource;
import org.cytoscape.copycatLayout.internal.rest.CopycatLayoutResult;
import org.cytoscape.work.FinishStatus;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskObserver;

public class CopycatLayoutTaskObserver
implements TaskObserver {
    private final CopycatLayoutResource copyLayoutResource;
    CIResponse<?> response;
    private CopycatLayoutResult result;
    private String resourcePath;
    private String errorCode;

    public CIResponse<?> getResponse() {
        return this.response;
    }

    public CopycatLayoutTaskObserver(CopycatLayoutResource copycatLayoutResource, String resourcePath, String errorCode) {
        this.copyLayoutResource = copycatLayoutResource;
        this.response = null;
        this.resourcePath = resourcePath;
        this.errorCode = errorCode;
    }

    public void allFinished(FinishStatus arg0) {
        if (arg0.getType() == FinishStatus.Type.SUCCEEDED || arg0.getType() == FinishStatus.Type.CANCELLED) {
            this.response = new CIResponse();
            this.response.data = this.result;
            this.response.errors = new ArrayList();
        } else {
            this.response = this.copyLayoutResource.buildCIErrorResponse(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.resourcePath, this.errorCode, arg0.getException().getMessage(), arg0.getException());
        }
    }

    public void taskFinished(ObservableTask arg0) {
        CopycatLayoutResult res;
        this.result = res = (CopycatLayoutResult)arg0.getResults(CopycatLayoutResult.class);
    }
}

