/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.copycatLayout.internal.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Collection;
import java.util.HashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.ci.CIErrorFactory;
import org.cytoscape.ci.CIExceptionFactory;
import org.cytoscape.ci.CIResponseFactory;
import org.cytoscape.ci.model.CIError;
import org.cytoscape.ci.model.CIResponse;
import org.cytoscape.copycatLayout.internal.rest.CopycatLayoutResult;
import org.cytoscape.copycatLayout.internal.rest.CopycatLayoutTaskObserver;
import org.cytoscape.copycatLayout.internal.rest.CopycatWithViewSUIDsLayoutParameters;
import org.cytoscape.copycatLayout.internal.task.CopycatLayoutTaskFactory;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.work.SynchronousTaskManager;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskObserver;
import org.cytoscape.work.util.ListSingleSelection;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Layouts"})
@Path(value="/v1/apply/layouts/copycat")
public class CopycatLayoutResource {
    private final CyApplicationManager cyApplicationManager;
    private final CyNetworkManager cyNetworkManager;
    private final CyNetworkViewManager cyNetworkViewManager;
    private final CopycatLayoutTaskFactory copycatLayoutTaskFactory;
    private final SynchronousTaskManager<Object> taskManager;
    private final ServiceTracker ciResponseFactoryTracker;
    private final ServiceTracker ciExceptionFactoryTracker;
    private final ServiceTracker ciErrorFactoryTracker;
    public static final String SOURCE_NETWORK_VIEW_NOT_FOUND = "1";
    public static final String SOURCE_COLUMN_NOT_FOUND = "2";
    public static final String SOURCE_COLUMN_UNSUPPORTED = "3";
    public static final String TARGET_NETWORK_VIEW_NOT_FOUND = "4";
    public static final String TARGET_COLUMN_NOT_FOUND = "5";
    public static final String TARGET_COLUMN_UNSUPPORTED = "6";
    public static final String TASK_EXECUTION_ERROR = "7";
    private static final String GENERIC_SWAGGER_NOTES = "Copy one network view layout onto another, setting the node location and view scale to match. This makes visually comparing networks simple.\n\n";
    private static final Logger logger = LoggerFactory.getLogger(CopycatLayoutResource.class);
    private static final String resourceErrorRoot = "urn:cytoscape:ci:copycatLayout-app:v1";

    private CIResponseFactory getCIResponseFactory() {
        return (CIResponseFactory)this.ciResponseFactoryTracker.getService();
    }

    private CIExceptionFactory getCIExceptionFactory() {
        return (CIExceptionFactory)this.ciExceptionFactoryTracker.getService();
    }

    private CIErrorFactory getCIErrorFactory() {
        return (CIErrorFactory)this.ciErrorFactoryTracker.getService();
    }

    public CopycatLayoutResource(CyApplicationManager cyApplicationManager, SynchronousTaskManager<Object> taskManager, CyNetworkManager cyNetworkManager, CyNetworkViewManager cyNetworkViewManager, CopycatLayoutTaskFactory copycatLayoutTaskFactory, ServiceTracker ciResponseFactoryTracker, ServiceTracker ciExceptionFactoryTracker, ServiceTracker ciErrorFactoryTracker) {
        this.cyApplicationManager = cyApplicationManager;
        this.taskManager = taskManager;
        this.cyNetworkManager = cyNetworkManager;
        this.cyNetworkViewManager = cyNetworkViewManager;
        this.copycatLayoutTaskFactory = copycatLayoutTaskFactory;
        this.ciExceptionFactoryTracker = ciExceptionFactoryTracker;
        this.ciResponseFactoryTracker = ciResponseFactoryTracker;
        this.ciErrorFactoryTracker = ciErrorFactoryTracker;
    }

    private CIError buildCIError(int status, String resourcePath, String code, String message, Exception e) {
        return this.getCIErrorFactory().getCIError(Integer.valueOf(status), "urn:cytoscape:ci:copycatLayout-app:v1:" + resourcePath + ":" + code, message);
    }

    CIResponse<Object> buildCIErrorResponse(int status, String resourcePath, String code, String message, Exception e) {
        CIResponse response = this.getCIResponseFactory().getCIResponse(new Object());
        CIError error = this.buildCIError(status, resourcePath, code, message, e);
        if (e != null) {
            logger.error(message, (Throwable)e);
        } else {
            logger.error(message);
        }
        response.errors.add(error);
        return response;
    }

    public CyNetworkView getCyNetworkView(String resourcePath, String errorType) {
        CyNetworkView cyNetworkView = this.cyApplicationManager.getCurrentNetworkView();
        if (cyNetworkView == null) {
            String messageString = "Could not find current Network View";
            throw this.getCIExceptionFactory().getCIException(404, new CIError[]{this.buildCIError(404, resourcePath, errorType, messageString, new Exception(messageString))});
        }
        return cyNetworkView;
    }

    public CyNetworkView getCyNetworkView(String resourcePath, String errorType, long networkViewSUID) {
        for (CyNetwork network : this.cyNetworkManager.getNetworkSet()) {
            Collection views = this.cyNetworkViewManager.getNetworkViews(network);
            for (CyNetworkView view : views) {
                Long vid = view.getSUID();
                if (!vid.equals(networkViewSUID)) continue;
                return view;
            }
        }
        throw this.getCIExceptionFactory().getCIException(404, new CIError[]{this.buildCIError(404, resourcePath, errorType, "No network view with SUID: " + networkViewSUID, new Exception("No network view found with SUID: " + networkViewSUID))});
    }

    private String validateNetworkName(long viewSUID, String column, String networkType) {
        String name = null;
        try {
            name = this.getNetworkNameWithColumn(viewSUID, column);
        }
        catch (NetworkViewNotFoundException e) {
            throw this.getCIExceptionFactory().getCIException(404, new CIError[]{this.buildCIError(404, "copycat-layout", networkType == "Source" ? SOURCE_NETWORK_VIEW_NOT_FOUND : TARGET_NETWORK_VIEW_NOT_FOUND, networkType + " network view with SUID " + viewSUID + " does not exist.", e)});
        }
        catch (NodeColumnNotFoundException e) {
            throw this.getCIExceptionFactory().getCIException(404, new CIError[]{this.buildCIError(404, "copycat-layout", networkType == "Source" ? SOURCE_COLUMN_NOT_FOUND : TARGET_COLUMN_NOT_FOUND, networkType + " column " + column + " not found in network.", e)});
        }
        catch (UnsupportedColumnTypeException e) {
            throw this.getCIExceptionFactory().getCIException(404, new CIError[]{this.buildCIError(404, "copycat-layout", networkType == "Source" ? SOURCE_COLUMN_UNSUPPORTED : TARGET_COLUMN_UNSUPPORTED, networkType + " column " + column + " must be of type String or Integer.", e)});
        }
        return name;
    }

    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/{sourceViewSUID}/{targetViewSUID}")
    @ApiOperation(value="Copy network view layout to another view", notes="Copy one network view layout onto another, setting the node location and view scale to match. This makes visually comparing networks simple.\n\n", response=CopycatLayoutResponse.class)
    @ApiResponses(value={@ApiResponse(code=404, message="Network View does not exist", response=CIResponse.class)})
    public Response copyCurrentLayout(@PathParam(value="sourceViewSUID") @ApiParam(value="Source network view SUID (or \"current\")") String sourceViewSUID, @PathParam(value="targetViewSUID") @ApiParam(value="Target network view SUID (or \"current\")") String targetViewSUID, @ApiParam(value="Clone the specified network view layout onto another network view") CopycatWithViewSUIDsLayoutParameters params) {
        if (params == null) {
            params = new CopycatWithViewSUIDsLayoutParameters();
        }
        try {
            Long sViewSUID = this.parseSUIDFromString(sourceViewSUID);
            Long tViewSUID = this.parseSUIDFromString(sourceViewSUID);
            return this.copyLayout(sViewSUID, params.sourceColumn, tViewSUID, params.targetColumn, params.selectUnmapped, params.gridUnmapped);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Long getCurrentNetworkViewSUID() throws Exception {
        CyNetworkView view = this.cyApplicationManager.getCurrentNetworkView();
        if (view == null) {
            throw new Exception("No current network view");
        }
        return view.getSUID();
    }

    public Long parseSUIDFromString(String suid) throws Exception {
        if (suid.toLowerCase().equals("current")) {
            return this.getCurrentNetworkViewSUID();
        }
        if (suid.matches("\\d+")) {
            return Long.parseLong(suid);
        }
        throw new Exception("Cannot parse SUID from " + suid);
    }

    private Response copyLayout(long sourceViewSUID, String sourceColumn, long targetViewSUID, String targetColumn, boolean selectUnmapped, boolean gridUnmapped) {
        CopycatLayoutTaskObserver taskObserver = new CopycatLayoutTaskObserver(this, "copycat-layout", TASK_EXECUTION_ERROR);
        HashMap<String, Object> tunableMap = new HashMap<String, Object>();
        TaskIterator taskIterator = this.copycatLayoutTaskFactory.createTaskIterator();
        String sourceName = this.validateNetworkName(sourceViewSUID, sourceColumn, "Source");
        String targetName = this.validateNetworkName(targetViewSUID, targetColumn, "Target");
        if (sourceViewSUID == targetViewSUID) {
            throw this.getCIExceptionFactory().getCIException(400, new CIError[]{this.buildCIError(400, "copycat-layout", TASK_EXECUTION_ERROR, "Source and destination network views cannot be the same.", new Exception("Source and destination network views cannot be the same."))});
        }
        ListSingleSelection sourceList = new ListSingleSelection((Object[])new String[]{sourceName});
        sourceList.setSelectedValue((Object)sourceName);
        ListSingleSelection sourceColumnList = new ListSingleSelection((Object[])new String[]{sourceColumn});
        sourceColumnList.setSelectedValue((Object)sourceColumn);
        ListSingleSelection targetList = new ListSingleSelection((Object[])new String[]{targetName});
        targetList.setSelectedValue((Object)targetName);
        ListSingleSelection targetColumnList = new ListSingleSelection((Object[])new String[]{targetColumn});
        targetColumnList.setSelectedValue((Object)targetColumn);
        tunableMap.put("sourceNetwork", sourceList);
        tunableMap.put("targetNetwork", targetList);
        tunableMap.put("sourceColumn", sourceColumnList);
        tunableMap.put("targetColumn", targetColumnList);
        tunableMap.put("selectUnmapped", selectUnmapped);
        tunableMap.put("gridUnmapped", gridUnmapped);
        this.taskManager.setExecutionContext(tunableMap);
        this.taskManager.execute(taskIterator, (TaskObserver)taskObserver);
        return Response.status((Response.Status)(taskObserver.response.errors.size() == 0 ? Response.Status.OK : Response.Status.INTERNAL_SERVER_ERROR)).type("application/json").entity(taskObserver.response).build();
    }

    private String getNetworkNameWithColumn(long networkViewSUID, String column) throws NetworkViewNotFoundException, UnsupportedColumnTypeException, NodeColumnNotFoundException {
        for (CyNetwork net : this.cyNetworkManager.getNetworkSet()) {
            for (CyNetworkView view : this.cyNetworkViewManager.getNetworkViews(net)) {
                if (view.getSUID() != networkViewSUID) continue;
                CyColumn col = net.getDefaultNodeTable().getColumn(column);
                if (col == null) {
                    throw new NodeColumnNotFoundException();
                }
                if (col.getType() != String.class && col.getType() != Integer.class) {
                    throw new UnsupportedColumnTypeException();
                }
                return (String)net.getRow((CyIdentifiable)net).get("name", String.class);
            }
        }
        throw new NetworkViewNotFoundException();
    }

    private class UnsupportedColumnTypeException
    extends Exception {
        private UnsupportedColumnTypeException() {
        }
    }

    private class NodeColumnNotFoundException
    extends Exception {
        private NodeColumnNotFoundException() {
        }
    }

    private class NetworkViewNotFoundException
    extends Exception {
        private NetworkViewNotFoundException() {
        }
    }

    @ApiModel(value="Copycat Layout Response", description="Number of successfully and unsuccessfully mappes node locations", parent=CIResponse.class)
    public static class CopycatLayoutResponse
    extends CIResponse<CopycatLayoutResult> {
    }
}

