/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.view.help;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.cytoscape.application.CyVersion;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.OpenBrowser;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;

public class HelpReportABugTask
extends AbstractTask {
    private static final String BUG_REPORT_URL = "https://cytoscape.org/bug-report.html";
    private final CyServiceRegistrar serviceRegistrar;

    public HelpReportABugTask(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    public void run(TaskMonitor tm) {
        String javaVersion;
        Object os_str = System.getProperty("os.name") + "_" + System.getProperty("os.version");
        os_str = ((String)os_str).replace(" ", "_");
        OpenBrowser openBrowser = (OpenBrowser)this.serviceRegistrar.getService(OpenBrowser.class);
        CyVersion cyVersion = (CyVersion)this.serviceRegistrar.getService(CyVersion.class);
        try {
            javaVersion = URLEncoder.encode(System.getProperty("java.version"), StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            javaVersion = "unknown";
        }
        openBrowser.openURL("https://cytoscape.org/bug-report.html?cyversion=" + cyVersion.getVersion() + "&os=" + (String)os_str + "&javaversion=" + javaVersion);
    }
}

