/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.view;

import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.events.SetCurrentNetworkEvent;
import org.cytoscape.application.events.SetCurrentNetworkListener;
import org.cytoscape.application.events.SetCurrentNetworkViewEvent;
import org.cytoscape.application.events.SetCurrentNetworkViewListener;
import org.cytoscape.application.events.SetCurrentTableEvent;
import org.cytoscape.application.events.SetCurrentTableListener;
import org.cytoscape.application.swing.CyAction;
import org.cytoscape.event.DebounceTimer;
import org.cytoscape.internal.view.util.CyToolBar;
import org.cytoscape.internal.view.util.ViewUtil;
import org.cytoscape.model.events.NetworkAddedEvent;
import org.cytoscape.model.events.NetworkAddedListener;
import org.cytoscape.model.events.NetworkDestroyedEvent;
import org.cytoscape.model.events.NetworkDestroyedListener;
import org.cytoscape.model.events.RowsSetEvent;
import org.cytoscape.model.events.RowsSetListener;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.events.SessionAboutToBeLoadedEvent;
import org.cytoscape.session.events.SessionAboutToBeLoadedListener;
import org.cytoscape.session.events.SessionAboutToBeSavedEvent;
import org.cytoscape.session.events.SessionAboutToBeSavedListener;
import org.cytoscape.session.events.SessionLoadedEvent;
import org.cytoscape.session.events.SessionLoadedListener;
import org.cytoscape.session.events.SessionSaveCancelledEvent;
import org.cytoscape.session.events.SessionSaveCancelledListener;
import org.cytoscape.session.events.SessionSavedEvent;
import org.cytoscape.session.events.SessionSavedListener;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.events.NetworkViewAddedEvent;
import org.cytoscape.view.model.events.NetworkViewAddedListener;
import org.cytoscape.view.model.events.NetworkViewDestroyedEvent;
import org.cytoscape.view.model.events.NetworkViewDestroyedListener;
import org.cytoscape.view.model.events.UpdateNetworkPresentationEvent;
import org.cytoscape.view.model.events.UpdateNetworkPresentationListener;

public class ToolBarEnableUpdater
implements SessionAboutToBeLoadedListener,
SessionLoadedListener,
SessionAboutToBeSavedListener,
SessionSavedListener,
SessionSaveCancelledListener,
NetworkAddedListener,
NetworkDestroyedListener,
NetworkViewAddedListener,
NetworkViewDestroyedListener,
SetCurrentNetworkListener,
SetCurrentNetworkViewListener,
SetCurrentTableListener,
RowsSetListener,
UpdateNetworkPresentationListener {
    private final DebounceTimer debounceTimer = new DebounceTimer(100);
    private boolean loadingSession;
    private final CyToolBar toolbar;
    private final CyServiceRegistrar serviceRegistrar;

    public ToolBarEnableUpdater(CyToolBar toolbar, CyServiceRegistrar serviceRegistrar) {
        this.toolbar = toolbar;
        this.serviceRegistrar = serviceRegistrar;
    }

    public void handleEvent(SessionAboutToBeLoadedEvent e) {
        this.updateToolbar();
        this.loadingSession = true;
    }

    public void handleEvent(SessionLoadedEvent e) {
        this.loadingSession = false;
        this.updateToolbar();
    }

    public void handleEvent(SessionAboutToBeSavedEvent e) {
        this.updateToolbar();
    }

    public void handleEvent(SessionSavedEvent e) {
        this.updateToolbar();
    }

    public void handleEvent(SessionSaveCancelledEvent e) {
        this.updateToolbar();
    }

    public void handleEvent(SetCurrentNetworkEvent e) {
        if (!this.loadingSession) {
            this.updateToolbar();
        }
    }

    public void handleEvent(SetCurrentNetworkViewEvent e) {
        if (!this.loadingSession) {
            this.updateToolbar();
        }
    }

    public void handleEvent(NetworkAddedEvent e) {
        if (!this.loadingSession) {
            this.updateToolbar();
        }
    }

    public void handleEvent(NetworkViewAddedEvent e) {
        if (!this.loadingSession) {
            this.updateToolbar();
        }
    }

    public void handleEvent(NetworkDestroyedEvent e) {
        if (!this.loadingSession) {
            this.updateToolbar();
        }
    }

    public void handleEvent(NetworkViewDestroyedEvent e) {
        if (!this.loadingSession) {
            this.updateToolbar();
        }
    }

    public void handleEvent(SetCurrentTableEvent e) {
        if (!this.loadingSession) {
            this.updateToolbar();
        }
    }

    public void handleEvent(RowsSetEvent e) {
        if (!this.loadingSession && e.containsColumn("selected")) {
            this.updateToolbar();
        }
    }

    public void handleEvent(UpdateNetworkPresentationEvent e) {
        if (!this.loadingSession && ((CyNetworkView)e.getSource()).equals(((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetworkView())) {
            this.updateToolbar();
        }
    }

    private void updateToolbar() {
        this.debounceTimer.debounce(() -> ViewUtil.invokeOnEDT(() -> {
            for (CyAction action : this.toolbar.getAllToolBarActions()) {
                action.updateEnableState();
            }
        }));
    }
}

