/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;

public class SimpleRootPaneContainer
extends JComponent
implements RootPaneContainer {
    protected JRootPane rootPane;
    private boolean rootPaneCheckingEnabled;

    public SimpleRootPaneContainer() {
        this.setRootPane(this.createDefaultRootPane());
        this.setLayout(new BorderLayout());
        this.add((Component)this.getRootPane(), "Center");
    }

    @Override
    public Container getContentPane() {
        return this.getRootPane().getContentPane();
    }

    @Override
    public void setContentPane(Container c) {
        Container oldValue = this.getContentPane();
        this.getRootPane().setContentPane(c);
        this.firePropertyChange("contentPane", oldValue, c);
    }

    @Override
    public JLayeredPane getLayeredPane() {
        return this.getRootPane().getLayeredPane();
    }

    @Override
    public void setLayeredPane(JLayeredPane layered) {
        JLayeredPane oldValue = this.getLayeredPane();
        this.getRootPane().setLayeredPane(layered);
        this.firePropertyChange("layeredPane", oldValue, layered);
    }

    @Override
    public Component getGlassPane() {
        return this.getRootPane().getGlassPane();
    }

    @Override
    public void setGlassPane(Component glass) {
        Component oldValue = this.getGlassPane();
        this.getRootPane().setGlassPane(glass);
        this.firePropertyChange("glassPane", oldValue, glass);
    }

    @Override
    public JRootPane getRootPane() {
        return this.rootPane;
    }

    protected JRootPane createDefaultRootPane() {
        return new JRootPane();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRootPane(JRootPane root) {
        if (this.rootPane != null) {
            this.remove(this.rootPane);
        }
        JRootPane oldValue = this.getRootPane();
        this.rootPane = root;
        if (this.rootPane != null) {
            boolean checkingEnabled = this.isRootPaneCheckingEnabled();
            try {
                this.setRootPaneCheckingEnabled(false);
                this.add((Component)this.rootPane, "Center");
            }
            finally {
                this.setRootPaneCheckingEnabled(checkingEnabled);
            }
        }
        this.firePropertyChange("rootPane", oldValue, root);
    }

    @Override
    public void remove(Component comp) {
        int oldCount = this.getComponentCount();
        super.remove(comp);
        if (oldCount == this.getComponentCount()) {
            this.getContentPane().remove(comp);
        }
    }

    @Override
    public void setLayout(LayoutManager manager) {
        if (this.isRootPaneCheckingEnabled()) {
            this.getContentPane().setLayout(manager);
        } else {
            super.setLayout(manager);
        }
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        if (this.isRootPaneCheckingEnabled()) {
            this.getContentPane().add(comp, constraints, index);
        } else {
            super.addImpl(comp, constraints, index);
        }
    }

    private boolean isRootPaneCheckingEnabled() {
        return this.rootPaneCheckingEnabled;
    }

    private void setRootPaneCheckingEnabled(boolean enabled) {
        this.rootPaneCheckingEnabled = enabled;
    }
}

