/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import org.cytoscape.internal.view.GridViewToggleModel;
import org.cytoscape.internal.view.GridViewTogglePanel;
import org.cytoscape.internal.view.util.ViewUtil;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.model.CyNetworkView;

public class NullNetworkViewPanel
extends JPanel {
    public static final String NAME = "__NULL_VIEW_PANEL__";
    private JPanel centerPanel;
    private JPanel toolBar;
    private JLabel infoLabel;
    private JLabel infoIconLabel;
    private JLabel gapLabel;
    private JButton reattachViewButton;
    private JLabel titleLabel;
    private JButton createViewButton;
    private final GridViewTogglePanel gridViewTogglePanel;
    private final JSeparator sep1 = ViewUtil.createToolBarSeparator();
    private final JSeparator sep2 = ViewUtil.createToolBarSeparator();
    private CyNetworkView networkView;
    private CyNetwork network;
    private final CyServiceRegistrar serviceRegistrar;

    public NullNetworkViewPanel(GridViewToggleModel gridViewToggleModel, CyServiceRegistrar serviceRegistrar) {
        this.gridViewTogglePanel = new GridViewTogglePanel(gridViewToggleModel, serviceRegistrar);
        this.serviceRegistrar = serviceRegistrar;
        this.init();
    }

    public CyNetwork getNetwork() {
        return this.network;
    }

    public CyNetworkView getNetworkView() {
        return this.networkView;
    }

    public void update(CyNetwork network) {
        this.network = network;
        this.networkView = null;
        this.update();
    }

    public void update(CyNetworkView networkView) {
        this.networkView = networkView;
        this.network = (CyNetwork)networkView.getModel();
        this.update();
    }

    private void update() {
        if (this.networkView != null) {
            this.getInfoIconLabel().setText("\uf14c");
            this.getInfoIconLabel().setToolTipText("This view is detached");
        } else if (this.network != null) {
            this.getInfoIconLabel().setText("\uf1e0");
            this.getInfoIconLabel().setToolTipText(this.network instanceof CySubNetwork ? "This network has no views" : "A network collection cannot have views");
        } else {
            this.getInfoIconLabel().setText(null);
            this.getInfoIconLabel().setToolTipText(null);
        }
        this.getInfoIconLabel().setVisible(this.networkView != null || this.network != null);
        this.getInfoLabel().setVisible(this.network == null && this.networkView == null);
        this.getCreateViewButton().setVisible(this.networkView == null && this.network instanceof CySubNetwork);
        this.getReattachViewButton().setVisible(this.networkView != null);
        this.sep2.setVisible(this.networkView != null);
        if (this.networkView != null) {
            this.getTitleLabel().setText(ViewUtil.getTitle(this.networkView));
        } else if (this.network != null) {
            this.getTitleLabel().setText(ViewUtil.getName(this.network));
        } else {
            this.getTitleLabel().setText(null);
        }
        Dimension d = new Dimension(1, this.network != null && this.networkView == null ? this.getCreateViewButton().getPreferredSize().height : 0);
        this.getGapLabel().setPreferredSize(d);
        this.getGapLabel().setMinimumSize(d);
        this.getGapLabel().setMaximumSize(d);
        this.getGapLabel().setSize(d);
        this.getToolBar().updateUI();
    }

    private void init() {
        this.setName(NAME);
        this.setLayout(new BorderLayout());
        this.add((Component)this.getCenterPanel(), "Center");
        this.add((Component)this.getToolBar(), "South");
        this.update();
    }

    private JPanel getCenterPanel() {
        if (this.centerPanel == null) {
            this.centerPanel = new JPanel();
            this.centerPanel.setLayout(new BorderLayout());
            GroupLayout layout = new GroupLayout(this.centerPanel);
            this.centerPanel.setLayout(layout);
            layout.setAutoCreateContainerGaps(true);
            layout.setAutoCreateGaps(true);
            layout.setHorizontalGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addComponent(this.getGapLabel(), -2, -1, -2).addComponent(this.getInfoIconLabel(), -2, -1, -2).addComponent(this.getInfoLabel(), -2, -1, -2).addComponent(this.getCreateViewButton(), -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE));
            layout.setVerticalGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.getGapLabel(), -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.getInfoIconLabel()).addComponent(this.getInfoLabel()).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.getCreateViewButton(), -2, -1, -2).addGap(0, 0, Short.MAX_VALUE));
            this.centerPanel.setMinimumSize(new Dimension(this.centerPanel.getMinimumSize().width, 0));
        }
        return this.centerPanel;
    }

    private JPanel getToolBar() {
        if (this.toolBar == null) {
            this.toolBar = new JPanel();
            this.toolBar.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getColor("Separator.foreground")));
            GroupLayout layout = new GroupLayout(this.toolBar);
            this.toolBar.setLayout(layout);
            layout.setAutoCreateContainerGaps(false);
            layout.setAutoCreateGaps(!LookAndFeelUtil.isAquaLAF());
            layout.setHorizontalGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.gridViewTogglePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sep1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getReattachViewButton(), -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sep2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getTitleLabel()).addGap(0, 0, Short.MAX_VALUE).addContainerGap());
            layout.setVerticalGroup(layout.createSequentialGroup().addGap(1).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.gridViewTogglePanel, -2, -1, -2).addComponent(this.sep1, -1, -1, Short.MAX_VALUE).addComponent(this.getReattachViewButton(), -2, -1, -2).addComponent(this.sep2, -1, -1, Short.MAX_VALUE).addComponent(this.getTitleLabel(), -2, -1, -2)).addGap(1));
            LookAndFeelUtil.equalizeSize((JComponent[])new JComponent[]{this.gridViewTogglePanel.getGridModeButton(), this.gridViewTogglePanel.getViewModeButton(), this.getReattachViewButton()});
        }
        return this.toolBar;
    }

    private JLabel getInfoLabel() {
        if (this.infoLabel == null) {
            this.infoLabel = new JLabel("No networks selected");
            this.infoLabel.setFont(this.infoLabel.getFont().deriveFont(18.0f).deriveFont(1));
            this.infoLabel.setEnabled(false);
            this.infoLabel.setForeground(UIManager.getColor("Label.disabledForeground"));
            Color c = UIManager.getColor("Label.disabledForeground");
            this.infoLabel.setForeground(c);
        }
        return this.infoLabel;
    }

    JLabel getInfoIconLabel() {
        if (this.infoIconLabel == null) {
            this.infoIconLabel = new JLabel();
            this.infoIconLabel.setFont(((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIconFont(96.0f));
            this.infoIconLabel.setHorizontalAlignment(0);
            this.infoIconLabel.setVerticalAlignment(0);
            Color c = UIManager.getColor("Label.disabledForeground");
            this.infoIconLabel.setForeground(c);
        }
        return this.infoIconLabel;
    }

    private JLabel getGapLabel() {
        if (this.gapLabel == null) {
            this.gapLabel = new JLabel(" ");
        }
        return this.gapLabel;
    }

    JButton getReattachViewButton() {
        if (this.reattachViewButton == null) {
            this.reattachViewButton = new JButton("'");
            this.reattachViewButton.setToolTipText("Reattach View");
            ViewUtil.styleToolBarButton((AbstractButton)this.reattachViewButton, ((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIconFont("cytoscape-3", 16.0f));
        }
        return this.reattachViewButton;
    }

    private JLabel getTitleLabel() {
        if (this.titleLabel == null) {
            this.titleLabel = new JLabel();
            this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(LookAndFeelUtil.getSmallFontSize()));
            this.titleLabel.setEnabled(false);
        }
        return this.titleLabel;
    }

    JButton getCreateViewButton() {
        if (this.createViewButton == null) {
            this.createViewButton = new JButton("Create View");
            if (LookAndFeelUtil.isAquaLAF()) {
                this.createViewButton.putClientProperty("JButton.buttonType", "gradient");
                this.createViewButton.putClientProperty("JComponent.sizeVariant", "small");
            }
        }
        return this.createViewButton;
    }
}

