/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.view;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.Timer;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.NetworkViewRenderer;
import org.cytoscape.application.events.CyShutdownEvent;
import org.cytoscape.application.events.CyShutdownListener;
import org.cytoscape.application.events.SetCurrentNetworkViewEvent;
import org.cytoscape.application.events.SetCurrentNetworkViewListener;
import org.cytoscape.internal.view.GridViewToggleModel;
import org.cytoscape.internal.view.NetworkMediator;
import org.cytoscape.internal.view.NetworkViewComparisonPanel;
import org.cytoscape.internal.view.NetworkViewContainer;
import org.cytoscape.internal.view.NetworkViewFrame;
import org.cytoscape.internal.view.NetworkViewGrid;
import org.cytoscape.internal.view.NetworkViewMainPanel;
import org.cytoscape.internal.view.util.ViewUtil;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyNetworkTableManager;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.events.ColumnDeletedEvent;
import org.cytoscape.model.events.ColumnDeletedListener;
import org.cytoscape.model.events.ColumnNameChangedEvent;
import org.cytoscape.model.events.ColumnNameChangedListener;
import org.cytoscape.model.events.RowSetRecord;
import org.cytoscape.model.events.RowsSetEvent;
import org.cytoscape.model.events.RowsSetListener;
import org.cytoscape.property.CyProperty;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.events.SessionAboutToBeLoadedEvent;
import org.cytoscape.session.events.SessionAboutToBeLoadedListener;
import org.cytoscape.session.events.SessionLoadedEvent;
import org.cytoscape.session.events.SessionLoadedListener;
import org.cytoscape.task.destroy.DestroyNetworkViewTaskFactory;
import org.cytoscape.task.write.ExportNetworkImageTaskFactory;
import org.cytoscape.task.write.ExportNetworkViewTaskFactory;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.model.events.NetworkViewAboutToBeDestroyedEvent;
import org.cytoscape.view.model.events.NetworkViewAboutToBeDestroyedListener;
import org.cytoscape.view.model.events.NetworkViewAddedEvent;
import org.cytoscape.view.model.events.NetworkViewAddedListener;
import org.cytoscape.view.model.events.UpdateNetworkPresentationEvent;
import org.cytoscape.view.model.events.UpdateNetworkPresentationListener;
import org.cytoscape.view.model.events.ViewChangeRecord;
import org.cytoscape.view.model.events.ViewChangedEvent;
import org.cytoscape.view.model.events.ViewChangedListener;
import org.cytoscape.view.presentation.RenderingEngine;
import org.cytoscape.view.presentation.RenderingEngineFactory;
import org.cytoscape.view.presentation.RenderingEngineManager;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.presentation.property.values.CyColumnIdentifier;
import org.cytoscape.view.presentation.property.values.CyColumnIdentifierFactory;
import org.cytoscape.view.presentation.property.values.MappableVisualPropertyValue;
import org.cytoscape.view.vizmap.VisualMappingFunction;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.events.SetCurrentVisualStyleEvent;
import org.cytoscape.view.vizmap.events.SetCurrentVisualStyleListener;
import org.cytoscape.view.vizmap.events.VisualStyleChangedEvent;
import org.cytoscape.view.vizmap.events.VisualStyleChangedListener;
import org.cytoscape.view.vizmap.events.VisualStyleSetEvent;
import org.cytoscape.view.vizmap.events.VisualStyleSetListener;
import org.cytoscape.work.swing.DialogTaskManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkViewMediator
implements NetworkViewAddedListener,
NetworkViewAboutToBeDestroyedListener,
SetCurrentNetworkViewListener,
RowsSetListener,
VisualStyleChangedListener,
SetCurrentVisualStyleListener,
UpdateNetworkPresentationListener,
VisualStyleSetListener,
SessionAboutToBeLoadedListener,
SessionLoadedListener,
ColumnDeletedListener,
ColumnNameChangedListener,
ViewChangedListener,
CyShutdownListener {
    private static final String SHOW_VIEW_TOOLBARS_KEY = "showDetachedViewToolBars";
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private final NetworkViewMainPanel networkViewMainPanel;
    private final NetworkMediator networkMediator;
    private final GridViewToggleModel gridViewToggleModel;
    private final Map<CyNetworkView, RenderingEngine<CyNetwork>> presentationMap;
    private final Set<CyNetworkView> viewUpdateRequired;
    private final Map<CyColumnIdentifier, Map<MappedVisualPropertyValueInfo, Set<View<?>>>> mappedValuesMap;
    private final Map<CyNetworkView, Timer> viewUpdateTimers;
    private volatile boolean loadingSession;
    private final CyServiceRegistrar serviceRegistrar;
    private final Object lock = new Object();

    public NetworkViewMediator(NetworkViewMainPanel networkViewMainPanel, NetworkMediator networkMediator, GridViewToggleModel gridViewToggleModel, CyServiceRegistrar serviceRegistrar) {
        this.networkViewMainPanel = networkViewMainPanel;
        this.networkMediator = networkMediator;
        this.gridViewToggleModel = gridViewToggleModel;
        this.serviceRegistrar = serviceRegistrar;
        this.presentationMap = new WeakHashMap<CyNetworkView, RenderingEngine<CyNetwork>>();
        this.viewUpdateRequired = new HashSet<CyNetworkView>();
        this.mappedValuesMap = new HashMap();
        this.viewUpdateTimers = new WeakHashMap<CyNetworkView, Timer>();
        this.initComponents();
    }

    public NetworkViewMainPanel getNetworkViewMainPanel() {
        return this.networkViewMainPanel;
    }

    public NetworkViewGrid getNetworkViewGrid() {
        return this.getNetworkViewMainPanel().getNetworkViewGrid();
    }

    public NetworkViewContainer getNetworkViewCard(CyNetworkView view) {
        return this.getNetworkViewMainPanel().getNetworkViewCard(view);
    }

    public Set<NetworkViewFrame> getAllNetworkViewFrames() {
        return this.getNetworkViewMainPanel().getAllNetworkViewFrames();
    }

    public NetworkViewFrame getNetworkViewFrame(CyNetworkView view) {
        return this.getNetworkViewMainPanel().getNetworkViewFrame(view);
    }

    public void reattachNetworkView(CyNetworkView view) {
        this.getNetworkViewMainPanel().reattachNetworkView(view);
    }

    public boolean isViewToolBarsVisible() {
        return ViewUtil.getViewProperty(SHOW_VIEW_TOOLBARS_KEY, "true", this.serviceRegistrar).equalsIgnoreCase("true");
    }

    public void setViewToolBarsVisible(boolean b) {
        for (NetworkViewFrame frame : this.getAllNetworkViewFrames()) {
            frame.setToolBarVisible(b);
        }
        Properties props = (Properties)((CyProperty)this.serviceRegistrar.getService(CyProperty.class, "(cyPropertyName=cytoscape3.props)")).getProperties();
        props.setProperty(SHOW_VIEW_TOOLBARS_KEY, "" + b);
    }

    public void handleEvent(SetCurrentNetworkViewEvent e) {
        if (this.loadingSession) {
            return;
        }
        CyNetworkView view = e.getNetworkView();
        CyApplicationManager appMgr = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class);
        RenderingEngine currentEngine = appMgr.getCurrentRenderingEngine();
        if (view != null) {
            CyNetworkViewManager netViewMgr = (CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class);
            if (netViewMgr.getNetworkViewSet().contains(view) && (currentEngine == null || currentEngine.getViewModel() != view)) {
                appMgr.setCurrentRenderingEngine(this.presentationMap.get(view));
            }
        } else if (view == null && currentEngine != null) {
            appMgr.setCurrentRenderingEngine(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(NetworkViewAboutToBeDestroyedEvent nvde) {
        CyNetworkView view = nvde.getNetworkView();
        Timer timer = null;
        Object object = this.lock;
        synchronized (object) {
            timer = this.viewUpdateTimers.remove(view);
        }
        if (timer != null) {
            timer.stop();
        }
        this.removeView(view);
    }

    public void handleEvent(NetworkViewAddedEvent nvae) {
        CyNetworkView networkView = nvae.getNetworkView();
        this.render(networkView);
    }

    public void handleEvent(VisualStyleChangedEvent e) {
        if (this.loadingSession) {
            return;
        }
        if (e.getSource() != null && !this.getNetworkViewMainPanel().isEmpty()) {
            Set<CyNetworkView> viewsSet = this.findNetworkViewsWithStyles(Collections.singleton((VisualStyle)e.getSource()));
            for (CyNetworkView view : viewsSet) {
                this.updateView(view, null);
            }
        }
    }

    public void handleEvent(SetCurrentVisualStyleEvent e) {
        CyNetworkView curView;
        if (this.loadingSession) {
            return;
        }
        VisualStyle style = e.getVisualStyle();
        if (style != null && (curView = ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetworkView()) != null) {
            VisualMappingManager vmm = (VisualMappingManager)this.serviceRegistrar.getService(VisualMappingManager.class);
            vmm.setVisualStyle(style, curView);
        }
    }

    public void handleEvent(VisualStyleSetEvent e) {
        if (this.loadingSession) {
            return;
        }
        CyNetworkView view = e.getNetworkView();
        this.updateView(view, null);
    }

    public void handleEvent(UpdateNetworkPresentationEvent e) {
        CyNetworkView netView = (CyNetworkView)e.getSource();
        ViewUtil.invokeOnEDT(() -> this.getNetworkViewMainPanel().update(netView, false, false));
    }

    public void handleEvent(ViewChangedEvent<?> e) {
        CyNetworkView netView = (CyNetworkView)e.getSource();
        boolean visiblePropChanged = false;
        for (ViewChangeRecord record : e.getPayloadCollection()) {
            Set columnIds;
            if (!record.isLockedValue()) continue;
            VisualProperty vp = record.getVisualProperty();
            if (vp == BasicVisualLexicon.NODE_VISIBLE || vp == BasicVisualLexicon.EDGE_VISIBLE) {
                visiblePropChanged = true;
            }
            View view = record.getView();
            Object value = record.getValue();
            if (!(value instanceof MappableVisualPropertyValue) || (columnIds = ((MappableVisualPropertyValue)value).getMappedColumns()) == null) continue;
            for (CyColumnIdentifier colId : columnIds) {
                MappedVisualPropertyValueInfo mvpInfo;
                Set<View<?>> viewSet;
                Map<MappedVisualPropertyValueInfo, Set<View<?>>> mvpInfoMap = this.mappedValuesMap.get(colId);
                if (mvpInfoMap == null) {
                    mvpInfoMap = new HashMap();
                    this.mappedValuesMap.put(colId, mvpInfoMap);
                }
                if ((viewSet = mvpInfoMap.get(mvpInfo = new MappedVisualPropertyValueInfo((MappableVisualPropertyValue)value, vp, netView))) == null) {
                    viewSet = new HashSet();
                    mvpInfoMap.put(mvpInfo, viewSet);
                }
                viewSet.add(view);
            }
        }
        boolean updateHiddenInfo = visiblePropChanged;
        ViewUtil.invokeOnEDT(() -> {
            if (!this.getNetworkViewMainPanel().isGridVisible()) {
                this.getNetworkViewMainPanel().update(netView, false, updateHiddenInfo);
            }
        });
    }

    public void handleEvent(SessionAboutToBeLoadedEvent e) {
        this.loadingSession = true;
    }

    public void handleEvent(SessionLoadedEvent e) {
        CyApplicationManager appMgr;
        RenderingEngine currentEngine;
        CyNetworkViewManager netViewMgr;
        this.loadingSession = false;
        CyNetworkView view = ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetworkView();
        if (view != null && (netViewMgr = (CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class)).getNetworkViewSet().contains(view) && ((currentEngine = (appMgr = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentRenderingEngine()) == null || currentEngine.getViewModel() != view)) {
            appMgr.setCurrentRenderingEngine(this.presentationMap.get(view));
        }
        ViewUtil.invokeOnEDT(() -> {
            this.getNetworkViewMainPanel().setCurrentNetworkView(view);
            if (!this.getNetworkViewMainPanel().isGridMode()) {
                if (view != null) {
                    this.getNetworkViewMainPanel().showViewContainer(view);
                } else {
                    CyNetwork net = ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetwork();
                    if (net != null) {
                        this.getNetworkViewMainPanel().showNullViewContainer(net);
                    }
                }
            } else {
                this.getNetworkViewGrid().update(this.getNetworkViewGrid().getThumbnailSlider().getValue());
            }
        });
    }

    public void handleEvent(ColumnDeletedEvent e) {
        this.onColumnChanged((CyTable)e.getSource(), e.getColumnName());
    }

    public void handleEvent(ColumnNameChangedEvent e) {
        this.onColumnChanged((CyTable)e.getSource(), e.getOldColumnName());
        this.onColumnChanged((CyTable)e.getSource(), e.getNewColumnName());
    }

    public void handleEvent(RowsSetEvent e) {
        if (this.loadingSession || this.getNetworkViewMainPanel().isEmpty()) {
            return;
        }
        CyTable tbl = (CyTable)e.getSource();
        CyNetworkTableManager netTblMgr = (CyNetworkTableManager)this.serviceRegistrar.getService(CyNetworkTableManager.class);
        CyNetwork net = netTblMgr.getNetworkForTable(tbl);
        CyNetworkViewManager netViewMgr = (CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class);
        if (net != null && netViewMgr.viewExists(net)) {
            Collection nameRecords = e.getColumnRecords("name");
            if (!nameRecords.isEmpty()) {
                this.updateNetworkViewTitle(nameRecords, tbl);
            }
            if (tbl.equals(net.getDefaultNodeTable()) || tbl.equals(net.getDefaultEdgeTable())) {
                Collection networkViews = netViewMgr.getNetworkViews(net);
                Collection selectedRecords = e.getColumnRecords("selected");
                if (!selectedRecords.isEmpty()) {
                    for (CyNetworkView view : networkViews) {
                        this.getNetworkViewMainPanel().updateSelectionInfo(view);
                    }
                }
                HashSet<CyNetworkView> viewsToUpdate = new HashSet<CyNetworkView>();
                for (String columnName : e.getColumns()) {
                    boolean lockedValuesApplyed = this.reapplyLockedValues(columnName, networkViews);
                    if (lockedValuesApplyed) {
                        viewsToUpdate.addAll(networkViews);
                    }
                    Set<VisualStyle> styles = this.findStylesWithMappedColumn(columnName);
                    viewsToUpdate.addAll(this.findNetworkViewsWithStyles(styles));
                }
                for (CyNetworkView view : viewsToUpdate) {
                    this.updateView(view, null);
                }
            }
        }
    }

    public void handleEvent(CyShutdownEvent e) {
        ViewUtil.invokeOnEDT(() -> this.getNetworkViewMainPanel().dispose());
    }

    private void initComponents() {
        NetworkViewMainPanel viewMainPanel = this.getNetworkViewMainPanel();
        NetworkViewGrid vg = viewMainPanel.getNetworkViewGrid();
        this.gridViewToggleModel.addPropertyChangeListener("mode", evt -> {
            GridViewToggleModel.Mode mode = (GridViewToggleModel.Mode)((Object)((Object)evt.getNewValue()));
            if (mode == GridViewToggleModel.Mode.GRID) {
                Component currentCard = viewMainPanel.getCurrentCard();
                if (currentCard instanceof NetworkViewComparisonPanel) {
                    viewMainPanel.endComparison((NetworkViewComparisonPanel)currentCard);
                }
                viewMainPanel.showGrid(true);
                vg.requestFocusInWindow();
            } else if (mode == GridViewToggleModel.Mode.VIEW) {
                LinkedHashSet<CyNetworkView> selectedViews = new LinkedHashSet<CyNetworkView>(viewMainPanel.getSelectedNetworkViews());
                if (selectedViews.size() > 1) {
                    viewMainPanel.showComparisonPanel(selectedViews);
                } else {
                    CyNetworkView currentView = vg.getCurrentNetworkView();
                    NetworkViewContainer viewContainer = null;
                    if (currentView != null) {
                        viewContainer = viewMainPanel.showViewContainer(currentView);
                        if (viewContainer != null) {
                            viewMainPanel.setCurrentNetworkView(viewContainer.getNetworkView());
                            viewContainer.getContentPane().requestFocusInWindow();
                        }
                    } else {
                        CyNetwork currentNet = this.networkMediator.getCurrentNetwork();
                        viewMainPanel.showNullViewContainer(currentNet);
                    }
                }
            }
        });
        vg.addPropertyChangeListener("currentNetworkView", evt -> {
            CyNetworkView targetView = (CyNetworkView)evt.getNewValue();
            CyNetworkViewManager netViewMgr = (CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class);
            if (targetView != null && netViewMgr.getNetworkViewSet().contains(targetView) && this.viewUpdateRequired.contains(targetView)) {
                this.viewUpdateRequired.remove(targetView);
                VisualMappingManager vmm = (VisualMappingManager)this.serviceRegistrar.getService(VisualMappingManager.class);
                VisualStyle style = vmm.getVisualStyle(targetView);
                style.apply(targetView);
                targetView.updateView();
            }
        });
        vg.addPropertyChangeListener("thumbnailPanels", evt -> {
            Collection thumbnails = (Collection)evt.getNewValue();
            for (NetworkViewGrid.ThumbnailPanel tp : thumbnails) {
                this.addMouseListeners(tp, tp, tp.getTitleLabel(), tp.getCurrentLabel(), tp.getImagePanel().getGlassPane());
            }
        });
    }

    private final void removeView(CyNetworkView view) {
        ViewUtil.invokeOnEDT(() -> {
            try {
                this.getNetworkViewMainPanel().remove(view);
                if (!this.getNetworkViewMainPanel().isGridMode()) {
                    CyNetwork curNet = this.networkMediator.getCurrentNetwork();
                    if (curNet != null) {
                        if (!this.getNetworkViewMainPanel().hasViews(curNet)) {
                            this.getNetworkViewMainPanel().showNullViewContainer(curNet);
                        }
                    } else {
                        this.getNetworkViewMainPanel().showNullViewContainer((CyNetwork)null);
                    }
                }
                this.viewUpdateRequired.remove(view);
                RenderingEngine<CyNetwork> removed = this.presentationMap.remove(view);
                if (removed != null) {
                    new Thread(() -> ((RenderingEngineManager)this.serviceRegistrar.getService(RenderingEngineManager.class)).removeRenderingEngine(removed)).start();
                }
            }
            catch (Exception e) {
                logger.error("Unable to destroy Network View", (Throwable)e);
            }
        });
    }

    private final void render(CyNetworkView view) {
        ViewUtil.invokeOnEDT(() -> {
            if (this.getNetworkViewMainPanel().isRendered(view)) {
                return;
            }
            NetworkViewRenderer renderer = null;
            String rendererId = view.getRendererId();
            CyApplicationManager appMgr = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class);
            if (rendererId != null) {
                renderer = appMgr.getNetworkViewRenderer(rendererId);
            }
            if (renderer == null) {
                renderer = appMgr.getDefaultNetworkViewRenderer();
            }
            RenderingEngineFactory engineFactory = renderer.getRenderingEngineFactory("");
            RenderingEngineFactory thumbnailFactory = renderer.getRenderingEngineFactory("thumbnail");
            RenderingEngine<CyNetwork> renderingEngine = this.getNetworkViewMainPanel().addNetworkView(view, (RenderingEngineFactory<CyNetwork>)engineFactory, (RenderingEngineFactory<CyNetwork>)thumbnailFactory);
            this.presentationMap.put(view, renderingEngine);
            boolean isCurrentView = view.equals(appMgr.getCurrentNetworkView());
            new Thread(() -> {
                ((RenderingEngineManager)this.serviceRegistrar.getService(RenderingEngineManager.class)).addRenderingEngine(renderingEngine);
                if (isCurrentView) {
                    appMgr.setCurrentRenderingEngine(renderingEngine);
                }
            }).start();
        });
    }

    private void onColumnChanged(CyTable tbl, String columnName) {
        if (this.loadingSession || this.getNetworkViewMainPanel().isEmpty()) {
            return;
        }
        CyNetworkTableManager netTblMgr = (CyNetworkTableManager)this.serviceRegistrar.getService(CyNetworkTableManager.class);
        CyNetwork net = netTblMgr.getNetworkForTable(tbl);
        CyNetworkViewManager netViewMgr = (CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class);
        if (net != null && netViewMgr.viewExists(net) && (tbl.equals(net.getDefaultNodeTable()) || tbl.equals(net.getDefaultEdgeTable()))) {
            Collection networkViews = netViewMgr.getNetworkViews(net);
            boolean lockedValuesApplyed = this.reapplyLockedValues(columnName, networkViews);
            Set<VisualStyle> styles = this.findStylesWithMappedColumn(columnName);
            Set<CyNetworkView> viewsToUpdate = this.findNetworkViewsWithStyles(styles);
            if (lockedValuesApplyed) {
                viewsToUpdate.addAll(networkViews);
            }
            for (CyNetworkView view : viewsToUpdate) {
                this.updateView(view, null);
            }
        }
    }

    private final void updateNetworkViewTitle(Collection<RowSetRecord> records, CyTable source) {
        CyNetworkManager netMgr = (CyNetworkManager)this.serviceRegistrar.getService(CyNetworkManager.class);
        CyNetworkViewManager netViewMgr = (CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class);
        block0: for (RowSetRecord record : records) {
            if (!"name".equals(record.getColumn())) continue;
            for (CyNetwork net : netMgr.getNetworkSet()) {
                String name;
                if (net.getDefaultNetworkTable() != source || (name = (String)record.getRow().get("name", String.class)) == null || name.trim().isEmpty()) continue;
                Collection netViews = netViewMgr.getNetworkViews(net);
                int count = 0;
                for (CyNetworkView view : netViews) {
                    Object title = name.trim();
                    title = (String)title + (String)(netViews.size() > 1 ? " (" + ++count + ")" : "");
                    view.setVisualProperty(BasicVisualLexicon.NETWORK_TITLE, title);
                    if (view.isValueLocked(BasicVisualLexicon.NETWORK_TITLE)) continue;
                    ViewUtil.invokeOnEDT(() -> this.getNetworkViewMainPanel().update(view, false, false));
                }
                continue block0;
            }
        }
    }

    public void setUpdateFlag(CyNetworkView view) {
        this.viewUpdateRequired.add(view);
    }

    private Set<VisualStyle> findStylesWithMappedColumn(String columnName) {
        HashSet<VisualStyle> styles = new HashSet<VisualStyle>();
        if (columnName != null) {
            CyApplicationManager appMgr = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class);
            RenderingEngineManager engineMgr = (RenderingEngineManager)this.serviceRegistrar.getService(RenderingEngineManager.class);
            RenderingEngine renderer = appMgr.getCurrentRenderingEngine();
            VisualLexicon lexicon = renderer != null ? renderer.getVisualLexicon() : engineMgr.getDefaultVisualLexicon();
            Set properties = lexicon.getAllVisualProperties();
            VisualMappingManager vmm = (VisualMappingManager)this.serviceRegistrar.getService(VisualMappingManager.class);
            block0: for (VisualStyle vs : vmm.getAllVisualStyles()) {
                for (VisualProperty vp : properties) {
                    VisualMappingFunction fn = vs.getVisualMappingFunction(vp);
                    if (fn != null && fn.getMappingColumnName().equalsIgnoreCase(columnName)) {
                        styles.add(vs);
                        continue block0;
                    }
                    Object defValue = vs.getDefaultValue(vp);
                    if (!(defValue instanceof MappableVisualPropertyValue)) continue;
                    ((MappableVisualPropertyValue)defValue).update();
                    styles.add(vs);
                    continue block0;
                }
            }
        }
        return styles;
    }

    private Set<CyNetworkView> findNetworkViewsWithStyles(Set<VisualStyle> styles) {
        HashSet<CyNetworkView> result = new HashSet<CyNetworkView>();
        if (styles == null || styles.isEmpty()) {
            return result;
        }
        CyNetworkViewManager netViewMgr = (CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class);
        Set networkViews = netViewMgr.getNetworkViewSet();
        VisualMappingManager vmm = (VisualMappingManager)this.serviceRegistrar.getService(VisualMappingManager.class);
        for (CyNetworkView view : networkViews) {
            if (!styles.contains(vmm.getVisualStyle(view))) continue;
            result.add(view);
        }
        return result;
    }

    private boolean reapplyLockedValues(String columnName, Collection<CyNetworkView> networkViews) {
        boolean result = false;
        CyColumnIdentifierFactory colIdfFactory = (CyColumnIdentifierFactory)this.serviceRegistrar.getService(CyColumnIdentifierFactory.class);
        CyColumnIdentifier colId = colIdfFactory.createColumnIdentifier(columnName);
        Map<MappedVisualPropertyValueInfo, Set<View<?>>> mvpInfoMap = this.mappedValuesMap.get(colId);
        if (mvpInfoMap != null) {
            for (MappedVisualPropertyValueInfo mvpInfo : mvpInfoMap.keySet()) {
                if (networkViews == null || !networkViews.contains(mvpInfo.getNetworkView())) continue;
                MappableVisualPropertyValue value = mvpInfo.getValue();
                VisualProperty<?> vp = mvpInfo.getVisualProperty();
                Set<View<?>> viewSet = mvpInfoMap.get(mvpInfo);
                for (View<?> view : viewSet) {
                    if (!view.isDirectlyLocked(vp) || !value.equals(view.getVisualProperty(vp))) continue;
                    value.update();
                    view.setLockedValue(vp, (Object)value);
                    result = true;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateView(CyNetworkView view, VisualStyle style) {
        if (view == null) {
            return;
        }
        if (this.getNetworkViewMainPanel().isGridVisible() || view.equals(this.getNetworkViewMainPanel().getCurrentNetworkView())) {
            Timer timer = null;
            Object object = this.lock;
            synchronized (object) {
                timer = this.viewUpdateTimers.get(view);
            }
            if (timer == null) {
                timer = new Timer(0, evt -> {
                    VisualStyle vs = style != null ? style : ((VisualMappingManager)this.serviceRegistrar.getService(VisualMappingManager.class)).getVisualStyle(view);
                    vs.apply(view);
                    view.updateView();
                });
                timer.setRepeats(false);
                timer.setCoalesce(true);
                object = this.lock;
                synchronized (object) {
                    this.viewUpdateTimers.put(view, timer);
                }
            } else {
                timer.stop();
            }
            timer.setInitialDelay(120);
            timer.start();
        } else {
            this.viewUpdateRequired.add(view);
        }
    }

    private void addMouseListeners(final NetworkViewGrid.ThumbnailPanel tp, Component ... components) {
        MouseAdapter selectionListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                NetworkViewMediator.this.getNetworkViewGrid().onMousePressedItem(e, tp);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && !e.isPopupTrigger()) {
                    NetworkViewFrame frame = NetworkViewMediator.this.getNetworkViewFrame(tp.getNetworkView());
                    if (frame != null) {
                        NetworkViewMediator.this.getNetworkViewMainPanel().showViewFrame(frame);
                    } else {
                        NetworkViewMediator.this.gridViewToggleModel.setMode(GridViewToggleModel.Mode.VIEW);
                    }
                }
            }
        };
        PopupListener popupListener = new PopupListener(tp);
        for (Component c : components) {
            c.addMouseListener(selectionListener);
            c.addMouseListener(popupListener);
        }
    }

    private static class MappedVisualPropertyValueInfo {
        private final MappableVisualPropertyValue value;
        private final VisualProperty<?> visualProperty;
        private final CyNetworkView networkView;

        MappedVisualPropertyValueInfo(MappableVisualPropertyValue value, VisualProperty<?> visualProperty, CyNetworkView networkView) {
            this.value = value;
            this.visualProperty = visualProperty;
            this.networkView = networkView;
        }

        MappableVisualPropertyValue getValue() {
            return this.value;
        }

        VisualProperty<?> getVisualProperty() {
            return this.visualProperty;
        }

        CyNetworkView getNetworkView() {
            return this.networkView;
        }

        public int hashCode() {
            int prime = 29;
            int result = 3;
            result = 29 * result + (this.networkView == null ? 0 : this.networkView.hashCode());
            result = 29 * result + (this.value == null ? 0 : this.value.hashCode());
            result = 29 * result + (this.visualProperty == null ? 0 : this.visualProperty.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MappedVisualPropertyValueInfo other = (MappedVisualPropertyValueInfo)obj;
            if (this.networkView == null ? other.networkView != null : !this.networkView.equals(other.networkView)) {
                return false;
            }
            if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
                return false;
            }
            return !(this.visualProperty == null ? other.visualProperty != null : !this.visualProperty.equals(other.visualProperty));
        }

        public String toString() {
            return "{vp:" + this.visualProperty + ", value:" + this.value + ", networkView:" + this.networkView + "}";
        }
    }

    private final class PopupListener
    extends MouseAdapter {
        final NetworkViewGrid.ThumbnailPanel item;

        PopupListener(NetworkViewGrid.ThumbnailPanel item) {
            this.item = item;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopupMenu(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopupMenu(e);
        }

        private final void maybeShowPopupMenu(MouseEvent e) {
            if (!e.isPopupTrigger()) {
                return;
            }
            if (!NetworkViewMediator.this.getNetworkViewMainPanel().getSelectedNetworkViews().contains(this.item.getNetworkView())) {
                NetworkViewMediator.this.getNetworkViewMainPanel().setCurrentNetworkView(this.item.getNetworkView());
                NetworkViewMediator.this.getNetworkViewMainPanel().setSelectedNetworkViews(Collections.singleton(this.item.getNetworkView()));
            }
            List<CyNetworkView> selectedViews = NetworkViewMediator.this.getNetworkViewMainPanel().getSelectedNetworkViews();
            DialogTaskManager taskMgr = (DialogTaskManager)NetworkViewMediator.this.serviceRegistrar.getService(DialogTaskManager.class);
            JPopupMenu popupMenu = new JPopupMenu();
            JMenuItem mi = new JMenuItem("Show View" + (selectedViews.size() == 1 ? "" : "s"));
            mi.addActionListener(evt -> {
                if (selectedViews.size() == 1) {
                    NetworkViewMediator.this.getNetworkViewMainPanel().showViewContainer((CyNetworkView)selectedViews.iterator().next());
                } else if (selectedViews.size() > 1) {
                    NetworkViewMediator.this.getNetworkViewMainPanel().showComparisonPanel(new HashSet<CyNetworkView>(selectedViews));
                }
            });
            popupMenu.add(mi);
            mi.setEnabled(!selectedViews.isEmpty());
            mi = new JMenuItem("Detach View" + (selectedViews.size() == 1 ? "" : "s"));
            mi.addActionListener(evt -> NetworkViewMediator.this.getNetworkViewMainPanel().detachNetworkViews(selectedViews));
            popupMenu.add(mi);
            boolean hasAttached = false;
            for (CyNetworkView view : selectedViews) {
                if (NetworkViewMediator.this.getNetworkViewMainPanel().getNetworkViewFrame(view) != null) continue;
                hasAttached = true;
                break;
            }
            mi.setEnabled(hasAttached);
            popupMenu.addSeparator();
            mi = new JMenuItem("Destroy View" + (selectedViews.size() == 1 ? "" : "s"));
            mi.addActionListener(evt -> {
                DestroyNetworkViewTaskFactory factory = (DestroyNetworkViewTaskFactory)NetworkViewMediator.this.serviceRegistrar.getService(DestroyNetworkViewTaskFactory.class);
                taskMgr.execute(factory.createTaskIterator((Collection)selectedViews));
            });
            popupMenu.add(mi);
            mi.setEnabled(!selectedViews.isEmpty());
            popupMenu.addSeparator();
            mi = new JMenuItem("Export as Network...");
            mi.addActionListener(evt -> {
                ExportNetworkViewTaskFactory factory = (ExportNetworkViewTaskFactory)NetworkViewMediator.this.serviceRegistrar.getService(ExportNetworkViewTaskFactory.class);
                taskMgr.execute(factory.createTaskIterator((CyNetworkView)selectedViews.get(0)));
            });
            popupMenu.add(mi);
            mi.setEnabled(selectedViews.size() == 1);
            mi = new JMenuItem("Export as Image...");
            mi.addActionListener(evt -> {
                ExportNetworkImageTaskFactory factory = (ExportNetworkImageTaskFactory)NetworkViewMediator.this.serviceRegistrar.getService(ExportNetworkImageTaskFactory.class);
                taskMgr.execute(factory.createTaskIterator((CyNetworkView)selectedViews.get(0)));
            });
            popupMenu.add(mi);
            mi.setEnabled(selectedViews.size() == 1);
            popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }
}

