/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import org.cytoscape.internal.util.Util;
import org.cytoscape.internal.view.GridViewToggleModel;
import org.cytoscape.internal.view.GridViewTogglePanel;
import org.cytoscape.internal.view.NetworkViewContainer;
import org.cytoscape.internal.view.util.ViewUtil;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.model.CyNetworkView;

public class NetworkViewComparisonPanel
extends JPanel {
    public static final int HORIZONTAL = 1;
    public static final int VERTICAL = 0;
    private static final float ICON_FONT_SIZE = 22.0f;
    private JPanel gridPanel;
    private JPanel comparisonToolBar;
    private JButton detachComparedViewsButton;
    private JButton optionsBtn;
    private final GridViewTogglePanel gridViewTogglePanel;
    private final Map<CyNetworkView, ViewPanel> viewPanels = new LinkedHashMap<CyNetworkView, ViewPanel>();
    private final Map<CyNetworkView, JRootPane> rootPanes = new LinkedHashMap<CyNetworkView, JRootPane>();
    private CyNetworkView currentNetworkView;
    private Arrangement arrangement = Arrangement.AUTO;
    private final CyServiceRegistrar serviceRegistrar;

    public NetworkViewComparisonPanel(GridViewToggleModel gridViewToggleModel, Set<NetworkViewContainer> containers, CyNetworkView currentNetworkView, CyServiceRegistrar serviceRegistrar) {
        if (containers == null || containers.isEmpty()) {
            throw new IllegalArgumentException("'containers' must not be null or empty.");
        }
        this.currentNetworkView = currentNetworkView;
        this.serviceRegistrar = serviceRegistrar;
        this.gridViewTogglePanel = new GridViewTogglePanel(gridViewToggleModel, serviceRegistrar);
        for (NetworkViewContainer vc : containers) {
            this.viewPanels.put(vc.getNetworkView(), new ViewPanel(vc));
            this.rootPanes.put(vc.getNetworkView(), vc.getRootPane());
        }
        this.init();
    }

    public CyNetworkView getCurrentNetworkView() {
        return this.currentNetworkView;
    }

    public void setCurrentNetworkView(CyNetworkView newValue) {
        if (newValue != this.currentNetworkView) {
            CyNetworkView oldValue = this.currentNetworkView;
            this.currentNetworkView = newValue;
            this.update();
            this.firePropertyChange("currentNetworkView", oldValue, newValue);
        }
    }

    public Set<CyNetworkView> getAllNetworkViews() {
        LinkedHashSet<CyNetworkView> set = new LinkedHashSet<CyNetworkView>();
        for (ViewPanel vp : this.viewPanels.values()) {
            set.add(vp.getNetworkView());
        }
        return set;
    }

    public Set<NetworkViewContainer> getAllContainers() {
        LinkedHashSet<NetworkViewContainer> set = new LinkedHashSet<NetworkViewContainer>();
        for (ViewPanel vp : this.viewPanels.values()) {
            set.add(vp.getNetworkViewContainer());
        }
        return set;
    }

    public NetworkViewContainer getCurrentContainer() {
        for (ViewPanel vp : this.viewPanels.values()) {
            if (!vp.getNetworkView().equals(this.currentNetworkView)) continue;
            return vp.getNetworkViewContainer();
        }
        return null;
    }

    public NetworkViewContainer getContainer(CyNetworkView view) {
        ViewPanel vp = this.viewPanels.get(view);
        return vp != null ? vp.getNetworkViewContainer() : null;
    }

    public boolean contains(CyNetworkView view) {
        for (ViewPanel vp : this.viewPanels.values()) {
            if (!vp.getNetworkView().equals(view)) continue;
            return true;
        }
        return false;
    }

    public void removeView(CyNetworkView view) {
        if (view != null && this.viewPanels.containsKey(view)) {
            this.viewPanels.remove(view);
            this.rootPanes.remove(view);
            this.arrangePanels();
        }
    }

    public int viewCount() {
        return this.viewPanels.size();
    }

    public Arrangement getArrangement() {
        return this.arrangement;
    }

    public void setArrangement(Arrangement arrangement) {
        if (this.arrangement != arrangement) {
            this.arrangement = arrangement;
            this.arrangePanels();
        }
    }

    public void update() {
        for (ViewPanel vp : this.viewPanels.values()) {
            vp.update();
        }
    }

    public void dispose() {
        for (ViewPanel vp : this.viewPanels.values()) {
            vp.getNetworkViewContainer().setRootPane(this.rootPanes.get(vp.getNetworkView()));
            vp.getNetworkViewContainer().setComparing(false);
        }
    }

    private void init() {
        LinkedHashSet<CyNetworkView> views = new LinkedHashSet<CyNetworkView>();
        for (ViewPanel vp : this.viewPanels.values()) {
            vp.getNetworkViewContainer().setComparing(true);
            views.add(vp.getNetworkView());
        }
        this.setName(NetworkViewComparisonPanel.createUniqueKey(views));
        this.setLayout(new BorderLayout());
        this.add((Component)this.getGridPanel(), "Center");
        this.add((Component)this.getComparisonToolBar(), "South");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                NetworkViewComparisonPanel.this.requestFocusInWindow();
                for (ViewPanel vp : NetworkViewComparisonPanel.this.viewPanels.values()) {
                    if (!vp.isCurrent()) continue;
                    vp.getNetworkViewContainer().getContentPane().requestFocusInWindow();
                    break;
                }
                NetworkViewComparisonPanel.this.arrangePanels();
                NetworkViewComparisonPanel.this.update();
            }

            @Override
            public void componentResized(ComponentEvent e) {
                NetworkViewComparisonPanel.this.arrangePanels();
            }
        });
        this.setKeyBindings(this);
        this.arrangePanels();
        this.update();
    }

    private JPanel getGridPanel() {
        if (this.gridPanel == null) {
            this.gridPanel = new JPanel();
        }
        return this.gridPanel;
    }

    private JPanel getComparisonToolBar() {
        if (this.comparisonToolBar == null) {
            this.comparisonToolBar = new JPanel();
            this.comparisonToolBar.setName("comparisonToolBar");
            this.comparisonToolBar.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getColor("Separator.foreground")));
            JSeparator sep1 = ViewUtil.createToolBarSeparator();
            JSeparator sep2 = ViewUtil.createToolBarSeparator();
            JSeparator sep3 = ViewUtil.createToolBarSeparator();
            GroupLayout layout = new GroupLayout(this.comparisonToolBar);
            this.comparisonToolBar.setLayout(layout);
            layout.setAutoCreateContainerGaps(false);
            layout.setAutoCreateGaps(false);
            layout.setHorizontalGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.gridViewTogglePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(sep1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getDetachComparedViewsButton(), -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(sep2, -2, -1, -2).addGap(0, 10, Short.MAX_VALUE).addComponent(sep3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getOptionsButton(), -2, -1, -2).addContainerGap());
            layout.setVerticalGroup(layout.createSequentialGroup().addGap(1).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.gridViewTogglePanel, -2, -1, -2).addComponent(sep1, -1, -1, Short.MAX_VALUE).addComponent(this.getDetachComparedViewsButton(), -2, -1, -2).addComponent(sep2, -1, -1, Short.MAX_VALUE).addComponent(sep3, -1, -1, Short.MAX_VALUE).addComponent(this.getOptionsButton(), -2, -1, -2)).addGap(1));
            LookAndFeelUtil.equalizeSize((JComponent[])new JComponent[]{this.gridViewTogglePanel.getGridModeButton(), this.gridViewTogglePanel.getViewModeButton(), this.getDetachComparedViewsButton(), this.getOptionsButton()});
        }
        return this.comparisonToolBar;
    }

    JButton getDetachComparedViewsButton() {
        if (this.detachComparedViewsButton == null) {
            this.detachComparedViewsButton = new JButton("\uf14c");
            this.detachComparedViewsButton.setToolTipText("Detach All Views");
            ViewUtil.styleToolBarButton((AbstractButton)this.detachComparedViewsButton, ((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIconFont(22.0f));
        }
        return this.detachComparedViewsButton;
    }

    private JButton getOptionsButton() {
        if (this.optionsBtn == null) {
            this.optionsBtn = new JButton("\uf013");
            this.optionsBtn.setToolTipText("Options...");
            ViewUtil.styleToolBarButton((AbstractButton)this.optionsBtn, ((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIconFont(17.6f));
            this.optionsBtn.addActionListener(evt -> this.getOptionsMenu().show(this.optionsBtn, 0, this.optionsBtn.getHeight()));
        }
        return this.optionsBtn;
    }

    private JPopupMenu getOptionsMenu() {
        JPopupMenu menu = new JPopupMenu();
        for (Arrangement arrangement : Arrangement.values()) {
            JCheckBoxMenuItem mi = new JCheckBoxMenuItem(arrangement.toString());
            mi.addActionListener(evt -> this.setArrangement(arrangement));
            mi.setSelected(this.arrangement == arrangement);
            menu.add(mi);
        }
        return menu;
    }

    public int hashCode() {
        int prime = 31;
        int result = 7;
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NetworkViewComparisonPanel other = (NetworkViewComparisonPanel)obj;
        String name = this.getName();
        return !(name == null ? other.getName() != null : !name.equals(other.getName()));
    }

    public static String createUniqueKey(Collection<CyNetworkView> views) {
        ArrayList<CyNetworkView> list = new ArrayList<CyNetworkView>(views);
        Collections.sort(list, (o1, o2) -> o1.getSUID().compareTo(o2.getSUID()));
        return "NetworkViewComparisonPanel_" + list.hashCode();
    }

    private void arrangePanels() {
        this.getGridPanel().removeAll();
        Dimension size = this.getGridPanel().getSize();
        if (size == null || size.width <= 0 || size.height <= 0) {
            return;
        }
        if (!this.viewPanels.isEmpty()) {
            int n = this.viewPanels.size();
            int rows = 1;
            int cols = n;
            switch (this.arrangement) {
                case AUTO: {
                    double w = size.getWidth() / (double)cols;
                    double h = size.getHeight() / (double)rows;
                    int BAR_HEIGHT = 25;
                    double ratio = Util.squarenessRatio(w, h - 25.0);
                    for (int i = 1; i < n; ++i) {
                        int c = n - i;
                        int r = (int)Math.ceil((double)n / (double)c);
                        w = size.getWidth() / (double)c;
                        double newRatio = Util.squarenessRatio(w, (h = size.getHeight() / (double)r) - 25.0);
                        if (!(newRatio < ratio)) continue;
                        ratio = newRatio;
                        rows = r;
                        cols = c;
                    }
                    break;
                }
                case GRID: {
                    int sqrt;
                    if (this.viewPanels.size() == 2) {
                        boolean portrait = size.width >= size.height;
                        rows = portrait ? 1 : 2;
                        cols = portrait ? 2 : 1;
                        break;
                    }
                    cols = sqrt = (int)Math.ceil(Math.sqrt(this.viewPanels.size()));
                    rows = sqrt;
                    break;
                }
                case VERTICAL: {
                    rows = n;
                    cols = 1;
                    break;
                }
            }
            this.getGridPanel().setLayout(new GridLayout(rows, cols));
            for (ViewPanel vp : this.viewPanels.values()) {
                this.getGridPanel().add(vp);
            }
        }
        this.getGridPanel().updateUI();
    }

    private void setKeyBindings(JComponent comp) {
        ActionMap actionMap = comp.getActionMap();
        InputMap inputMap = comp.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(78, 0), "VK_N");
        actionMap.put("VK_N", new KeyAction("VK_N"));
    }

    protected class ViewPanel
    extends JPanel {
        private final NetworkViewContainer networkViewContainer;

        ViewPanel(NetworkViewContainer networkViewContainer) {
            this.networkViewContainer = networkViewContainer;
            this.setLayout(new BorderLayout());
            this.add((Component)this.getNetworkViewContainer().getRootPane(), "Center");
            this.updateBorder();
            networkViewContainer.getContentPane().addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    NetworkViewComparisonPanel.this.setCurrentNetworkView(ViewPanel.this.getNetworkView());
                }
            });
        }

        boolean isCurrent() {
            return this.networkViewContainer.isCurrent();
        }

        NetworkViewContainer getNetworkViewContainer() {
            return this.networkViewContainer;
        }

        CyNetworkView getNetworkView() {
            return this.getNetworkViewContainer().getNetworkView();
        }

        void update() {
            this.updateBorder();
            this.getNetworkViewContainer().update(true, true);
        }

        private void updateBorder() {
            this.setBorder(BorderFactory.createLineBorder(UIManager.getColor(this.isCurrent() ? "Focus.color" : "Separator.foreground")));
        }
    }

    private class KeyAction
    extends AbstractAction {
        static final String VK_N = "VK_N";

        KeyAction(String actionCommand) {
            this.putValue("ActionCommandKey", actionCommand);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NetworkViewContainer vc;
            Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (focusOwner instanceof JTextComponent || focusOwner instanceof JTable || !NetworkViewComparisonPanel.this.isVisible()) {
                return;
            }
            String cmd = e.getActionCommand();
            if (cmd.equals(VK_N) && (vc = NetworkViewComparisonPanel.this.getCurrentContainer()) != null) {
                vc.getBirdsEyeViewButton().doClick();
            }
        }
    }

    public static enum Arrangement {
        AUTO("Auto Arrange"),
        GRID("Grid"),
        HORIZONTAL("Side by Side"),
        VERTICAL("Vertical Stack");

        private final String name;

        private Arrangement(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

