/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.view;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.events.SetCurrentNetworkEvent;
import org.cytoscape.application.events.SetCurrentNetworkListener;
import org.cytoscape.application.events.SetCurrentNetworkViewEvent;
import org.cytoscape.application.events.SetCurrentNetworkViewListener;
import org.cytoscape.application.events.SetSelectedNetworkViewsEvent;
import org.cytoscape.application.events.SetSelectedNetworkViewsListener;
import org.cytoscape.application.events.SetSelectedNetworksEvent;
import org.cytoscape.application.events.SetSelectedNetworksListener;
import org.cytoscape.internal.model.RootNetworkManager;
import org.cytoscape.internal.util.Util;
import org.cytoscape.internal.view.NetworkMainPanel;
import org.cytoscape.internal.view.NetworkViewMainPanel;
import org.cytoscape.internal.view.util.ViewUtil;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.events.SessionAboutToBeLoadedEvent;
import org.cytoscape.session.events.SessionAboutToBeLoadedListener;
import org.cytoscape.session.events.SessionLoadedEvent;
import org.cytoscape.session.events.SessionLoadedListener;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;

public class NetworkSelectionMediator
implements SetSelectedNetworksListener,
SetSelectedNetworkViewsListener,
SetCurrentNetworkListener,
SetCurrentNetworkViewListener,
SessionAboutToBeLoadedListener,
SessionLoadedListener {
    private boolean loadingSession;
    private final NetPanelPropertyChangeListener netPanelPropChangeListener;
    private final ViewPanelPropertyChangeListener viewPanelPropChangeListener;
    private final GridPanelPropertyChangeListener gridPanelPropChangeListener;
    private final NetworkMainPanel netMainPanel;
    private final NetworkViewMainPanel viewMainPanel;
    private final RootNetworkManager rootNetManager;
    private final CyServiceRegistrar serviceRegistrar;
    private final Object lock = new Object();

    public NetworkSelectionMediator(NetworkMainPanel netMainPanel, NetworkViewMainPanel viewMainPanel, RootNetworkManager rootNetManager, CyServiceRegistrar serviceRegistrar) {
        this.netMainPanel = netMainPanel;
        this.viewMainPanel = viewMainPanel;
        this.rootNetManager = rootNetManager;
        this.serviceRegistrar = serviceRegistrar;
        this.netPanelPropChangeListener = new NetPanelPropertyChangeListener();
        this.viewPanelPropChangeListener = new ViewPanelPropertyChangeListener();
        this.gridPanelPropChangeListener = new GridPanelPropertyChangeListener();
        this.addPropertyChangeListeners();
    }

    public void handleEvent(SessionAboutToBeLoadedEvent e) {
        this.loadingSession = true;
    }

    public void handleEvent(SessionLoadedEvent e) {
        this.loadingSession = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(SetCurrentNetworkEvent e) {
        CyNetwork network = e.getNetwork();
        Object object = this.lock;
        synchronized (object) {
            if (Util.same(network, this.netMainPanel.getCurrentNetwork())) {
                return;
            }
        }
        ViewUtil.invokeOnEDT(() -> {
            if (Util.same(network, ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetwork())) {
                this.syncFrom(network);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(SetCurrentNetworkViewEvent e) {
        if (this.loadingSession) {
            return;
        }
        CyNetworkView view = e.getNetworkView();
        Object object = this.lock;
        synchronized (object) {
            if (Util.same(view, this.viewMainPanel.getCurrentNetworkView())) {
                return;
            }
        }
        ViewUtil.invokeOnEDT(() -> {
            if (Util.same(view, ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetworkView())) {
                this.syncFrom(view);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(SetSelectedNetworksEvent e) {
        if (this.loadingSession) {
            return;
        }
        List networks = e.getNetworks();
        Object object = this.lock;
        synchronized (object) {
            if (Util.equalSets(networks, this.netMainPanel.getSelectedNetworks(false))) {
                return;
            }
        }
        ViewUtil.invokeOnEDT(() -> {
            if (Util.equalSets(networks, ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getSelectedNetworks())) {
                this.syncFromSelectedNetworks(networks);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(SetSelectedNetworkViewsEvent e) {
        if (this.loadingSession) {
            return;
        }
        List views = e.getNetworkViews();
        Object object = this.lock;
        synchronized (object) {
            if (Util.equalSets(views, this.viewMainPanel.getSelectedNetworkViews())) {
                return;
            }
        }
        ViewUtil.invokeOnEDT(() -> {
            if (Util.equalSets(views, ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getSelectedNetworkViews())) {
                this.syncFromSelectedViews(views);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncFrom(CyNetwork currentNet) {
        CyNetworkView currentView = this.viewMainPanel.getCurrentNetworkView();
        Collection<Object> selectedViews = this.viewMainPanel.getSelectedNetworkViews();
        Set<Object> selectedNets = this.netMainPanel.getSelectedNetworks(false);
        if (currentNet != null) {
            CyNetworkViewManager viewMgr = (CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class);
            Collection views = viewMgr.getNetworkViews(currentNet);
            if (!selectedNets.contains(currentNet)) {
                selectedNets = Collections.singleton(currentNet);
            }
            if (currentView == null || !((CyNetwork)currentView.getModel()).equals(currentNet)) {
                CyNetworkView cyNetworkView = currentView = views.isEmpty() ? null : (CyNetworkView)views.iterator().next();
            }
            if (currentView == null) {
                selectedViews = Collections.emptySet();
            } else if (!selectedViews.contains(currentView)) {
                selectedViews = Collections.singleton(currentView);
            }
        } else {
            currentView = null;
            selectedNets = Collections.emptySet();
            selectedViews = Collections.emptySet();
        }
        this.removePropertyChangeListeners();
        try {
            this.netMainPanel.setCurrentNetwork(currentNet);
            this.netMainPanel.setSelectedNetworks(selectedNets);
            this.viewMainPanel.setSelectedNetworkViews(selectedViews);
            this.viewMainPanel.setCurrentNetworkView(currentView);
            this.maybeShowNullView(currentView, currentNet);
        }
        finally {
            this.addPropertyChangeListeners();
        }
        this.updateApplicationManager(currentNet, currentView, selectedNets, selectedViews);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncFrom(CyNetworkView currentView) {
        CyNetwork currentNet = this.netMainPanel.getCurrentNetwork();
        Collection<Object> selectedViews = this.viewMainPanel.getSelectedNetworkViews();
        Set<Object> selectedNets = this.netMainPanel.getSelectedNetworks(false);
        if (currentView != null) {
            currentNet = (CyNetwork)currentView.getModel();
            if (!selectedViews.contains(currentView)) {
                if (selectedNets.contains(currentView.getModel())) {
                    selectedViews.add(currentView);
                } else {
                    selectedViews = Collections.singleton(currentView);
                    selectedNets = Collections.singleton(currentNet);
                }
            }
        } else {
            if (currentNet != null) {
                CyNetworkViewManager viewMgr = (CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class);
                for (CyNetwork net : selectedNets) {
                    if (!viewMgr.viewExists(net)) continue;
                    currentNet = null;
                    selectedNets = Collections.emptySet();
                    break;
                }
            }
            selectedViews = Collections.emptySet();
        }
        this.removePropertyChangeListeners();
        try {
            this.viewMainPanel.setCurrentNetworkView(currentView);
            this.viewMainPanel.setSelectedNetworkViews(selectedViews);
            this.netMainPanel.setCurrentNetwork(currentNet);
            this.netMainPanel.setSelectedNetworks(selectedNets);
            this.maybeShowNullView(currentView, currentNet);
        }
        finally {
            this.addPropertyChangeListeners();
        }
        this.updateApplicationManager(currentNet, currentView, selectedNets, selectedViews);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncFromSelectedNetworks(Collection<CyNetwork> selectedNets) {
        CyNetworkView currentView = this.viewMainPanel.getCurrentNetworkView();
        CyNetwork currentNet = this.netMainPanel.getCurrentNetwork();
        Set<CyNetworkView> selectedViews = Util.getNetworkViews(selectedNets, this.serviceRegistrar);
        if (selectedNets.isEmpty()) {
            currentNet = null;
            currentView = null;
        } else {
            if (currentNet == null || !selectedNets.contains(currentNet)) {
                currentNet = selectedNets.iterator().next();
            }
            if (currentView == null || !((CyNetwork)currentView.getModel()).equals(currentNet)) {
                CyNetworkViewManager viewMgr = (CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class);
                Collection views = viewMgr.getNetworkViews(currentNet);
                currentView = views == null || views.isEmpty() ? null : (CyNetworkView)views.iterator().next();
            }
        }
        this.removePropertyChangeListeners();
        try {
            this.netMainPanel.setSelectedNetworks(selectedNets);
            this.netMainPanel.setCurrentNetwork(currentNet);
            if (currentView != null) {
                this.viewMainPanel.setCurrentNetworkView(currentView);
            } else {
                this.viewMainPanel.showNullView(currentNet);
            }
            this.viewMainPanel.setSelectedNetworkViews(selectedViews);
        }
        finally {
            this.addPropertyChangeListeners();
        }
        this.updateApplicationManager(currentNet, currentView, selectedNets, selectedViews);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncFromSelectedViews(Collection<CyNetworkView> selectedViews) {
        CyNetworkView currentView = this.viewMainPanel.getCurrentNetworkView();
        CyNetwork currentNet = this.netMainPanel.getCurrentNetwork();
        Set<CyNetwork> selectedNets = Util.getNetworks(selectedViews);
        this.removePropertyChangeListeners();
        try {
            if (selectedViews.isEmpty()) {
                currentView = null;
            } else if (!selectedViews.contains(currentView)) {
                currentView = selectedViews.iterator().next();
            }
            if (currentView == null) {
                CyNetworkViewManager viewMgr = (CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class);
                if (currentNet != null && viewMgr.viewExists(currentNet)) {
                    currentNet = null;
                }
            } else {
                currentNet = (CyNetwork)currentView.getModel();
            }
            this.viewMainPanel.setSelectedNetworkViews(selectedViews);
            this.viewMainPanel.setCurrentNetworkView(currentView);
            this.netMainPanel.setCurrentNetwork(currentNet);
            this.netMainPanel.setSelectedNetworks(selectedNets);
            this.maybeShowNullView(currentView, currentNet);
        }
        finally {
            this.addPropertyChangeListeners();
        }
        this.updateApplicationManager(currentNet, currentView, selectedNets, selectedViews);
    }

    private void addPropertyChangeListeners() {
        this.removePropertyChangeListeners();
        for (String propName : this.netPanelPropChangeListener.PROP_NAMES) {
            this.netMainPanel.addPropertyChangeListener(propName, this.netPanelPropChangeListener);
        }
        for (String propName : this.viewPanelPropChangeListener.PROP_NAMES) {
            this.viewMainPanel.addPropertyChangeListener(propName, this.viewPanelPropChangeListener);
        }
        for (String propName : this.gridPanelPropChangeListener.PROP_NAMES) {
            this.viewMainPanel.getNetworkViewGrid().addPropertyChangeListener(propName, this.gridPanelPropChangeListener);
        }
    }

    private void removePropertyChangeListeners() {
        for (String propName : this.netPanelPropChangeListener.PROP_NAMES) {
            this.netMainPanel.removePropertyChangeListener(propName, this.netPanelPropChangeListener);
        }
        for (String propName : this.viewPanelPropChangeListener.PROP_NAMES) {
            this.viewMainPanel.removePropertyChangeListener(propName, this.viewPanelPropChangeListener);
        }
        for (String propName : this.gridPanelPropChangeListener.PROP_NAMES) {
            this.viewMainPanel.getNetworkViewGrid().removePropertyChangeListener(propName, this.gridPanelPropChangeListener);
        }
    }

    private void maybeShowNullView(CyNetworkView view, CyNetwork network) {
        if (view == null) {
            this.viewMainPanel.showNullView(network);
        }
    }

    private void updateApplicationManager(CyNetwork currentNetwork, CyNetworkView currentView, Collection<CyNetwork> selectedNetworks, Collection<CyNetworkView> selectedViews) {
        CyApplicationManager appMgr = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class);
        appMgr.setSelectedNetworks(new ArrayList<CyNetwork>(selectedNetworks));
        appMgr.setCurrentNetwork(currentNetwork);
        appMgr.setSelectedNetworkViews(new ArrayList<CyNetworkView>(selectedViews));
        appMgr.setCurrentNetworkView(currentView);
    }

    private class GridPanelPropertyChangeListener
    implements PropertyChangeListener {
        final String[] PROP_NAMES = new String[]{"currentNetworkView"};

        private GridPanelPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("currentNetworkView")) {
                this.handleCurrentViewChange(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleCurrentViewChange(PropertyChangeEvent e) {
            CyNetworkView view = (CyNetworkView)e.getNewValue();
            CyApplicationManager appMgr = (CyApplicationManager)NetworkSelectionMediator.this.serviceRegistrar.getService(CyApplicationManager.class);
            Object object = NetworkSelectionMediator.this.lock;
            synchronized (object) {
                CyNetworkView currentView = appMgr.getCurrentNetworkView();
                if (Util.same(view, currentView)) {
                    return;
                }
            }
            NetworkSelectionMediator.this.syncFrom(view);
        }
    }

    private class ViewPanelPropertyChangeListener
    implements PropertyChangeListener {
        final String[] PROP_NAMES = new String[]{"selectedNetworkViews"};

        private ViewPanelPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("selectedNetworkViews")) {
                this.handleSelectedViewsChange(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleSelectedViewsChange(PropertyChangeEvent e) {
            if (NetworkSelectionMediator.this.loadingSession) {
                return;
            }
            Collection selectedViews = (Collection)e.getNewValue();
            Object object = NetworkSelectionMediator.this.lock;
            synchronized (object) {
                CyApplicationManager appMgr = (CyApplicationManager)NetworkSelectionMediator.this.serviceRegistrar.getService(CyApplicationManager.class);
                if (Util.equalSets(selectedViews, appMgr.getSelectedNetworkViews())) {
                    return;
                }
            }
            NetworkSelectionMediator.this.syncFromSelectedViews(selectedViews);
        }
    }

    private class NetPanelPropertyChangeListener
    implements PropertyChangeListener {
        final String[] PROP_NAMES = new String[]{"currentNetwork", "selectedSubNetworks", "selectedRootNetworks"};

        private NetPanelPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (Arrays.asList(this.PROP_NAMES).contains(e.getPropertyName())) {
                if (e.getPropertyName().equals("currentNetwork")) {
                    this.handleCurrentNetworkChange(e);
                } else if (e.getPropertyName().equals("selectedSubNetworks")) {
                    this.handleSelectedSubNetworksChange(e);
                } else if (e.getPropertyName().equals("selectedRootNetworks")) {
                    this.handleSelectedRootNetworksChange(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleCurrentNetworkChange(PropertyChangeEvent e) {
            if (NetworkSelectionMediator.this.loadingSession) {
                return;
            }
            if (e.getNewValue() == null || e.getNewValue() instanceof CyRootNetwork) {
                NetworkSelectionMediator.this.viewMainPanel.showNullView((CyNetwork)e.getNewValue());
            }
            CyNetwork net = e.getNewValue() instanceof CySubNetwork ? (CyNetwork)e.getNewValue() : null;
            CyApplicationManager appMgr = (CyApplicationManager)NetworkSelectionMediator.this.serviceRegistrar.getService(CyApplicationManager.class);
            Object object = NetworkSelectionMediator.this.lock;
            synchronized (object) {
                CyNetwork currentNet = appMgr.getCurrentNetwork();
                if (Util.same(net, currentNet)) {
                    return;
                }
            }
            NetworkSelectionMediator.this.syncFrom(net);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleSelectedSubNetworksChange(PropertyChangeEvent e) {
            if (NetworkSelectionMediator.this.loadingSession) {
                return;
            }
            Collection selectedNets = (Collection)e.getNewValue();
            Object object = NetworkSelectionMediator.this.lock;
            synchronized (object) {
                CyApplicationManager appMgr = (CyApplicationManager)NetworkSelectionMediator.this.serviceRegistrar.getService(CyApplicationManager.class);
                if (Util.equalSets(selectedNets, appMgr.getSelectedNetworks())) {
                    return;
                }
            }
            NetworkSelectionMediator.this.syncFromSelectedNetworks(selectedNets);
        }

        private void handleSelectedRootNetworksChange(PropertyChangeEvent e) {
            Collection selectedRootNets = (Collection)e.getNewValue();
            NetworkSelectionMediator.this.rootNetManager.setSelectedRootNetworks(selectedRootNets);
        }
    }
}

