/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.view;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.event.PopupMenuListener;
import org.cytoscape.application.swing.CyAction;
import org.cytoscape.internal.actions.DestroyNetworksAction;
import org.cytoscape.internal.model.RootNetworkManager;
import org.cytoscape.internal.task.DynamicTaskFactory;
import org.cytoscape.internal.task.DynamicTogglableTaskFactory;
import org.cytoscape.internal.task.TaskFactoryTunableAction;
import org.cytoscape.internal.view.AbstractNetworkPanel;
import org.cytoscape.internal.view.NetworkMainPanel;
import org.cytoscape.internal.view.RootNetworkPanel;
import org.cytoscape.internal.view.SubNetworkPanel;
import org.cytoscape.internal.view.util.ViewUtil;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkTableManager;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.events.AddedEdgesEvent;
import org.cytoscape.model.events.AddedEdgesListener;
import org.cytoscape.model.events.AddedNodesEvent;
import org.cytoscape.model.events.AddedNodesListener;
import org.cytoscape.model.events.NetworkAboutToBeDestroyedEvent;
import org.cytoscape.model.events.NetworkAboutToBeDestroyedListener;
import org.cytoscape.model.events.NetworkAddedEvent;
import org.cytoscape.model.events.NetworkAddedListener;
import org.cytoscape.model.events.NetworkDestroyedEvent;
import org.cytoscape.model.events.NetworkDestroyedListener;
import org.cytoscape.model.events.RemovedEdgesEvent;
import org.cytoscape.model.events.RemovedEdgesListener;
import org.cytoscape.model.events.RemovedNodesEvent;
import org.cytoscape.model.events.RemovedNodesListener;
import org.cytoscape.model.events.RowsSetEvent;
import org.cytoscape.model.events.RowsSetListener;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.events.SessionAboutToBeLoadedEvent;
import org.cytoscape.session.events.SessionAboutToBeLoadedListener;
import org.cytoscape.session.events.SessionLoadedEvent;
import org.cytoscape.session.events.SessionLoadedListener;
import org.cytoscape.task.DynamicTaskFactoryProvisioner;
import org.cytoscape.task.NetworkCollectionTaskFactory;
import org.cytoscape.task.NetworkTaskFactory;
import org.cytoscape.task.NetworkViewCollectionTaskFactory;
import org.cytoscape.task.NetworkViewTaskFactory;
import org.cytoscape.task.RootNetworkCollectionTaskFactory;
import org.cytoscape.task.edit.EditNetworkTitleTaskFactory;
import org.cytoscape.util.swing.GravityTracker;
import org.cytoscape.util.swing.JMenuTracker;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.model.events.NetworkViewAddedEvent;
import org.cytoscape.view.model.events.NetworkViewAddedListener;
import org.cytoscape.view.model.events.NetworkViewDestroyedEvent;
import org.cytoscape.view.model.events.NetworkViewDestroyedListener;
import org.cytoscape.work.TaskFactory;
import org.cytoscape.work.Togglable;
import org.cytoscape.work.swing.DialogTaskManager;

public class NetworkMediator
implements NetworkAddedListener,
NetworkViewAddedListener,
NetworkAboutToBeDestroyedListener,
NetworkDestroyedListener,
NetworkViewDestroyedListener,
RowsSetListener,
AddedNodesListener,
AddedEdgesListener,
RemovedEdgesListener,
RemovedNodesListener,
SessionAboutToBeLoadedListener,
SessionLoadedListener {
    private final Map<Object, TaskFactory> provisionerMap = new HashMap<Object, TaskFactory>();
    private final Map<Object, CyAction> netPopupActionMap = new WeakHashMap<Object, CyAction>();
    private final Map<Object, CyAction> rootPopupActionMap = new WeakHashMap<Object, CyAction>();
    private boolean loadingSession;
    private final NetworkMainPanel networkMainPanel;
    private final RootNetworkManager rootNetManager;
    private final CyServiceRegistrar serviceRegistrar;

    public NetworkMediator(NetworkMainPanel networkMainPanel, RootNetworkManager rootNetManager, CyServiceRegistrar serviceRegistrar) {
        this.networkMainPanel = networkMainPanel;
        this.rootNetManager = rootNetManager;
        this.serviceRegistrar = serviceRegistrar;
        networkMainPanel.addPropertyChangeListener("rootNetworkPanelCreated", evt -> {
            RootNetworkPanel p = (RootNetworkPanel)evt.getNewValue();
            this.addMouseListenersForSelection(p, p.getHeaderPanel(), p.getNetworkCountLabel(), p.getNameLabel(), p);
        });
        networkMainPanel.addPropertyChangeListener("subNetworkPanelCreated", evt -> {
            SubNetworkPanel p = (SubNetworkPanel)evt.getNewValue();
            this.addMouseListenersForSelection(p, p.getNameLabel(), p.getViewIconLabel(), p.getViewCountLabel(), p.getNodeCountLabel(), p.getEdgeCountLabel(), p);
        });
    }

    public CyNetwork getCurrentNetwork() {
        return this.networkMainPanel.getCurrentNetwork();
    }

    public void handleEvent(SessionAboutToBeLoadedEvent e) {
        this.loadingSession = true;
    }

    public void handleEvent(SessionLoadedEvent e) {
        this.loadingSession = false;
    }

    public void handleEvent(NetworkAboutToBeDestroyedEvent e) {
        if (e.getNetwork() instanceof CySubNetwork) {
            CySubNetwork network = (CySubNetwork)e.getNetwork();
            this.networkMainPanel.removeNetwork(network);
            this.networkMainPanel.updateNodeEdgeCount();
            CyRootNetwork rootNetwork = network.getRootNetwork();
            int subNetworkCount = rootNetwork.getSubNetworkList().size();
            CyNetwork currentNetwork = this.networkMainPanel.getCurrentNetwork();
            if (subNetworkCount == 1 && (rootNetwork.equals(currentNetwork) || network.equals(currentNetwork))) {
                this.networkMainPanel.setCurrentNetwork(null);
            }
        }
    }

    public void handleEvent(NetworkDestroyedEvent e) {
        ViewUtil.invokeOnEDT(() -> {
            this.networkMainPanel.getRootNetworkListPanel().update();
            this.networkMainPanel.updateCollapseExpandButtons();
        });
    }

    public void handleEvent(NetworkAddedEvent e) {
        if (this.loadingSession) {
            return;
        }
        CyNetwork net = e.getNetwork();
        ViewUtil.invokeOnEDT(() -> {
            if (net instanceof CySubNetwork) {
                this.networkMainPanel.addNetwork((CySubNetwork)net);
                this.networkMainPanel.updateNodeEdgeCount();
            }
        });
    }

    public void handleEvent(RowsSetEvent e) {
        if (this.loadingSession || this.networkMainPanel.getRootNetworkListPanel().isEmpty()) {
            return;
        }
        Collection nameRecords = e.getColumnRecords("name");
        if (nameRecords == null || nameRecords.isEmpty()) {
            return;
        }
        CyTable tbl = (CyTable)e.getSource();
        CyNetworkTableManager netTblMgr = (CyNetworkTableManager)this.serviceRegistrar.getService(CyNetworkTableManager.class);
        CyNetwork net = netTblMgr.getNetworkForTable(tbl);
        if (net != null && tbl.equals(net.getDefaultNetworkTable())) {
            ViewUtil.invokeOnEDT(() -> {
                AbstractNetworkPanel<?> item = this.networkMainPanel.getNetworkItem(net);
                if (item != null) {
                    item.update();
                }
            });
        }
    }

    public void handleEvent(AddedEdgesEvent e) {
        this.networkMainPanel.updateNodeEdgeCount();
    }

    public void handleEvent(AddedNodesEvent e) {
        this.networkMainPanel.updateNodeEdgeCount();
    }

    public void handleEvent(RemovedNodesEvent e) {
        this.networkMainPanel.updateNodeEdgeCount();
    }

    public void handleEvent(RemovedEdgesEvent e) {
        this.networkMainPanel.updateNodeEdgeCount();
    }

    public void handleEvent(NetworkViewDestroyedEvent e) {
        if (this.loadingSession) {
            return;
        }
        ViewUtil.invokeOnEDT(() -> {
            CyNetworkViewManager netViewMgr = (CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class);
            for (SubNetworkPanel snp : this.networkMainPanel.getAllSubNetworkItems()) {
                int count = netViewMgr.getNetworkViews(snp.getModel().getNetwork()).size();
                snp.getModel().setViewCount(count);
            }
            this.networkMainPanel.getRootNetworkListPanel().update();
        });
    }

    public void handleEvent(NetworkViewAddedEvent e) {
        if (this.loadingSession) {
            return;
        }
        ViewUtil.invokeOnEDT(() -> this.updateViewCount(e.getNetworkView()));
    }

    public void addRootNetworkCollectionTaskFactory(RootNetworkCollectionTaskFactory factory, Map<?, ?> props) {
        ViewUtil.invokeOnEDT(() -> {
            DynamicTaskFactory provisioner = factory instanceof Togglable ? new DynamicTogglableTaskFactory(factory, this.rootNetManager) : new DynamicTaskFactory(factory, this.rootNetManager);
            this.provisionerMap.put(factory, provisioner);
            this.addFactory(provisioner, props, true);
        });
    }

    public void removeRootNetworkCollectionTaskFactory(RootNetworkCollectionTaskFactory factory, Map<?, ?> props) {
        ViewUtil.invokeOnEDT(() -> this.removeFactory(this.provisionerMap.remove(factory), false));
    }

    public void addNetworkCollectionTaskFactory(NetworkCollectionTaskFactory factory, Map<?, ?> props) {
        ViewUtil.invokeOnEDT(() -> {
            DynamicTaskFactoryProvisioner factoryProvisioner = (DynamicTaskFactoryProvisioner)this.serviceRegistrar.getService(DynamicTaskFactoryProvisioner.class);
            TaskFactory provisioner = factoryProvisioner.createFor(factory);
            this.provisionerMap.put(factory, provisioner);
            this.addFactory(provisioner, props, false);
        });
    }

    public void removeNetworkCollectionTaskFactory(NetworkCollectionTaskFactory factory, Map<?, ?> props) {
        ViewUtil.invokeOnEDT(() -> this.removeFactory(this.provisionerMap.remove(factory), false));
    }

    public void addNetworkViewCollectionTaskFactory(NetworkViewCollectionTaskFactory factory, Map<?, ?> props) {
        ViewUtil.invokeOnEDT(() -> {
            DynamicTaskFactoryProvisioner factoryProvisioner = (DynamicTaskFactoryProvisioner)this.serviceRegistrar.getService(DynamicTaskFactoryProvisioner.class);
            TaskFactory provisioner = factoryProvisioner.createFor(factory);
            this.provisionerMap.put(factory, provisioner);
            this.addFactory(provisioner, props, false);
        });
    }

    public void removeNetworkViewCollectionTaskFactory(NetworkViewCollectionTaskFactory factory, Map<?, ?> props) {
        ViewUtil.invokeOnEDT(() -> this.removeFactory(this.provisionerMap.remove(factory), false));
    }

    public void addNetworkTaskFactory(NetworkTaskFactory factory, Map<?, ?> props) {
        ViewUtil.invokeOnEDT(() -> {
            DynamicTaskFactoryProvisioner factoryProvisioner = (DynamicTaskFactoryProvisioner)this.serviceRegistrar.getService(DynamicTaskFactoryProvisioner.class);
            TaskFactory provisioner = factoryProvisioner.createFor(factory);
            this.provisionerMap.put(factory, provisioner);
            this.addFactory(provisioner, props, false);
        });
    }

    public void removeNetworkTaskFactory(NetworkTaskFactory factory, Map<?, ?> props) {
        ViewUtil.invokeOnEDT(() -> this.removeFactory(this.provisionerMap.remove(factory), false));
    }

    public void addNetworkViewTaskFactory(NetworkViewTaskFactory factory, Map<?, ?> props) {
        ViewUtil.invokeOnEDT(() -> {
            DynamicTaskFactoryProvisioner factoryProvisioner = (DynamicTaskFactoryProvisioner)this.serviceRegistrar.getService(DynamicTaskFactoryProvisioner.class);
            TaskFactory provisioner = factoryProvisioner.createFor(factory);
            this.provisionerMap.put(factory, provisioner);
            this.addFactory(provisioner, props, false);
        });
    }

    public void removeNetworkViewTaskFactory(NetworkViewTaskFactory factory, Map<?, ?> props) {
        ViewUtil.invokeOnEDT(() -> this.removeFactory(this.provisionerMap.remove(factory), false));
    }

    public void addCyAction(CyAction action, Map<?, ?> props) {
        ViewUtil.invokeOnEDT(() -> this.netPopupActionMap.put(action, action));
    }

    public void removeCyAction(CyAction action, Map<?, ?> props) {
        ViewUtil.invokeOnEDT(() -> this.netPopupActionMap.remove(action));
    }

    private void addFactory(TaskFactory factory, Map props, boolean rootPopup) {
        TaskFactoryTunableAction action = props.containsKey("enableFor") ? new TaskFactoryTunableAction(factory, props, this.serviceRegistrar) : new TaskFactoryTunableAction(this.serviceRegistrar, factory, props);
        if (rootPopup) {
            this.rootPopupActionMap.put(factory, (CyAction)action);
        } else {
            this.netPopupActionMap.put(factory, (CyAction)action);
        }
    }

    private void removeFactory(TaskFactory factory, boolean rootPopup) {
        if (rootPopup) {
            this.rootPopupActionMap.remove(factory);
        } else {
            this.netPopupActionMap.remove(factory);
        }
    }

    private void addMouseListenersForSelection(final AbstractNetworkPanel<?> item, JComponent ... components) {
        MouseAdapter selectionListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                NetworkMediator.this.networkMainPanel.onMousePressedItem(e, item);
            }
        };
        PopupListener popupListener = new PopupListener(item);
        for (JComponent c : components) {
            c.addMouseListener(selectionListener);
            c.addMouseListener(popupListener);
        }
    }

    private void updateViewCount(CyNetworkView view) {
        SubNetworkPanel subNetPanel = this.networkMainPanel.getSubNetworkPanel((CyNetwork)view.getModel());
        if (subNetPanel != null) {
            int count = ((CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class)).getNetworkViews((CyNetwork)view.getModel()).size();
            subNetPanel.getModel().setViewCount(count);
        }
    }

    private static void sanitize(JPopupMenu menu) {
        boolean hasSeparator = false;
        for (int i = 0; i < menu.getComponentCount(); ++i) {
            Component comp = menu.getComponent(i);
            if (comp instanceof JSeparator) {
                if (hasSeparator || i == 0 || i == menu.getComponentCount() - 1) {
                    comp.setVisible(false);
                    continue;
                }
                hasSeparator = true;
                continue;
            }
            if (!comp.isVisible()) continue;
            hasSeparator = false;
        }
    }

    private final class PopupListener
    extends MouseAdapter {
        final AbstractNetworkPanel<?> item;

        PopupListener(AbstractNetworkPanel<?> item) {
            this.item = item;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopupMenu(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopupMenu(e);
        }

        private final void maybeShowPopupMenu(MouseEvent e) {
            if (!e.isPopupTrigger()) {
                return;
            }
            List<AbstractNetworkPanel<?>> selectedItems = NetworkMediator.this.networkMainPanel.getSelectedItems();
            if (!selectedItems.contains(this.item)) {
                NetworkMediator.this.networkMainPanel.selectAndSetCurrent(this.item);
                selectedItems = NetworkMediator.this.networkMainPanel.getSelectedItems();
            }
            DialogTaskManager taskMgr = (DialogTaskManager)NetworkMediator.this.serviceRegistrar.getService(DialogTaskManager.class);
            Object network = this.item.getModel().getNetwork();
            JPopupMenu popup = new JPopupMenu();
            if (network instanceof CySubNetwork) {
                this.addMenuItems(popup, NetworkMediator.this.netPopupActionMap.values());
            } else {
                JMenuItem mi = new JMenuItem("Rename Network Collection...");
                mi.addActionListener(evt -> {
                    EditNetworkTitleTaskFactory factory = (EditNetworkTitleTaskFactory)NetworkMediator.this.serviceRegistrar.getService(EditNetworkTitleTaskFactory.class);
                    taskMgr.execute(factory.createTaskIterator(network));
                });
                popup.add(mi);
                mi.setEnabled(selectedItems.size() == 1);
                DestroyNetworksAction action = new DestroyNetworksAction(0.0f, NetworkMediator.this.networkMainPanel, NetworkMediator.this.serviceRegistrar);
                JMenuItem mi2 = new JMenuItem((Action)((Object)action));
                popup.add(mi2);
                action.updateEnableState();
                if (!NetworkMediator.this.rootPopupActionMap.isEmpty()) {
                    popup.addSeparator();
                    this.addMenuItems(popup, NetworkMediator.this.rootPopupActionMap.values());
                }
            }
            NetworkMediator.sanitize(popup);
            popup.addPropertyChangeListener("visible", ev -> {
                boolean visible = Boolean.TRUE.equals(ev.getNewValue());
                if (!visible) {
                    popup.setInvoker(null);
                }
            });
            popup.show(e.getComponent(), e.getX(), e.getY());
        }

        private void addMenuItems(JPopupMenu popup, Collection<CyAction> actions) {
            JMenuTracker menuTracker = new JMenuTracker(popup);
            String menuString = ".";
            for (CyAction a : actions) {
                JMenuItem mi = a.useCheckBoxMenuItem() ? new JCheckBoxMenuItem((Action)a) : new JMenuItem((Action)a);
                GravityTracker gravityTracker = menuTracker.getGravityTracker(menuString);
                if (a.insertSeparatorBefore()) {
                    gravityTracker.addMenuSeparator((double)a.getMenuGravity() - 1.0E-4);
                }
                gravityTracker.addMenuItem(mi, (double)a.getMenuGravity());
                if (a.insertSeparatorAfter()) {
                    gravityTracker.addMenuSeparator((double)a.getMenuGravity() + 1.0E-4);
                }
                a.updateEnableState();
                if (!(a instanceof PopupMenuListener)) continue;
                popup.addPopupMenuListener((PopupMenuListener)a);
            }
        }
    }
}

