/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.CytoPanelComponent2;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.internal.task.LoadFileListTask;
import org.cytoscape.internal.util.Util;
import org.cytoscape.internal.view.AbstractNetworkPanel;
import org.cytoscape.internal.view.NetworkSearchBar;
import org.cytoscape.internal.view.NetworkViewPreviewDialog;
import org.cytoscape.internal.view.RootNetworkPanel;
import org.cytoscape.internal.view.RootNetworkPanelModel;
import org.cytoscape.internal.view.SubNetworkPanel;
import org.cytoscape.internal.view.util.ViewUtil;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.util.swing.TextIcon;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.swing.DialogTaskManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkMainPanel
extends JPanel
implements CytoPanelComponent2 {
    public static final float ICON_FONT_SIZE = 22.0f;
    private static final String TITLE = "Network";
    private static final String ID = "org.cytoscape.Network";
    private JPanel networksPanel;
    private JScrollPane rootNetworkScroll;
    private RootNetworkListPanel rootNetworkListPanel;
    private JPanel networkHeader;
    private JButton expandAllButton;
    private JButton collapseAllButton;
    private JButton optionsBtn;
    private JLabel networkSelectionLabel;
    private CyNetwork currentNetwork;
    private final Map<CyTable, CyNetwork> nameTables = new WeakHashMap<CyTable, CyNetwork>();
    private final Map<CyTable, CyNetwork> nodeEdgeTables = new WeakHashMap<CyTable, CyNetwork>();
    private AbstractNetworkPanel<?> selectionHead;
    private AbstractNetworkPanel<?> selectionTail;
    private AbstractNetworkPanel<?> lastSelected;
    private boolean ignoreSelectionEvents;
    private boolean doNotUpdateCollapseExpandButtons;
    private NetworkViewPreviewDialog viewDialog;
    private TextIcon icon;
    private final NetworkSearchBar networkSearchBar;
    private final CyServiceRegistrar serviceRegistrar;
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    public NetworkMainPanel(NetworkSearchBar networkSearchBar, CyServiceRegistrar serviceRegistrar) {
        this.networkSearchBar = networkSearchBar;
        this.serviceRegistrar = serviceRegistrar;
        this.init();
    }

    public Component getComponent() {
        return this;
    }

    public CytoPanelName getCytoPanelName() {
        return CytoPanelName.WEST;
    }

    public String getTitle() {
        return TITLE;
    }

    public String getIdentifier() {
        return ID;
    }

    public Icon getIcon() {
        if (this.icon == null) {
            this.icon = new TextIcon("\uf1e0", ((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIconFont(14.0f), 16, 16);
        }
        return this.icon;
    }

    private void init() {
        this.setOpaque(!LookAndFeelUtil.isAquaLAF());
        this.setLayout(new BorderLayout());
        this.add((Component)this.networkSearchBar, "North");
        this.add((Component)this.getNetworksPanel(), "Center");
        new NetworkDropListener(null);
        this.updateNetworkHeader();
    }

    private JPanel getNetworksPanel() {
        if (this.networksPanel == null) {
            this.networksPanel = new JPanel();
            this.networksPanel.setOpaque(!LookAndFeelUtil.isAquaLAF());
            this.networksPanel.setLayout(new BorderLayout());
            this.networksPanel.add((Component)this.getNetworkHeader(), "North");
            this.networksPanel.add((Component)this.getRootNetworkScroll(), "Center");
        }
        return this.networksPanel;
    }

    JScrollPane getRootNetworkScroll() {
        if (this.rootNetworkScroll == null) {
            this.rootNetworkScroll = new JScrollPane(this.getRootNetworkListPanel());
            this.rootNetworkScroll.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getColor("Separator.foreground")));
            this.rootNetworkScroll.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    NetworkMainPanel.this.getRootNetworkListPanel().updateScrollableTracksViewportHeight();
                }
            });
            this.rootNetworkScroll.setMinimumSize(new Dimension(280, 160));
            this.rootNetworkScroll.setPreferredSize(new Dimension(380, 420));
        }
        return this.rootNetworkScroll;
    }

    RootNetworkListPanel getRootNetworkListPanel() {
        if (this.rootNetworkListPanel == null) {
            this.rootNetworkListPanel = new RootNetworkListPanel();
            this.setKeyBindings(this.rootNetworkListPanel);
        }
        return this.rootNetworkListPanel;
    }

    private JPanel getNetworkHeader() {
        if (this.networkHeader == null) {
            this.networkHeader = new JPanel();
            this.networkHeader.setOpaque(!LookAndFeelUtil.isAquaLAF());
            GroupLayout layout = new GroupLayout(this.networkHeader);
            this.networkHeader.setLayout(layout);
            layout.setAutoCreateContainerGaps(false);
            layout.setAutoCreateGaps(true);
            layout.setHorizontalGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.getExpandAllButton(), -2, -1, -2).addComponent(this.getCollapseAllButton(), -2, -1, -2).addGap(0, 10, Short.MAX_VALUE).addComponent(this.getNetworkSelectionLabel(), -2, -1, -2).addGap(0, 10, Short.MAX_VALUE).addComponent(this.getOptionsButton(), -2, -1, -2).addContainerGap());
            layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addComponent(this.getExpandAllButton(), -2, -1, -2).addComponent(this.getCollapseAllButton(), -2, -1, -2).addComponent(this.getNetworkSelectionLabel(), -2, -1, -2).addComponent(this.getOptionsButton(), -2, -1, -2));
        }
        return this.networkHeader;
    }

    private JButton getExpandAllButton() {
        if (this.expandAllButton == null) {
            IconManager iconManager = (IconManager)this.serviceRegistrar.getService(IconManager.class);
            this.expandAllButton = new JButton("\uf103");
            this.expandAllButton.setFont(iconManager.getIconFont(17.0f));
            this.expandAllButton.setToolTipText("Expand all network collections");
            this.expandAllButton.setBorderPainted(false);
            this.expandAllButton.setContentAreaFilled(false);
            this.expandAllButton.setFocusPainted(false);
            this.expandAllButton.setBorder(BorderFactory.createEmptyBorder());
            this.expandAllButton.addActionListener(e -> this.expandAllRootNetworks());
        }
        return this.expandAllButton;
    }

    private JButton getCollapseAllButton() {
        if (this.collapseAllButton == null) {
            IconManager iconManager = (IconManager)this.serviceRegistrar.getService(IconManager.class);
            this.collapseAllButton = new JButton("\uf102");
            this.collapseAllButton.setFont(iconManager.getIconFont(17.0f));
            this.collapseAllButton.setToolTipText("Collapse all network collections");
            this.collapseAllButton.setBorderPainted(false);
            this.collapseAllButton.setContentAreaFilled(false);
            this.collapseAllButton.setFocusPainted(false);
            this.collapseAllButton.setBorder(BorderFactory.createEmptyBorder());
            this.collapseAllButton.addActionListener(e -> this.collapseAllRootNetworks());
        }
        return this.collapseAllButton;
    }

    private JButton getOptionsButton() {
        if (this.optionsBtn == null) {
            IconManager iconManager = (IconManager)this.serviceRegistrar.getService(IconManager.class);
            this.optionsBtn = new JButton("\uf013");
            this.optionsBtn.setFont(iconManager.getIconFont(17.6f));
            this.optionsBtn.setToolTipText("Options...");
            this.optionsBtn.setBorderPainted(false);
            this.optionsBtn.setContentAreaFilled(false);
            this.optionsBtn.setFocusPainted(false);
            this.optionsBtn.setBorder(BorderFactory.createEmptyBorder());
            this.optionsBtn.addActionListener(e -> this.getNetworkOptionsMenu().show(this.optionsBtn, 0, this.optionsBtn.getHeight()));
        }
        return this.optionsBtn;
    }

    private JLabel getNetworkSelectionLabel() {
        if (this.networkSelectionLabel == null) {
            this.networkSelectionLabel = new JLabel();
            this.networkSelectionLabel.setHorizontalAlignment(0);
            this.networkSelectionLabel.setFont(this.networkSelectionLabel.getFont().deriveFont(LookAndFeelUtil.getSmallFontSize()));
        }
        return this.networkSelectionLabel;
    }

    private JPopupMenu getNetworkOptionsMenu() {
        JPopupMenu menu = new JPopupMenu();
        JCheckBoxMenuItem mi = new JCheckBoxMenuItem("Show Network Provenance Hierarchy");
        mi.addActionListener(e -> this.setShowNetworkProvenanceHierarchy(mi.isSelected()));
        mi.setSelected(this.isShowNetworkProvenanceHierarchy());
        menu.add(mi);
        mi = new JCheckBoxMenuItem("Show Number of Nodes and Edges");
        mi.addActionListener(e -> this.setShowNodeEdgeCount(mi.isSelected()));
        mi.setSelected(this.isShowNodeEdgeCount());
        menu.add(mi);
        return menu;
    }

    public Map<Long, Integer> getNetworkListOrder() {
        HashMap<Long, Integer> order = new HashMap<Long, Integer>();
        List<SubNetworkPanel> items = this.getAllSubNetworkItems();
        int count = 0;
        for (SubNetworkPanel snp : items) {
            CySubNetwork net = (CySubNetwork)snp.getModel().getNetwork();
            order.put(net.getSUID(), count++);
        }
        return order;
    }

    public int indexOf(CyNetwork network) {
        int idx = -1;
        AbstractNetworkPanel<?> item = this.getNetworkItem(network);
        if (item != null) {
            List<AbstractNetworkPanel<?>> allItems = this.getAllItems(true);
            idx = allItems.indexOf(item);
        }
        return idx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNetworks(Collection<CySubNetwork> networks) {
        this.clear();
        this.ignoreSelectionEvents = true;
        this.doNotUpdateCollapseExpandButtons = true;
        try {
            for (CySubNetwork n : networks) {
                this.addNetwork(n);
            }
        }
        finally {
            this.doNotUpdateCollapseExpandButtons = false;
            this.ignoreSelectionEvents = false;
        }
        this.getRootNetworkListPanel().update();
        this.updateNetworkHeader();
        this.updateNodeEdgeCount();
    }

    public Set<CyNetwork> getSelectedNetworks(boolean includeSelectedRootNetworks) {
        LinkedHashSet<CyNetwork> list = new LinkedHashSet<CyNetwork>();
        for (SubNetworkPanel subNetworkPanel : this.getSelectedSubNetworkItems()) {
            list.add((CyNetwork)subNetworkPanel.getModel().getNetwork());
        }
        if (includeSelectedRootNetworks) {
            for (RootNetworkPanel rootNetworkPanel : this.getSelectedRootNetworkItems()) {
                list.addAll(NetworkMainPanel.getNetworks(rootNetworkPanel.getAllItems()));
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedNetworks(Collection<CyNetwork> selectedNetworks) {
        if (Util.equalSets(selectedNetworks, this.getSelectedNetworks(false))) {
            if (selectedNetworks.isEmpty()) {
                this.lastSelected = null;
                this.selectionTail = null;
                this.selectionHead = null;
            }
            return;
        }
        this.ignoreSelectionEvents = true;
        try {
            for (RootNetworkPanel rnp : this.getRootNetworkListPanel().getAllItems()) {
                this.setSelected(rnp, selectedNetworks.contains(rnp.getModel().getNetwork()));
                for (SubNetworkPanel snp : rnp.getAllItems()) {
                    boolean selected = selectedNetworks.contains(snp.getModel().getNetwork());
                    if (selected && !rnp.isExpanded()) {
                        rnp.expand();
                    }
                    this.setSelected(snp, selected);
                }
            }
        }
        finally {
            this.ignoreSelectionEvents = false;
        }
        List<AbstractNetworkPanel<?>> selectedItems = this.getSelectedItems();
        this.selectionHead = selectedItems.isEmpty() ? null : selectedItems.get(0);
        this.selectionTail = selectedItems.size() > 1 ? selectedItems.get(selectedItems.size() - 1) : null;
        this.lastSelected = selectedItems.isEmpty() ? null : selectedItems.get(selectedItems.size() - 1);
        this.updateNetworkHeader();
    }

    public Set<CyRootNetwork> getSelectedRootNetworks() {
        LinkedHashSet<CyRootNetwork> list = new LinkedHashSet<CyRootNetwork>();
        for (RootNetworkPanel p : this.getSelectedRootNetworkItems()) {
            list.add((CyRootNetwork)p.getModel().getNetwork());
        }
        return list;
    }

    public int countSelectedRootNetworks() {
        return this.getSelectedRootNetworkItems().size();
    }

    public int countSelectedSubNetworks(boolean includeSelectedRootNetworks) {
        return this.getSelectedNetworks(includeSelectedRootNetworks).size();
    }

    public void clear() {
        this.nameTables.clear();
        this.nodeEdgeTables.clear();
        this.ignoreSelectionEvents = true;
        this.doNotUpdateCollapseExpandButtons = true;
        try {
            this.getRootNetworkListPanel().removeAllItems();
        }
        finally {
            this.doNotUpdateCollapseExpandButtons = false;
            this.ignoreSelectionEvents = false;
        }
        this.selectionTail = null;
        this.selectionHead = null;
        this.lastSelected = null;
        this.updateNetworkHeader();
    }

    public boolean isShowNodeEdgeCount() {
        return "true".equalsIgnoreCase(ViewUtil.getViewProperty("showNodeEdgeCount", this.serviceRegistrar));
    }

    public void setShowNodeEdgeCount(boolean b) {
        ViewUtil.setViewProperty("showNodeEdgeCount", "" + b, this.serviceRegistrar);
        this.updateNodeEdgeCount();
    }

    public boolean isShowNetworkProvenanceHierarchy() {
        return "true".equalsIgnoreCase(ViewUtil.getViewProperty("showNetworkProvenanceHierarchy", this.serviceRegistrar));
    }

    public void setShowNetworkProvenanceHierarchy(boolean b) {
        for (RootNetworkPanel item : this.getRootNetworkListPanel().getAllItems()) {
            item.setShowIndentation(b);
        }
        ViewUtil.setViewProperty("showNetworkProvenanceHierarchy", "" + b, this.serviceRegistrar);
    }

    public void scrollTo(CyNetwork network) {
        AbstractNetworkPanel target = network instanceof CySubNetwork ? this.getSubNetworkPanel(network) : this.getRootNetworkPanel(network);
        if (target != null) {
            if (target instanceof SubNetworkPanel) {
                RootNetworkPanel rnp = this.getRootNetworkPanel((CyNetwork)((CySubNetwork)((SubNetworkPanel)target).getModel().getNetwork()).getRootNetwork());
                rnp.expand();
            }
            ((JComponent)target.getParent()).scrollRectToVisible(target.getBounds());
        }
    }

    protected SubNetworkPanel addNetwork(CySubNetwork network) {
        CyRootNetwork rootNetwork = network.getRootNetwork();
        RootNetworkPanel rootNetPanel = this.getRootNetworkPanel((CyNetwork)rootNetwork);
        if (rootNetPanel == null) {
            rootNetPanel = this.getRootNetworkListPanel().addItem(rootNetwork);
            this.setKeyBindings(rootNetPanel);
            new NetworkDropListener(rootNetwork);
            RootNetworkPanel item = rootNetPanel;
            item.addPropertyChangeListener("expanded", e -> {
                List<AbstractNetworkPanel<SubNetworkPanel>> selectedItems;
                if (Boolean.FALSE.equals(e.getNewValue()) && !(selectedItems = this.getSelectedItems()).isEmpty()) {
                    selectedItems.removeAll(item.getAllItems());
                    this.setSelectedItems(selectedItems);
                }
                this.updateCollapseExpandButtons();
            });
            item.addPropertyChangeListener("selected", e -> {
                if (!this.ignoreSelectionEvents) {
                    boolean selected = (Boolean)e.getNewValue();
                    Set<CyRootNetwork> oldSelection = this.getSelectedRootNetworks();
                    if (selected) {
                        oldSelection.remove(item.getModel().getNetwork());
                    } else {
                        oldSelection.add((CyRootNetwork)item.getModel().getNetwork());
                    }
                    this.fireSelectedRootNetworksChange(oldSelection);
                }
            });
            this.firePropertyChange("rootNetworkPanelCreated", null, item);
        }
        final SubNetworkPanel subNetPanel = rootNetPanel.addItem(network);
        this.setKeyBindings(subNetPanel);
        subNetPanel.addPropertyChangeListener("selected", e -> {
            if (!this.ignoreSelectionEvents) {
                this.updateNetworkSelectionLabel();
                boolean selected = (Boolean)e.getNewValue();
                Set<CyNetwork> oldSelection = this.getSelectedNetworks(false);
                if (selected) {
                    oldSelection.remove(subNetPanel.getModel().getNetwork());
                } else {
                    oldSelection.add((CyNetwork)subNetPanel.getModel().getNetwork());
                }
                this.fireSelectedSubNetworksChange(oldSelection);
            }
        });
        subNetPanel.getViewIconLabel().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                NetworkMainPanel.this.maybeShowViewPopup(subNetPanel);
            }
        });
        this.firePropertyChange("subNetworkPanelCreated", null, subNetPanel);
        rootNetPanel.expand();
        this.scrollTo((CyNetwork)network);
        this.nameTables.put(network.getDefaultNetworkTable(), (CyNetwork)network);
        this.nodeEdgeTables.put(network.getDefaultNodeTable(), (CyNetwork)network);
        this.nodeEdgeTables.put(network.getDefaultEdgeTable(), (CyNetwork)network);
        return subNetPanel;
    }

    protected void removeNetwork(CySubNetwork network) {
        this.nameTables.values().removeAll(Collections.singletonList(network));
        this.nodeEdgeTables.values().removeAll(Collections.singletonList(network));
        ViewUtil.invokeOnEDT(() -> {
            CyRootNetwork rootNet = network.getRootNetwork();
            RootNetworkPanel item = this.getRootNetworkPanel((CyNetwork)rootNet);
            if (item != null) {
                item.removeItem(network);
                if (item.isEmpty()) {
                    this.getRootNetworkListPanel().removeItem(rootNet);
                    this.nameTables.values().removeAll(Collections.singletonList(rootNet));
                    this.nodeEdgeTables.values().removeAll(Collections.singletonList(rootNet));
                }
                this.updateNetworkHeader();
            }
        });
    }

    private boolean setSelected(AbstractNetworkPanel<?> item, boolean selected) {
        if (item.isSelected() != selected) {
            item.setSelected(selected);
            if (!selected) {
                if (item == this.selectionHead) {
                    this.selectionHead = null;
                }
                if (item == this.selectionTail) {
                    this.selectionTail = null;
                }
            }
            return true;
        }
        return false;
    }

    protected AbstractNetworkPanel<?> getNetworkItem(CyNetwork net) {
        if (net instanceof CySubNetwork) {
            return this.getSubNetworkPanel(net);
        }
        if (net instanceof CyRootNetwork) {
            return this.getRootNetworkPanel(net);
        }
        return null;
    }

    private AbstractNetworkPanel<?> getPreviousItem(AbstractNetworkPanel<?> item, boolean includeInvisible) {
        List<AbstractNetworkPanel<?>> allItems = this.getAllItems(includeInvisible);
        int index = allItems.indexOf(item);
        return index > 0 ? allItems.get(index - 1) : null;
    }

    private AbstractNetworkPanel<?> getNextItem(AbstractNetworkPanel<?> item, boolean includeInvisible) {
        List<AbstractNetworkPanel<?>> allItems = this.getAllItems(includeInvisible);
        int index = allItems.indexOf(item);
        return index >= 0 && index < allItems.size() - 1 ? allItems.get(index + 1) : null;
    }

    RootNetworkPanel getRootNetworkPanel(CyNetwork net) {
        if (net instanceof CyRootNetwork) {
            return this.getRootNetworkListPanel().getItem((CyRootNetwork)net);
        }
        return null;
    }

    SubNetworkPanel getSubNetworkPanel(CyNetwork net) {
        CySubNetwork subNet;
        CyRootNetwork rootNet;
        RootNetworkPanel rootNetPanel;
        if (net instanceof CySubNetwork && (rootNetPanel = this.getRootNetworkPanel((CyNetwork)(rootNet = (subNet = (CySubNetwork)net).getRootNetwork()))) != null) {
            return rootNetPanel.getItem(subNet);
        }
        return null;
    }

    private void updateNetworkHeader() {
        this.updateCollapseExpandButtons();
        this.updateNetworkSelectionLabel();
    }

    protected void updateNodeEdgeCount() {
        ViewUtil.invokeOnEDT(() -> {
            int nodeLabelWidth = 0;
            int edgeLabelWidth = 0;
            for (SubNetworkPanel snp : this.getAllSubNetworkItems()) {
                snp.getNodeCountLabel().setVisible(this.isShowNodeEdgeCount());
                snp.getEdgeCountLabel().setVisible(this.isShowNodeEdgeCount());
                if (!this.isShowNodeEdgeCount()) continue;
                snp.updateCountLabels();
                FontMetrics nfm = snp.getNodeCountLabel().getFontMetrics(snp.getNodeCountLabel().getFont());
                FontMetrics efm = snp.getEdgeCountLabel().getFontMetrics(snp.getEdgeCountLabel().getFont());
                nodeLabelWidth = Math.max(nodeLabelWidth, nfm.stringWidth(snp.getNodeCountLabel().getText()));
                edgeLabelWidth = Math.max(edgeLabelWidth, efm.stringWidth(snp.getEdgeCountLabel().getText()));
            }
            if (!this.isShowNodeEdgeCount()) {
                return;
            }
            for (SubNetworkPanel snp : this.getAllSubNetworkItems()) {
                Dimension nd = new Dimension(nodeLabelWidth, snp.getNodeCountLabel().getPreferredSize().height);
                snp.getNodeCountLabel().setPreferredSize(nd);
                snp.getNodeCountLabel().setSize(nd);
                Dimension ed = new Dimension(edgeLabelWidth, snp.getEdgeCountLabel().getPreferredSize().height);
                snp.getEdgeCountLabel().setPreferredSize(ed);
                snp.getEdgeCountLabel().setSize(ed);
            }
        });
    }

    protected void updateCollapseExpandButtons() {
        if (this.doNotUpdateCollapseExpandButtons) {
            return;
        }
        boolean enableCollapse = false;
        boolean enableExpand = false;
        Collection<RootNetworkPanel> allItems = this.getRootNetworkListPanel().getAllItems();
        for (RootNetworkPanel item : allItems) {
            if (item.isExpanded()) {
                enableCollapse = true;
            } else {
                enableExpand = true;
            }
            if (!enableExpand || !enableCollapse) continue;
            break;
        }
        this.getCollapseAllButton().setEnabled(enableCollapse);
        this.getExpandAllButton().setEnabled(enableExpand);
    }

    private void updateNetworkSelectionLabel() {
        int total = this.getSubNetworkCount();
        if (total == 0) {
            this.getNetworkSelectionLabel().setText(null);
        } else {
            int selected = this.countSelectedSubNetworks(false);
            this.getNetworkSelectionLabel().setText(selected + " of " + total + " Network" + (total == 1 ? "" : "s") + " selected");
        }
        this.getNetworkHeader().updateUI();
    }

    private void collapseAllRootNetworks() {
        this.setSelectedItems(this.getSelectedRootNetworkItems());
        this.doNotUpdateCollapseExpandButtons = true;
        Collection<RootNetworkPanel> allItems = this.getRootNetworkListPanel().getAllItems();
        for (RootNetworkPanel item : allItems) {
            item.collapse();
        }
        this.doNotUpdateCollapseExpandButtons = false;
        this.updateCollapseExpandButtons();
    }

    private void expandAllRootNetworks() {
        this.doNotUpdateCollapseExpandButtons = true;
        Collection<RootNetworkPanel> allItems = this.getRootNetworkListPanel().getAllItems();
        for (RootNetworkPanel item : allItems) {
            item.expand();
        }
        this.doNotUpdateCollapseExpandButtons = false;
        this.updateCollapseExpandButtons();
    }

    private void selectAll() {
        List<AbstractNetworkPanel<?>> allItems = this.getAllItems(false);
        if (!allItems.isEmpty()) {
            this.setSelectedItems(this.getAllItems(false));
            this.selectionHead = allItems.get(0);
            this.selectionTail = allItems.get(allItems.size() - 1);
            this.lastSelected = this.selectionTail;
        }
    }

    private void deselectAll() {
        this.setSelectedItems(Collections.emptyList());
        this.setCurrentNetwork(null);
        this.selectionTail = null;
        this.selectionHead = null;
        this.lastSelected = null;
    }

    public List<AbstractNetworkPanel<?>> getAllItems(boolean includeInvisible) {
        ArrayList list = new ArrayList();
        for (RootNetworkPanel item : this.getRootNetworkListPanel().getAllItems()) {
            list.add(item);
            if (!includeInvisible && !item.isExpanded()) continue;
            list.addAll(item.getAllItems());
        }
        return list;
    }

    List<AbstractNetworkPanel<?>> getSelectedItems() {
        List<AbstractNetworkPanel<?>> items = this.getAllItems(true);
        Iterator<AbstractNetworkPanel<?>> iterator = items.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().isSelected()) continue;
            iterator.remove();
        }
        return items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSelectedItems(Collection<? extends AbstractNetworkPanel<?>> items) {
        Set<CyRootNetwork> oldRootSelection = this.getSelectedRootNetworks();
        Set<CyNetwork> oldSubSelection = this.getSelectedNetworks(false);
        boolean rootChanged = false;
        boolean subChanged = false;
        this.ignoreSelectionEvents = true;
        try {
            for (AbstractNetworkPanel<?> p : this.getAllItems(true)) {
                boolean b = this.setSelected(p, items.contains(p));
                if (!b) continue;
                if (p.getModel().getNetwork() instanceof CyRootNetwork) {
                    rootChanged = true;
                    continue;
                }
                if (!(p.getModel().getNetwork() instanceof CySubNetwork)) continue;
                subChanged = true;
            }
        }
        finally {
            this.ignoreSelectionEvents = false;
            this.updateNetworkHeader();
        }
        if (rootChanged) {
            this.fireSelectedRootNetworksChange(oldRootSelection);
        }
        if (subChanged) {
            this.fireSelectedSubNetworksChange(oldSubSelection);
        }
    }

    void selectAndSetCurrent(AbstractNetworkPanel<?> item) {
        if (item == null) {
            return;
        }
        this.setSelectedItems(Collections.singleton(item));
        this.selectionHead = item;
        this.lastSelected = this.selectionHead;
        this.selectionTail = null;
        this.setCurrentNetwork((CyNetwork)item.getModel().getNetwork());
    }

    CyNetwork getCurrentNetwork() {
        return this.currentNetwork;
    }

    void setCurrentNetwork(CyNetwork newValue) {
        if (!Objects.equals(newValue, this.currentNetwork)) {
            CyNetwork oldValue = this.currentNetwork;
            this.currentNetwork = newValue;
            this.getRootNetworkListPanel().update();
            if (newValue != null) {
                this.scrollTo(newValue);
            }
            this.firePropertyChange("currentNetwork", oldValue, newValue);
        }
    }

    public List<SubNetworkPanel> getAllSubNetworkItems() {
        ArrayList<SubNetworkPanel> list = new ArrayList<SubNetworkPanel>();
        for (RootNetworkPanel item : this.getRootNetworkListPanel().getAllItems()) {
            list.addAll(item.getAllItems());
        }
        return list;
    }

    Collection<RootNetworkPanel> getSelectedRootNetworkItems() {
        ArrayList<RootNetworkPanel> list = new ArrayList<RootNetworkPanel>();
        for (RootNetworkPanel rnp : this.getRootNetworkListPanel().getAllItems()) {
            if (!rnp.isSelected()) continue;
            list.add(rnp);
        }
        return list;
    }

    Collection<SubNetworkPanel> getSelectedSubNetworkItems() {
        ArrayList<SubNetworkPanel> list = new ArrayList<SubNetworkPanel>();
        for (SubNetworkPanel snp : this.getAllSubNetworkItems()) {
            if (!snp.isSelected()) continue;
            list.add(snp);
        }
        return list;
    }

    int getSubNetworkCount() {
        int count = 0;
        for (RootNetworkPanel item : this.getRootNetworkListPanel().getAllItems()) {
            count += item.getAllItems().size();
        }
        return count;
    }

    private static Set<CyNetwork> getNetworks(Collection<SubNetworkPanel> items) {
        LinkedHashSet<CyNetwork> list = new LinkedHashSet<CyNetwork>();
        for (SubNetworkPanel snp : items) {
            list.add((CyNetwork)snp.getModel().getNetwork());
        }
        return list;
    }

    protected void onMousePressedItem(MouseEvent e, AbstractNetworkPanel<?> item) {
        item.requestFocusInWindow();
        if (!e.isPopupTrigger() && SwingUtilities.isLeftMouseButton(e)) {
            boolean isMac = LookAndFeelUtil.isMac();
            if (isMac && e.isMetaDown() || !isMac && e.isControlDown()) {
                item.setSelected(!item.isSelected());
                this.selectionHead = item.isSelected() ? item : this.findNextSelectionHead(this.selectionHead);
                this.lastSelected = this.selectionHead;
            } else {
                if (e.isShiftDown()) {
                    this.selectRange(item);
                } else {
                    this.selectAndSetCurrent(item);
                }
                if (this.getSelectedItems().size() == 1) {
                    this.selectionHead = item;
                    this.lastSelected = this.selectionHead;
                    this.selectionTail = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectRange(AbstractNetworkPanel<?> target) {
        if (this.selectionHead != null && this.selectionHead.isVisible() && this.selectionHead.isSelected() && this.selectionHead != target) {
            Set<CyRootNetwork> oldRootSelection = this.getSelectedRootNetworks();
            Set<CyNetwork> oldSubSelection = this.getSelectedNetworks(false);
            boolean changed = false;
            this.ignoreSelectionEvents = true;
            try {
                if (this.selectionTail != null) {
                    changed = this.changeRangeSelection(this.selectionHead, this.selectionTail, false);
                }
                this.selectionTail = target;
            }
            finally {
                this.ignoreSelectionEvents = false;
                this.updateNetworkHeader();
            }
            if (changed |= this.changeRangeSelection(this.selectionHead, this.selectionTail, true)) {
                this.fireSelectedRootNetworksChange(oldRootSelection);
                this.fireSelectedSubNetworksChange(oldSubSelection);
            }
        } else if (!target.isSelected()) {
            target.setSelected(true);
            this.lastSelected = target;
        }
    }

    private boolean changeRangeSelection(AbstractNetworkPanel<?> item1, AbstractNetworkPanel<?> item2, boolean selected) {
        List<AbstractNetworkPanel<?>> subList;
        boolean changed = false;
        List<AbstractNetworkPanel<?>> items = this.getAllItems(false);
        int idx1 = items.indexOf(item1);
        int idx2 = items.indexOf(item2);
        if (idx2 >= idx1) {
            subList = items.subList(idx1 + 1, idx2 + 1);
            this.lastSelected = this.selectionTail;
        } else {
            subList = items.subList(idx2, idx1);
            Collections.reverse(subList);
            this.lastSelected = this.selectionHead;
        }
        for (AbstractNetworkPanel<?> nextItem : subList) {
            if (!nextItem.isVisible() || nextItem.isSelected() == selected) continue;
            nextItem.setSelected(selected);
            changed = true;
        }
        return changed;
    }

    private AbstractNetworkPanel<?> findNextSelectionHead(AbstractNetworkPanel<?> fromItem) {
        AbstractNetworkPanel<?> head = null;
        List<AbstractNetworkPanel<?>> items = this.getAllItems(false);
        if (fromItem != null) {
            List<AbstractNetworkPanel<?>> subList = items.subList(items.indexOf(fromItem), items.size());
            for (AbstractNetworkPanel<?> nextItem : subList) {
                if (!nextItem.isVisible() || !nextItem.isSelected()) continue;
                head = nextItem;
                break;
            }
            if (head == null) {
                subList = items.subList(0, items.indexOf(fromItem));
                ListIterator<AbstractNetworkPanel<?>> li = subList.listIterator(subList.size());
                while (li.hasPrevious()) {
                    AbstractNetworkPanel<?> previousItem = li.previous();
                    if (!previousItem.isVisible() || !previousItem.isSelected()) continue;
                    head = previousItem;
                    break;
                }
            }
        }
        return head;
    }

    private void setKeyBindings(JComponent comp) {
        ActionMap actionMap = comp.getActionMap();
        InputMap inputMap = comp.getInputMap(1);
        int ctrl = LookAndFeelUtil.isMac() ? 256 : 128;
        inputMap.put(KeyStroke.getKeyStroke(38, 0), "VK_UP");
        inputMap.put(KeyStroke.getKeyStroke(40, 0), "VK_DOWN");
        inputMap.put(KeyStroke.getKeyStroke(38, 64), "VK_SHIFT_UP");
        inputMap.put(KeyStroke.getKeyStroke(40, 64), "VK_SHIFT_DOWN");
        inputMap.put(KeyStroke.getKeyStroke(65, ctrl), "VK_CTRL_A");
        inputMap.put(KeyStroke.getKeyStroke(65, ctrl + 64), "VK_CTRL_SHIFT_A");
        actionMap.put("VK_UP", new KeyAction("VK_UP"));
        actionMap.put("VK_DOWN", new KeyAction("VK_DOWN"));
        actionMap.put("VK_SHIFT_UP", new KeyAction("VK_SHIFT_UP"));
        actionMap.put("VK_SHIFT_DOWN", new KeyAction("VK_SHIFT_DOWN"));
        actionMap.put("VK_CTRL_A", new KeyAction("VK_CTRL_A"));
        actionMap.put("VK_CTRL_SHIFT_A", new KeyAction("VK_CTRL_SHIFT_A"));
    }

    private void fireSelectedSubNetworksChange(Collection<CyNetwork> oldValue) {
        this.firePropertyChange("selectedSubNetworks", oldValue, this.getSelectedNetworks(false));
    }

    private void fireSelectedRootNetworksChange(Collection<CyRootNetwork> oldValue) {
        this.firePropertyChange("selectedRootNetworks", oldValue, this.getSelectedRootNetworks());
    }

    static void styleButton(AbstractButton btn, Font font) {
        btn.setFont(font);
        btn.setBorder(null);
        btn.setContentAreaFilled(false);
        btn.setBorderPainted(false);
        btn.setPreferredSize(new Dimension(32, 32));
    }

    private void maybeShowViewPopup(SubNetworkPanel item) {
        CySubNetwork network = (CySubNetwork)item.getModel().getNetwork();
        if (this.viewDialog != null) {
            if (this.viewDialog.getNetwork().equals(network)) {
                return;
            }
            this.viewDialog.dispose();
        }
        if (item.getModel().getViewCount() > 1) {
            Window windowAncestor = SwingUtilities.getWindowAncestor(item);
            CyNetworkView currentView = ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetworkView();
            this.viewDialog = new NetworkViewPreviewDialog(network, currentView, windowAncestor, this.serviceRegistrar);
            this.viewDialog.addWindowFocusListener(new WindowFocusListener(){

                @Override
                public void windowLostFocus(WindowEvent e) {
                    if (NetworkMainPanel.this.viewDialog != null) {
                        NetworkMainPanel.this.viewDialog.dispose();
                    }
                }

                @Override
                public void windowGainedFocus(WindowEvent e) {
                }
            });
            this.viewDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    NetworkMainPanel.this.viewDialog = null;
                }
            });
            this.viewDialog.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 27 && NetworkMainPanel.this.viewDialog != null) {
                        NetworkMainPanel.this.viewDialog.dispose();
                    }
                }
            });
            this.viewDialog.addPropertyChangeListener("currentNetworkView", evt -> ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).setCurrentNetworkView((CyNetworkView)evt.getNewValue()));
            Point screenPt = item.getViewIconLabel().getLocationOnScreen();
            Point compPt = item.getViewIconLabel().getLocation();
            int xOffset = screenPt.x - compPt.x - item.getViewIconLabel().getWidth() / 2;
            int yOffset = screenPt.y - compPt.y + item.getViewIconLabel().getBounds().height - 2;
            Point pt = item.getViewIconLabel().getBounds().getLocation();
            pt.translate(xOffset, yOffset);
            this.viewDialog.setLocation(pt);
            this.viewDialog.setVisible(true);
            this.viewDialog.requestFocusInWindow();
        }
    }

    public class NetworkDropListener
    implements DropTargetListener {
        private final CyRootNetwork rootNetwork;
        private final JComponent targetComponent;
        private final JComponent focusComponent;
        private final DropTarget dropTarget;
        private Border originalBorder;

        public NetworkDropListener(CyRootNetwork rootNetwork) {
            this.rootNetwork = rootNetwork;
            this.targetComponent = rootNetwork == null ? NetworkMainPanel.this.getNetworksPanel() : NetworkMainPanel.this.getNetworkItem((CyNetwork)rootNetwork);
            this.focusComponent = this.targetComponent == NetworkMainPanel.this.getNetworksPanel() ? NetworkMainPanel.this.getRootNetworkScroll() : this.targetComponent;
            this.targetComponent.setTransferHandler(new TransferHandler(){

                @Override
                public boolean canImport(TransferHandler.TransferSupport info) {
                    return NetworkDropListener.this.dropTarget != null && NetworkDropListener.this.dropTarget.isActive() && NetworkDropListener.this.isAcceptable(info);
                }

                @Override
                public boolean importData(TransferHandler.TransferSupport info) {
                    return NetworkDropListener.this.dropTarget != null && NetworkDropListener.this.dropTarget.isActive() && info.isDrop() && NetworkDropListener.this.isAcceptable(info);
                }
            });
            this.dropTarget = new DropTarget(this.targetComponent, this);
        }

        @Override
        public void dragEnter(DropTargetDragEvent evt) {
            this.originalBorder = this.focusComponent.getBorder();
            this.focusComponent.setBorder(BorderFactory.createLineBorder(UIManager.getColor("Focus.color"), 2));
        }

        @Override
        public void dragExit(DropTargetEvent evt) {
            this.focusComponent.setBorder(this.originalBorder);
        }

        @Override
        public void dragOver(DropTargetDragEvent evt) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent evt) {
        }

        @Override
        public void drop(DropTargetDropEvent evt) {
            this.focusComponent.setBorder(this.originalBorder);
            if (!this.isAcceptable(evt)) {
                evt.rejectDrop();
                return;
            }
            evt.acceptDrop(evt.getDropAction());
            Transferable t = evt.getTransferable();
            if (evt.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                List data;
                try {
                    data = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                }
                catch (Exception e) {
                    logger.error("Cannot load network files by Drag-and-Drop.", (Throwable)e);
                    return;
                }
                new Thread(() -> this.loadFiles(data)).start();
            }
        }

        private void loadFiles(List<File> data) {
            DialogTaskManager taskManager = (DialogTaskManager)NetworkMainPanel.this.serviceRegistrar.getService(DialogTaskManager.class);
            taskManager.execute(new TaskIterator(new Task[]{new LoadFileListTask(data, this.rootNetwork, NetworkMainPanel.this.serviceRegistrar)}));
        }

        private boolean isAcceptable(DropTargetDropEvent evt) {
            return evt.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
        }

        private boolean isAcceptable(TransferHandler.TransferSupport info) {
            return info.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
        }
    }

    private class KeyAction
    extends AbstractAction {
        static final String VK_UP = "VK_UP";
        static final String VK_DOWN = "VK_DOWN";
        static final String VK_SHIFT_UP = "VK_SHIFT_UP";
        static final String VK_SHIFT_DOWN = "VK_SHIFT_DOWN";
        static final String VK_CTRL_A = "VK_CTRL_A";
        static final String VK_CTRL_SHIFT_A = "VK_CTRL_SHIFT_A";

        KeyAction(String actionCommand) {
            this.putValue("ActionCommandKey", actionCommand);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            List<AbstractNetworkPanel<?>> allItems = NetworkMainPanel.this.getAllItems(false);
            if (allItems.isEmpty()) {
                return;
            }
            if (cmd.equals(VK_UP)) {
                if (NetworkMainPanel.this.lastSelected != null) {
                    AbstractNetworkPanel<?> previous = NetworkMainPanel.this.getPreviousItem(NetworkMainPanel.this.lastSelected, false);
                    NetworkMainPanel.this.selectAndSetCurrent(previous != null ? previous : allItems.get(0));
                }
            } else if (cmd.equals(VK_DOWN)) {
                if (NetworkMainPanel.this.lastSelected != null) {
                    AbstractNetworkPanel<?> next = NetworkMainPanel.this.getNextItem(NetworkMainPanel.this.lastSelected, false);
                    NetworkMainPanel.this.selectAndSetCurrent(next != null ? next : allItems.get(allItems.size() - 1));
                }
            } else if (cmd.equals(VK_SHIFT_UP)) {
                AbstractNetworkPanel<?> previous = NetworkMainPanel.this.getPreviousItem(NetworkMainPanel.this.lastSelected, false);
                if (previous != null) {
                    NetworkMainPanel.this.selectRange(previous);
                }
            } else if (cmd.equals(VK_SHIFT_DOWN)) {
                AbstractNetworkPanel<?> next = NetworkMainPanel.this.getNextItem(NetworkMainPanel.this.lastSelected, false);
                if (next != null) {
                    NetworkMainPanel.this.selectRange(next);
                }
            } else if (cmd.equals(VK_CTRL_A)) {
                NetworkMainPanel.this.selectAll();
            } else if (cmd.equals(VK_CTRL_SHIFT_A)) {
                NetworkMainPanel.this.deselectAll();
            }
        }
    }

    class RootNetworkListPanel
    extends JPanel
    implements Scrollable {
        private final JPanel filler = new JPanel();
        private final JLabel dropIconLabel = new JLabel();
        private final JLabel dropLabel = new JLabel("Drag network files here");
        private final Border dropBorder;
        private boolean scrollableTracksViewportHeight;
        private final Map<CyRootNetwork, RootNetworkPanel> items = new LinkedHashMap<CyRootNetwork, RootNetworkPanel>();

        RootNetworkListPanel() {
            this.setBackground(UIManager.getColor("Table.background"));
            Color fg = UIManager.getColor("Label.disabledForeground");
            fg = new Color(fg.getRed(), fg.getGreen(), fg.getBlue(), 120);
            this.dropBorder = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createDashedBorder(fg, 2.0f, 2.0f, 2.0f, true));
            this.dropIconLabel.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("/images/drop-net-file-56.png")));
            this.dropIconLabel.setForeground(fg);
            this.dropLabel.setFont(this.dropLabel.getFont().deriveFont(18.0f).deriveFont(1));
            this.dropLabel.setForeground(fg);
            this.filler.setAlignmentX(0.0f);
            this.filler.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
            this.filler.setBackground(this.getBackground());
            this.filler.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (!e.isPopupTrigger()) {
                        NetworkMainPanel.this.deselectAll();
                    }
                }
            });
            GroupLayout layout = new GroupLayout(this.filler);
            this.filler.setLayout(layout);
            layout.setAutoCreateContainerGaps(false);
            layout.setAutoCreateGaps(false);
            layout.setHorizontalGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addComponent(this.dropIconLabel, -2, -1, -2).addComponent(this.dropLabel, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE));
            layout.setVerticalGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.dropIconLabel, -2, -1, -2).addComponent(this.dropLabel, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE));
            this.setLayout(new BoxLayout(this, 1));
            this.add(this.filler);
            this.updateDropArea();
            this.updateScrollableTracksViewportHeight();
        }

        void update() {
            this.updateDropArea();
            for (RootNetworkPanel rnp : this.getAllItems()) {
                boolean currentRoot = false;
                for (SubNetworkPanel snp : rnp.getAllItems()) {
                    boolean current = ((CySubNetwork)snp.getModel().getNetwork()).equals(NetworkMainPanel.this.currentNetwork);
                    snp.getModel().setCurrent(current);
                    if (!current) continue;
                    currentRoot = true;
                }
                rnp.getModel().setCurrent(currentRoot);
                rnp.update();
            }
            this.updateScrollableTracksViewportHeight();
        }

        void updateDropArea() {
            boolean empty = this.items == null || this.items.isEmpty();
            this.dropIconLabel.setVisible(empty);
            this.dropLabel.setVisible(empty);
            this.filler.setBorder(empty ? this.dropBorder : null);
        }

        void updateScrollableTracksViewportHeight() {
            boolean oldValue = this.scrollableTracksViewportHeight;
            if (this.items == null || this.items.isEmpty()) {
                this.scrollableTracksViewportHeight = true;
            } else {
                int ih = 0;
                for (RootNetworkPanel rnp : this.items.values()) {
                    ih += rnp.getHeight();
                }
                boolean bl = this.scrollableTracksViewportHeight = ih <= NetworkMainPanel.this.getRootNetworkScroll().getViewport().getHeight();
            }
            if (oldValue != this.scrollableTracksViewportHeight) {
                this.updateUI();
            }
        }

        Collection<RootNetworkPanel> getAllItems() {
            return new ArrayList<RootNetworkPanel>(this.items.values());
        }

        RootNetworkPanel addItem(CyRootNetwork rootNetwork) {
            if (!this.items.containsKey(rootNetwork)) {
                RootNetworkPanelModel model = new RootNetworkPanelModel(rootNetwork, NetworkMainPanel.this.serviceRegistrar);
                RootNetworkPanel rootNetworkPanel = new RootNetworkPanel(model, NetworkMainPanel.this.isShowNetworkProvenanceHierarchy(), NetworkMainPanel.this.serviceRegistrar);
                rootNetworkPanel.setAlignmentX(0.0f);
                rootNetworkPanel.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentResized(ComponentEvent e) {
                        RootNetworkListPanel.this.updateScrollableTracksViewportHeight();
                    }
                });
                this.items.put(rootNetwork, rootNetworkPanel);
                this.add((Component)rootNetworkPanel, this.getComponentCount() - 1);
            }
            return this.items.get(rootNetwork);
        }

        RootNetworkPanel removeItem(CyRootNetwork rootNetwork) {
            RootNetworkPanel rootNetworkPanel = this.items.remove(rootNetwork);
            if (rootNetworkPanel != null) {
                this.remove(rootNetworkPanel);
            }
            return rootNetworkPanel;
        }

        void removeAllItems() {
            this.items.clear();
            this.removeAll();
            this.add(this.filler);
        }

        RootNetworkPanel getItem(CyRootNetwork rootNetwork) {
            return this.items.get(rootNetwork);
        }

        boolean isEmpty() {
            return this.items.isEmpty();
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 10;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return (orientation == 1 ? visibleRect.height : visibleRect.width) - 10;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return this.scrollableTracksViewportHeight;
        }
    }
}

