/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.view;

import java.awt.Color;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.util.swing.TextIcon;

class MemStatusPanel
extends JPanel {
    static final int UPDATE_DELAY_MS = 2000;
    static final int ICON_SIZE = 14;
    static final float ICON_FONT_SIZE = 14.0f;
    final JLabel memAmountLabel;
    final JToggleButton memStatusBtn;
    private final CyServiceRegistrar serviceRegistrar;

    static float getMemUsed() {
        Runtime runtime = Runtime.getRuntime();
        long freeMem = runtime.freeMemory();
        long totalMem = runtime.totalMemory();
        long usedMem = totalMem - freeMem;
        long maxMem = runtime.maxMemory();
        double usedMemFraction = (double)usedMem / (double)maxMem;
        return (float)usedMemFraction;
    }

    static void performGC() {
        for (int i = 0; i < 5; ++i) {
            System.runFinalization();
            System.gc();
        }
    }

    public MemStatusPanel(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
        this.memAmountLabel = new JLabel();
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.memAmountLabel});
        this.memAmountLabel.setVisible(false);
        JButton gcBtn = new JButton("Free Unused Memory");
        if (LookAndFeelUtil.isAquaLAF()) {
            gcBtn.putClientProperty("JButton.buttonType", "gradient");
        }
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{gcBtn});
        gcBtn.addActionListener(evt -> {
            gcBtn.setEnabled(false);
            gcBtn.setText("Freeing Memory...");
            SwingUtilities.invokeLater(() -> {
                MemStatusPanel.performGC();
                this.updateMemStatus();
                gcBtn.setText("Free Unusued Memory");
                gcBtn.setEnabled(true);
            });
        });
        gcBtn.setToolTipText("<html>Try to free memory&mdash;may temporarily freeze Cytoscape</html>");
        gcBtn.setVisible(false);
        this.memStatusBtn = new JToggleButton(MemState.MEM_OK.getIcon((IconManager)serviceRegistrar.getService(IconManager.class)));
        this.memStatusBtn.setHorizontalTextPosition(4);
        if (LookAndFeelUtil.isAquaLAF()) {
            this.memStatusBtn.putClientProperty("JButton.buttonType", "gradient");
        }
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.memStatusBtn});
        this.memStatusBtn.addActionListener(evt -> {
            this.memAmountLabel.setVisible(this.memStatusBtn.isSelected());
            gcBtn.setVisible(this.memStatusBtn.isSelected());
        });
        this.memStatusBtn.setHorizontalTextPosition(2);
        this.memStatusBtn.setFocusPainted(false);
        Timer updateTimer = new Timer(2000, evt -> this.updateMemStatus());
        updateTimer.setRepeats(true);
        updateTimer.start();
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(false);
        layout.setAutoCreateGaps(false);
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.memAmountLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(gcBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.memStatusBtn));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.memAmountLabel, -2, -1, -2).addComponent(gcBtn, -2, -1, -2).addComponent(this.memStatusBtn, -2, -1, -2));
    }

    private void updateMemStatus() {
        long memTotal = Runtime.getRuntime().maxMemory();
        String memTotalFmt = MemUnit.format(memTotal);
        float memUsed = MemStatusPanel.getMemUsed();
        MemState memState = MemState.which(memUsed);
        try {
            this.memStatusBtn.setIcon(memState.getIcon((IconManager)this.serviceRegistrar.getService(IconManager.class)));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.memStatusBtn.setHorizontalTextPosition(4);
        this.memStatusBtn.setToolTipText("Memory " + memState.getName());
        this.memAmountLabel.setText(String.format("%.1f%% used of %s", Float.valueOf(memUsed * 100.0f), memTotalFmt));
    }

    static enum MemUnit {
        GB(30L, "Gb"),
        MB(20L, "Mb"),
        KB(10L, "Kb");

        final long bytes;
        final String name;

        private MemUnit(long exp2, String name) {
            this.bytes = 1L << (int)exp2;
            this.name = name;
        }

        public static String format(long bytes) {
            for (MemUnit unit : MemUnit.values()) {
                if (bytes < unit.bytes) continue;
                return String.format("%.2f %s", (double)bytes / (double)unit.bytes, unit.name);
            }
            return String.format("%d b", bytes);
        }
    }

    static enum MemState {
        MEM_OK(0.0f, 0.75f, LookAndFeelUtil.getSuccessColor(), "OK"),
        MEM_LOW(0.75f, 0.85f, LookAndFeelUtil.getWarnColor(), "Low"),
        MEM_VERY_LOW(0.85f, 1.0f, LookAndFeelUtil.getErrorColor(), "Very Low");

        final float minRange;
        final float maxRange;
        final Color color;
        final String name;
        Icon icon;

        private MemState(float minRange, float maxRange, Color color, String name) {
            this.minRange = minRange;
            this.maxRange = maxRange;
            this.color = color;
            this.name = name;
        }

        public boolean isInRange(float memUsed) {
            return this.minRange < memUsed && memUsed <= this.maxRange;
        }

        public Icon getIcon(IconManager iconManager) {
            if (this.icon == null) {
                this.icon = new TextIcon("\uf2db", iconManager.getIconFont(14.0f), this.color, 14, 14);
            }
            return this.icon;
        }

        public String getName() {
            return this.name;
        }

        public static MemState which(float memUsed) {
            for (MemState state : MemState.values()) {
                if (!state.isInRange(memUsed)) continue;
                return state;
            }
            return null;
        }
    }
}

