/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.view;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import org.cytoscape.internal.view.GridViewToggleModel;
import org.cytoscape.internal.view.util.ViewUtil;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;

public class GridViewTogglePanel
extends JPanel {
    private JToggleButton gridModeButton;
    private JToggleButton viewModeButton;
    private ButtonGroup modeButtonGroup;
    private final GridViewToggleModel model;
    private final CyServiceRegistrar serviceRegistrar;
    private PropertyChangeListener modePropertyListener = evt -> this.update();

    public GridViewTogglePanel(GridViewToggleModel model, CyServiceRegistrar serviceRegistrar) {
        this.model = model;
        this.serviceRegistrar = serviceRegistrar;
        this.init();
    }

    public GridViewToggleModel getModel() {
        return this.model;
    }

    void update() {
        GridViewToggleModel.Mode mode = this.model.getMode();
        JToggleButton btn = mode == GridViewToggleModel.Mode.GRID ? this.getGridModeButton() : this.getViewModeButton();
        this.getModeButtonGroup().setSelected(btn.getModel(), true);
        ViewUtil.updateToolBarStyle(this.getGridModeButton());
        ViewUtil.updateToolBarStyle(this.getViewModeButton());
    }

    private void init() {
        this.modeButtonGroup = new ButtonGroup();
        this.modeButtonGroup.add(this.getGridModeButton());
        this.modeButtonGroup.add(this.getViewModeButton());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(false);
        layout.setAutoCreateGaps(false);
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.getGridModeButton(), -2, -1, -2).addComponent(this.getViewModeButton(), -2, -1, -2));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addComponent(this.getGridModeButton(), -2, -1, -2).addComponent(this.getViewModeButton(), -2, -1, -2));
        LookAndFeelUtil.equalizeSize((JComponent[])new JComponent[]{this.getGridModeButton(), this.getViewModeButton()});
        this.setKeyBindings(this);
        this.model.addPropertyChangeListener("mode", this.modePropertyListener);
        this.update();
    }

    JToggleButton getGridModeButton() {
        if (this.gridModeButton == null) {
            this.gridModeButton = new JToggleButton("\uf00a");
            this.gridModeButton.setToolTipText("Show Grid (G)");
            ViewUtil.styleToolBarButton((AbstractButton)this.gridModeButton, ((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIconFont(22.0f));
            this.gridModeButton.addActionListener(evt -> this.model.setMode(GridViewToggleModel.Mode.GRID));
        }
        return this.gridModeButton;
    }

    JToggleButton getViewModeButton() {
        if (this.viewModeButton == null) {
            this.viewModeButton = new JToggleButton("\uf1e1");
            this.viewModeButton.setToolTipText("Show View (V)");
            ViewUtil.styleToolBarButton((AbstractButton)this.viewModeButton, ((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIconFont(22.0f));
            this.viewModeButton.addActionListener(evt -> this.model.setMode(GridViewToggleModel.Mode.VIEW));
        }
        return this.viewModeButton;
    }

    ButtonGroup getModeButtonGroup() {
        return this.modeButtonGroup;
    }

    private void setKeyBindings(JComponent comp) {
        ActionMap actionMap = comp.getActionMap();
        InputMap inputMap = comp.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(71, 0), "VK_G");
        inputMap.put(KeyStroke.getKeyStroke(86, 0), "VK_V");
        actionMap.put("VK_G", new KeyAction("VK_G"));
        actionMap.put("VK_V", new KeyAction("VK_V"));
    }

    void dispose() {
        this.model.removePropertyChangeListener("mode", this.modePropertyListener);
    }

    private class KeyAction
    extends AbstractAction {
        static final String VK_G = "VK_G";
        static final String VK_V = "VK_V";

        KeyAction(String actionCommand) {
            this.putValue("ActionCommandKey", actionCommand);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (focusOwner instanceof JTextComponent || focusOwner instanceof JTable || !GridViewTogglePanel.this.isVisible()) {
                return;
            }
            String cmd = e.getActionCommand();
            if (cmd.equals(VK_G)) {
                GridViewTogglePanel.this.getGridModeButton().doClick();
            } else if (cmd.equals(VK_V)) {
                GridViewTogglePanel.this.getViewModeButton().doClick();
            }
        }
    }
}

