/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.view;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.cytoscape.internal.view.AbstractNetworkPanelModel;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.LookAndFeelUtil;

public abstract class AbstractNetworkPanel<T extends CyNetwork>
extends JPanel {
    private JLabel nameLabel;
    private boolean selected;
    private AbstractNetworkPanelModel<T> model;
    protected final CyServiceRegistrar serviceRegistrar;

    protected AbstractNetworkPanel(AbstractNetworkPanelModel<T> model, CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
        this.setModel(model);
        this.init();
    }

    public AbstractNetworkPanelModel<T> getModel() {
        return this.model;
    }

    public void setModel(AbstractNetworkPanelModel<T> newModel) {
        if (newModel == null) {
            throw new IllegalArgumentException("'newModel' must not be null.");
        }
        AbstractNetworkPanelModel<T> oldModel = this.model;
        this.model = newModel;
        this.update();
        this.firePropertyChange("model", oldModel, newModel);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean newValue) {
        if (this.selected != newValue) {
            this.selected = newValue;
            this.updateSelection();
            this.firePropertyChange("selected", !newValue, newValue);
        }
    }

    public void update() {
        this.updateSelection();
        this.updateNameLabel();
    }

    protected JLabel getNameLabel() {
        if (this.nameLabel == null) {
            this.nameLabel = new JLabel();
            this.nameLabel.setFont(this.nameLabel.getFont().deriveFont(LookAndFeelUtil.getSmallFontSize()));
            this.nameLabel.setMinimumSize(this.nameLabel.getPreferredSize());
        }
        return this.nameLabel;
    }

    protected void updateSelection() {
        this.setBackground(UIManager.getColor(this.selected ? "Table.selectionBackground" : "Table.background"));
    }

    protected void updateNameLabel() {
        this.getNameLabel().setText(this.model.getNetworkName());
        this.getNameLabel().setToolTipText(this.model.getNetworkName());
    }

    protected abstract void init();

    @Override
    public String toString() {
        return this.getNameLabel().getText();
    }
}

