/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.util;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Random;

public class RandomImage
extends BufferedImage {
    private final int grain = 5;
    private final int colorRange = 5;

    public RandomImage(int width, int height) {
        super(width, height, 2);
        this.draw(new Random());
    }

    public RandomImage(int width, int height, long seed) {
        super(width, height, 2);
        this.draw(new Random(seed));
    }

    private void draw(Random random) {
        int w = this.getWidth();
        int h = this.getHeight();
        Graphics2D g2 = (Graphics2D)this.getGraphics();
        g2.setRenderingHints(new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON));
        int max = 200;
        int min = 100;
        Color color = this.randomColor(random);
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        g2.setColor(color);
        double blockout = random.nextDouble();
        int x = 0;
        int y = 0;
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                if (blockout < 0.4) {
                    g2.fillRect(x, y, w / 5, h / 5);
                    g2.fillRect(w - x - w / 5, y, w / 5, h / 5);
                    x += w / 5;
                } else {
                    red -= 5;
                    red = Math.min(max, Math.max(red, min));
                    green += 5;
                    green = Math.min(max, Math.max(green, min));
                    blue += 5;
                    blue = Math.min(max, Math.max(blue, min));
                    g2.setColor(new Color(red, green, blue));
                    x += w / 5;
                }
                blockout = random.nextDouble();
            }
            y += h / 5;
            x = 0;
        }
    }

    private Color randomColor(Random random) {
        float hue = random.nextFloat();
        float saturation = 0.9f;
        float luminance = 1.0f;
        return Color.getHSBColor(hue, 0.9f, 1.0f);
    }
}

