/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.task;

import java.net.UnknownHostException;
import org.apache.log4j.Logger;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class GetLatestVersionTask
extends AbstractTask {
    private static final String NEWS_URL = "http://chianti.ucsd.edu/cytoscape-news/news.html";
    private String latestVersion;

    public void run(TaskMonitor tm) throws Exception {
        tm.setTitle("Get Latest Cytoscape Version");
        try {
            Document doc = Jsoup.connect((String)NEWS_URL).get();
            Elements metaTags = doc.getElementsByTag("meta");
            for (Element tag : metaTags) {
                if (!"latestVersion".equals(tag.attr("name"))) continue;
                this.latestVersion = tag.attr("content");
                break;
            }
        }
        catch (UnknownHostException e) {
            Logger.getLogger((String)"org.cytoscape.application.userlog").warn((Object)"Cannot find host (please check your Internet connection).", (Throwable)e);
            tm.showMessage(TaskMonitor.Level.WARN, "Cannot find host (please check your Internet connection): " + e.getMessage());
        }
        catch (Exception e) {
            Logger.getLogger((String)"org.cytoscape.application.userlog").error((Object)"Unexpected error when getting latest Cytoscape version.", (Throwable)e);
            tm.showMessage(TaskMonitor.Level.ERROR, "Unexpected error: " + e.getMessage());
        }
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }
}

