/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.dialogs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.cytoscape.io.DataCategory;
import org.cytoscape.io.datasource.DataSource;
import org.cytoscape.io.datasource.DataSourceManager;
import org.cytoscape.io.datasource.DefaultDataSource;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.LookAndFeelUtil;

public class BookmarkDialog
extends JDialog
implements ActionListener,
ListSelectionListener,
ItemListener {
    private String bookmarkCategory;
    private String[] bookmarkCategories = new String[]{"network", "table", "image", "properties", "session", "script", "vizmap", "unspecified"};
    private JButton btnAddBookmark;
    private JButton btnDeleteBookmark;
    private JButton btnEditBookmark;
    private JButton btnClose;
    private JComboBox<String> cmbCategory;
    private JScrollPane scrollPane;
    private JList<DataSource> listBookmark;
    private final CyServiceRegistrar serviceRegistrar;

    public BookmarkDialog(Window owner, CyServiceRegistrar serviceRegistrar) {
        super(owner, Dialog.ModalityType.APPLICATION_MODAL);
        this.serviceRegistrar = serviceRegistrar;
        this.setTitle("Bookmark Manager");
        this.initComponents();
        this.bookmarkCategory = (String)this.cmbCategory.getSelectedItem();
        this.loadBookmarks();
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocationRelativeTo(owner);
        this.setResizable(false);
    }

    private void initComponents() {
        this.cmbCategory = new JComboBox();
        this.scrollPane = new JScrollPane();
        this.listBookmark = new JList();
        this.btnAddBookmark = new JButton("Add");
        this.btnEditBookmark = new JButton("Modify");
        this.btnDeleteBookmark = new JButton("Delete");
        this.btnClose = new JButton(new AbstractAction("Close"){

            @Override
            public void actionPerformed(ActionEvent e) {
                BookmarkDialog.this.dispose();
            }
        });
        this.cmbCategory.setToolTipText("Bookmark Category");
        this.scrollPane.setViewportView(this.listBookmark);
        this.btnAddBookmark.setToolTipText("Add a new bookmark");
        this.btnEditBookmark.setToolTipText("Edit a bookmark");
        this.btnDeleteBookmark.setToolTipText("Delete a bookmark");
        for (String AnItem : this.bookmarkCategories) {
            this.cmbCategory.addItem(AnItem);
        }
        this.cmbCategory.addItemListener(this);
        this.btnEditBookmark.setEnabled(false);
        this.btnDeleteBookmark.setEnabled(false);
        this.btnAddBookmark.addActionListener(this);
        this.btnEditBookmark.addActionListener(this);
        this.btnDeleteBookmark.addActionListener(this);
        this.listBookmark.addListSelectionListener(this);
        this.listBookmark.setCellRenderer(new MyListCellRenderer());
        this.listBookmark.setSelectionMode(0);
        this.listBookmark.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && !e.isConsumed()) {
                    e.consume();
                    if (BookmarkDialog.this.listBookmark.getSelectedIndex() >= 0 && BookmarkDialog.this.btnEditBookmark.isEnabled()) {
                        BookmarkDialog.this.btnEditBookmark.doClick();
                    }
                }
            }
        });
        JPanel propsTablePanel = new JPanel();
        propsTablePanel.setBorder(LookAndFeelUtil.createTitledBorder((String)"Bookmarks"));
        GroupLayout layout = new GroupLayout(propsTablePanel);
        propsTablePanel.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addComponent(this.cmbCategory, -1, -1, Short.MAX_VALUE).addComponent(this.scrollPane, -1, -1, 460).addGroup(GroupLayout.Alignment.CENTER, layout.createSequentialGroup().addComponent(this.btnAddBookmark).addComponent(this.btnEditBookmark).addComponent(this.btnDeleteBookmark)));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.cmbCategory, -1, -1, Short.MAX_VALUE).addComponent(this.scrollPane, -2, -1, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addComponent(this.btnAddBookmark).addComponent(this.btnEditBookmark).addComponent(this.btnDeleteBookmark)));
        JPanel contentPane = new JPanel();
        GroupLayout layout2 = new GroupLayout(contentPane);
        contentPane.setLayout(layout2);
        layout2.setAutoCreateContainerGaps(true);
        layout2.setAutoCreateGaps(true);
        layout2.setHorizontalGroup(layout2.createParallelGroup(GroupLayout.Alignment.TRAILING, true).addComponent(propsTablePanel, -1, -1, Short.MAX_VALUE).addComponent(this.btnClose, -2, -1, -2));
        layout2.setVerticalGroup(layout2.createSequentialGroup().addComponent(propsTablePanel, -1, -1, Short.MAX_VALUE).addComponent(this.btnClose));
        this.setContentPane(contentPane);
        LookAndFeelUtil.setDefaultOkCancelKeyStrokes((JRootPane)this.getRootPane(), (Action)this.btnClose.getAction(), (Action)this.btnClose.getAction());
        this.getRootPane().setDefaultButton(this.btnClose);
    }

    public void loadBookmarks() {
        DataSourceManager dsManager = (DataSourceManager)this.serviceRegistrar.getService(DataSourceManager.class);
        Collection theDataSourceCollection = new HashSet();
        String selectedItem = (String)this.cmbCategory.getSelectedItem();
        theDataSourceCollection = selectedItem.equals("network") ? dsManager.getDataSources(DataCategory.NETWORK) : (selectedItem.equals("table") ? dsManager.getDataSources(DataCategory.TABLE) : (selectedItem.equals("image") ? dsManager.getDataSources(DataCategory.IMAGE) : (selectedItem.equals("properties") ? dsManager.getDataSources(DataCategory.PROPERTIES) : (selectedItem.equals("session") ? dsManager.getDataSources(DataCategory.SESSION) : (selectedItem.equals("script") ? dsManager.getDataSources(DataCategory.SCRIPT) : (selectedItem.equals("vizmap") ? dsManager.getDataSources(DataCategory.VIZMAP) : (selectedItem.equals("unspecified") ? dsManager.getDataSources(DataCategory.UNSPECIFIED) : dsManager.getDataSources(DataCategory.UNSPECIFIED))))))));
        Iterator it = theDataSourceCollection.iterator();
        ArrayList<DataSource> theDataSourceList = new ArrayList<DataSource>(theDataSourceCollection.size());
        while (it.hasNext()) {
            theDataSourceList.add((DataSource)it.next());
        }
        MyListModel theModel = new MyListModel(theDataSourceList);
        this.listBookmark.setModel(theModel);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.bookmarkCategory = (String)this.cmbCategory.getSelectedItem();
        this.loadBookmarks();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object _actionObject = e.getSource();
        if (_actionObject instanceof JButton) {
            JButton _btn = (JButton)_actionObject;
            if (_btn == this.btnAddBookmark) {
                EditBookmarkDialog theNewDialog = new EditBookmarkDialog(this, this.bookmarkCategory, "new", null);
                theNewDialog.setLocationRelativeTo(this);
                theNewDialog.setVisible(true);
                this.loadBookmarks();
            } else if (_btn == this.btnEditBookmark) {
                DataSource theDataSource = this.listBookmark.getSelectedValue();
                EditBookmarkDialog theEditDialog = new EditBookmarkDialog(this, this.bookmarkCategory, "edit", theDataSource);
                theEditDialog.setLocationRelativeTo(this);
                theEditDialog.setVisible(true);
                this.loadBookmarks();
            } else if (_btn == this.btnDeleteBookmark) {
                DataSource theDataSource = this.listBookmark.getSelectedValue();
                MyListModel theModel = (MyListModel)this.listBookmark.getModel();
                theModel.removeElement(this.listBookmark.getSelectedIndex());
                DataSourceManager dsManager = (DataSourceManager)this.serviceRegistrar.getService(DataSourceManager.class);
                dsManager.deleteDataSource(theDataSource);
                if (theModel.getSize() == 0) {
                    this.btnEditBookmark.setEnabled(false);
                    this.btnDeleteBookmark.setEnabled(false);
                }
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent pListSelectionEvent) {
        if (this.listBookmark.getSelectedIndex() == -1) {
            this.btnEditBookmark.setEnabled(false);
            this.btnDeleteBookmark.setEnabled(false);
        } else {
            this.btnEditBookmark.setEnabled(true);
            this.btnDeleteBookmark.setEnabled(true);
        }
    }

    public void showDialog() {
        this.setVisible(true);
    }

    class EditBookmarkDialog
    extends JDialog {
        private String name;
        private String URLstr;
        private String provider;
        private JDialog parent;
        private String categoryName;
        private String mode;
        private DataSource dataSource;
        private JButton btnCancel;
        private JButton btnOK;
        private JLabel lbProvider;
        private JPanel formPnl;
        private JLabel lbCategory;
        private JLabel lbCategoryValue;
        private JLabel lbName;
        private JLabel lbURL;
        private JTextField tfName;
        private JTextField tfProvider;
        private JTextField tfURL;

        EditBookmarkDialog(JDialog parent, String categoryName, String pMode, DataSource pDataSource) {
            super((Window)parent, Dialog.ModalityType.APPLICATION_MODAL);
            this.provider = "";
            this.mode = "new";
            this.parent = parent;
            this.categoryName = categoryName;
            this.mode = pMode;
            this.dataSource = pDataSource;
            this.initComponents();
            this.setDefaultCloseOperation(2);
            this.lbCategoryValue.setText(categoryName);
            if (pMode.equalsIgnoreCase("new")) {
                this.setTitle("Add New Bookmark");
            } else if (pMode.equalsIgnoreCase("edit")) {
                this.setTitle("Edit Bookmark");
                this.tfName.setText(this.dataSource.getName());
                this.tfName.setEditable(false);
                this.tfURL.setText(this.dataSource.getLocation().toString());
                this.tfProvider.setText(this.dataSource.getProvider());
            }
            this.setResizable(false);
            this.pack();
        }

        private void onOKButtonActionPerformed(ActionEvent e) {
            DataSourceManager dsManager = (DataSourceManager)BookmarkDialog.this.serviceRegistrar.getService(DataSourceManager.class);
            if (this.mode.equalsIgnoreCase("new")) {
                URL newURL;
                this.name = this.tfName.getText();
                this.URLstr = this.tfURL.getText();
                this.provider = this.tfProvider.getText().trim();
                if (this.name.trim().equals("") || this.URLstr.trim().equals("")) {
                    String msg = "Please provide a name/URL.";
                    JOptionPane.showMessageDialog(this.parent, msg, "Warning", 1);
                    return;
                }
                try {
                    newURL = new URL(this.URLstr);
                }
                catch (MalformedURLException ex) {
                    JOptionPane.showMessageDialog(this.parent, "Invalid URL", "Warning", 1);
                    return;
                }
                DefaultDataSource theDataSource = new DefaultDataSource(this.name, this.provider, "", this.getCategoryByName(this.categoryName), newURL);
                if (dsManager.containsDataSource((DataSource)theDataSource)) {
                    String msg = "Bookmark already existed.";
                    JOptionPane.showMessageDialog(this.parent, msg, "Warning", 1);
                    return;
                }
                dsManager.saveDataSource((DataSource)theDataSource);
                this.dispose();
            } else if (this.mode.equalsIgnoreCase("edit")) {
                URL newURL;
                this.name = this.tfName.getText();
                this.URLstr = this.tfURL.getText();
                this.provider = this.tfProvider.getText().trim();
                if (this.URLstr.trim().equals("")) {
                    String msg = "URL is empty.";
                    JOptionPane.showMessageDialog(this.parent, msg, "Warning", 1);
                    return;
                }
                try {
                    newURL = new URL(this.URLstr);
                }
                catch (MalformedURLException ex) {
                    JOptionPane.showMessageDialog(this.parent, "Invalid URL", "Warning", 1);
                    return;
                }
                DefaultDataSource theDataSource = new DefaultDataSource(this.name, this.provider, this.dataSource.getDescription(), this.dataSource.getDataCategory(), newURL);
                dsManager.deleteDataSource(this.dataSource);
                dsManager.saveDataSource((DataSource)theDataSource);
                this.dispose();
            }
        }

        private DataCategory getCategoryByName(String categoryName) {
            if (categoryName.equalsIgnoreCase("network")) {
                return DataCategory.NETWORK;
            }
            if (categoryName.equalsIgnoreCase("table")) {
                return DataCategory.TABLE;
            }
            if (categoryName.equalsIgnoreCase("image")) {
                return DataCategory.IMAGE;
            }
            if (categoryName.equalsIgnoreCase("properties")) {
                return DataCategory.PROPERTIES;
            }
            if (categoryName.equalsIgnoreCase("session")) {
                return DataCategory.SESSION;
            }
            if (categoryName.equalsIgnoreCase("script")) {
                return DataCategory.SCRIPT;
            }
            if (categoryName.equalsIgnoreCase("vizmap")) {
                return DataCategory.VIZMAP;
            }
            if (categoryName.equalsIgnoreCase("unspecified")) {
                return DataCategory.UNSPECIFIED;
            }
            return DataCategory.UNSPECIFIED;
        }

        private void initComponents() {
            this.lbCategory = new JLabel("Category:");
            this.lbCategoryValue = new JLabel("network");
            this.lbProvider = new JLabel("Provider:");
            this.tfProvider = new JTextField();
            this.lbName = new JLabel("Name:");
            this.tfName = new JTextField();
            this.lbURL = new JLabel("URL:");
            this.tfURL = new JTextField();
            this.formPnl = new JPanel();
            this.btnOK = new JButton(new AbstractAction("OK"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditBookmarkDialog.this.onOKButtonActionPerformed(e);
                }
            });
            this.btnCancel = new JButton(new AbstractAction("Cancel"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditBookmarkDialog.this.dispose();
                }
            });
            GroupLayout layout = new GroupLayout(this.formPnl);
            this.formPnl.setLayout(layout);
            layout.setAutoCreateContainerGaps(true);
            layout.setAutoCreateGaps(true);
            layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.lbCategory).addComponent(this.lbProvider).addComponent(this.lbName).addComponent(this.lbURL)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(this.lbCategoryValue).addComponent(this.tfProvider).addComponent(this.tfName).addComponent(this.tfURL)));
            layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.lbCategory).addComponent(this.lbCategoryValue)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.lbProvider).addComponent(this.tfProvider)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.lbName).addComponent(this.tfName)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.lbURL).addComponent(this.tfURL)));
            JPanel buttonPnl = LookAndFeelUtil.createOkCancelPanel((JButton)this.btnOK, (JButton)this.btnCancel);
            JPanel contentPane = new JPanel();
            GroupLayout layout2 = new GroupLayout(contentPane);
            contentPane.setLayout(layout2);
            layout2.setAutoCreateContainerGaps(true);
            layout2.setAutoCreateGaps(true);
            layout2.setHorizontalGroup(layout2.createParallelGroup(GroupLayout.Alignment.TRAILING, true).addComponent(this.formPnl, -1, 480, 480).addComponent(buttonPnl, -1, -1, Short.MAX_VALUE));
            layout2.setVerticalGroup(layout2.createSequentialGroup().addComponent(this.formPnl, -2, -1, -2).addComponent(buttonPnl, -2, -1, -2));
            this.setContentPane(contentPane);
            LookAndFeelUtil.setDefaultOkCancelKeyStrokes((JRootPane)this.getRootPane(), (Action)this.btnOK.getAction(), (Action)this.btnCancel.getAction());
            this.getRootPane().setDefaultButton(this.btnOK);
        }
    }

    class MyListCellRenderer
    extends DefaultListCellRenderer {
        public MyListCellRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            DataSource theDataSource = (DataSource)value;
            this.setText(theDataSource.getName());
            this.setToolTipText(theDataSource.getLocation().toString());
            return this;
        }
    }

    class MyListModel
    extends AbstractListModel<DataSource> {
        List<DataSource> theDataSourceList = new ArrayList<DataSource>(0);

        public MyListModel(List<DataSource> pDataSourceList) {
            this.theDataSourceList = pDataSourceList;
        }

        @Override
        public int getSize() {
            return this.theDataSourceList == null ? 0 : this.theDataSourceList.size();
        }

        @Override
        public DataSource getElementAt(int i) {
            return this.theDataSourceList == null ? null : this.theDataSourceList.get(i);
        }

        public void addElement(DataSource pDataSource) {
            this.theDataSourceList.add(pDataSource);
        }

        public void removeElement(int pIndex) {
            this.theDataSourceList.remove(pIndex);
            this.fireContentsChanged(this, pIndex, pIndex);
        }
    }
}

