/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.command;

import com.vladsch.flexmark.ast.Document;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import java.util.List;
import org.cytoscape.command.AvailableCommands;
import org.cytoscape.command.util.EdgeList;
import org.cytoscape.command.util.NodeList;
import org.cytoscape.internal.command.MessageHandler;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTable;
import org.cytoscape.work.util.AbstractBounded;
import org.cytoscape.work.util.BoundedDouble;
import org.cytoscape.work.util.BoundedFloat;
import org.cytoscape.work.util.BoundedInteger;
import org.cytoscape.work.util.BoundedLong;
import org.cytoscape.work.util.ListMultipleSelection;
import org.cytoscape.work.util.ListSingleSelection;

public class HelpGenerator {
    private AvailableCommands availableCommands;
    private static int MAX_LIST = 20;

    public HelpGenerator(AvailableCommands availableCommands) {
        this.availableCommands = availableCommands;
    }

    public void generateHelpHTML(String input, MessageHandler resultsText) {
        String[] tokens = input.split(" ");
        if (tokens.length == 1) {
            this.helpListNamespaces(resultsText);
        } else if (tokens.length == 2 && tokens[1].equals("all")) {
            this.helpAll(resultsText);
        } else if (tokens.length == 2) {
            this.helpNamespace(tokens[1], resultsText);
        } else if (tokens.length > 2) {
            this.helpCommand(tokens, resultsText);
        }
    }

    private void helpListNamespaces(MessageHandler resultsText) {
        List namespaces = this.availableCommands.getNamespaces();
        resultsText.appendMessage("Available namespaces:");
        for (String ns : namespaces) {
            resultsText.appendMessage("   " + ns);
        }
    }

    private void helpAll(MessageHandler resultsText) {
        for (String namespace : this.availableCommands.getNamespaces()) {
            resultsText.appendMessage(namespace);
            for (String command : this.availableCommands.getCommands(namespace)) {
                command = command.trim();
                this.generateArgumentHelp(namespace, command, resultsText);
                resultsText.appendMessage("<br/>");
            }
        }
    }

    private void helpNamespace(String namespace, MessageHandler resultsText) {
        List commands = this.availableCommands.getCommands(namespace);
        if (commands.size() == 0) {
            resultsText.appendError("Can't find " + namespace + " namespace");
            return;
        }
        resultsText.appendMessage("Available commands:");
        for (String command : commands) {
            String desc = this.availableCommands.getDescription(namespace, command);
            if (desc != null && desc.length() > 0) {
                resultsText.appendMessage("&nbsp;&nbsp;<b>" + namespace + " " + command + "</b>&nbsp;&nbsp;<i>" + desc + "</i>");
                continue;
            }
            resultsText.appendMessage("&nbsp;&nbsp;<b>" + namespace + " " + command + "</b>");
        }
    }

    private void helpCommand(String[] tokens, MessageHandler resultsText) {
        Object command = "";
        for (int i = 2; i < tokens.length; ++i) {
            command = (String)command + tokens[i] + " ";
        }
        command = ((String)command).trim();
        boolean found = false;
        List commands = this.availableCommands.getCommands(tokens[1]);
        for (String c : commands) {
            if (!c.equals(command)) continue;
            found = true;
            break;
        }
        if (!found) {
            resultsText.appendError("Can't find command " + tokens[1] + " " + (String)command);
            return;
        }
        this.generateArgumentHelp(tokens[1], (String)command, resultsText);
    }

    private void generateArgumentHelp(String namespace, String command, MessageHandler resultsText) {
        String longDescription = this.availableCommands.getLongDescription(namespace, command);
        Object message = "";
        if (longDescription != null) {
            if (longDescription.trim().startsWith("<html>") || longDescription.trim().startsWith("<HTML>")) {
                longDescription = longDescription.trim().substring(6);
                longDescription = longDescription.substring(0, longDescription.length() - 7);
            } else {
                Parser parser = Parser.builder().build();
                Document document = parser.parse(longDescription);
                HtmlRenderer renderer = HtmlRenderer.builder().build();
                longDescription = renderer.render((Node)document);
            }
            message = (String)message + longDescription;
        }
        List argList = this.availableCommands.getArguments(namespace, command);
        message = (String)message + "<br/><br/><b>" + namespace + " " + command + "</b> arguments:";
        message = (String)message + "<dl style='list-style-type:none;margin-top:0px;color:blue'>";
        for (String arg : argList) {
            message = (String)message + "<dt>";
            message = this.availableCommands.getArgRequired(namespace, command, arg) ? (String)message + "<b>" + arg + "</b>" : (String)message + arg;
            message = (String)message + "=" + this.getTypeString(namespace, command, arg);
            message = (String)message + ": ";
            message = (String)message + "</dt>";
            message = (String)message + "<dd>";
            message = (String)message + this.normalizeArgDescription(this.availableCommands.getArgDescription(namespace, command, arg), this.availableCommands.getArgLongDescription(namespace, command, arg));
            message = (String)message + "</dd>";
        }
        resultsText.appendMessage((String)message + "</dl>");
    }

    private String getTypeString(String namespace, String command, String arg) {
        Class clazz = this.availableCommands.getArgType(namespace, command, arg);
        Object object = this.availableCommands.getArgValue(namespace, command, arg);
        String keywords = this.keyword("all") + "|" + this.keyword("selected") + "|" + this.keyword("unselected");
        if (clazz.equals(NodeList.class)) {
            String args = "[" + this.variable("nodeColumn:value") + "|" + this.variable("node name") + this.keyword(",") + "...]|" + keywords;
            return this.fixedSpan(args);
        }
        if (clazz.equals(EdgeList.class)) {
            String args = "[" + this.variable("edgeColumn:value") + "|" + this.variable("edge name") + this.keyword(",") + "...]|" + keywords;
            return this.fixedSpan(args);
        }
        if (clazz.equals(CyNetwork.class)) {
            return this.fixedSpan(this.keyword("current") + "|[" + this.variable("column:value") + "|" + this.variable("network name") + "]");
        }
        if (clazz.equals(CyTable.class)) {
            String args = this.keyword("Node:") + this.variable("network name") + "|" + this.keyword("Edge:") + this.variable("network name") + "|" + this.keyword("Network:") + this.variable("network name") + "|" + this.variable("table name");
            return this.fixedSpan(args);
        }
        if (clazz.equals(Boolean.TYPE) || clazz.equals(Boolean.class)) {
            return this.fixedSpan(this.keyword("true") + "|" + this.keyword("false"));
        }
        if (clazz.equals(ListSingleSelection.class)) {
            if (object != null) {
                ListSingleSelection lss = (ListSingleSelection)object;
                String str = "&lt;" + this.classString(clazz.getSimpleName()) + "&nbsp(";
                List list = lss.getPossibleValues();
                int size = Math.min(list.size() - 1, MAX_LIST);
                for (int index = 0; index < size; ++index) {
                    str = str + this.keyword(list.get(index).toString()) + "|";
                }
                if (!list.isEmpty()) {
                    str = str + this.keyword(list.get(size).toString());
                    if (size < list.size() - 1) {
                        str = str + "|...";
                    }
                }
                str = str + ")&gt;";
                return this.fixedSpan(str);
            }
        } else if (clazz.equals(ListMultipleSelection.class)) {
            if (object != null) {
                ListMultipleSelection lss = (ListMultipleSelection)object;
                String str = "&lt;" + this.classString(clazz.getSimpleName()) + "&nbsp[";
                List list = lss.getPossibleValues();
                int size = Math.min(list.size() - 1, MAX_LIST);
                for (int index = 0; index < size; ++index) {
                    str = str + this.keyword(list.get(index).toString()) + ",";
                }
                if (!list.isEmpty()) {
                    str = str + this.keyword(list.get(size).toString());
                    if (size < list.size() - 1) {
                        str = str + ",...";
                    }
                }
                str = str + "]&gt;";
                return this.fixedSpan(str);
            }
        } else if ((clazz.equals(BoundedDouble.class) || clazz.equals(BoundedFloat.class) || clazz.equals(BoundedInteger.class) || clazz.equals(BoundedLong.class)) && object != null) {
            return this.boundedTypeString(clazz, object);
        }
        return this.fixedSpan("&lt;" + this.classString(clazz.getSimpleName()) + "&gt;");
    }

    private String fixedSpan(String s) {
        return "<span style='font-family:Courier;color:black'>" + s + "</span>";
    }

    private String keyword(String s) {
        return "<span style='font-family:Courier;color:#CC00CC'>" + s + "</span>";
    }

    private String variable(String s) {
        return "<span style='font-family:Courier;color:#A000A0;font-style:italics'>" + s + "</span>";
    }

    private String classString(String s) {
        return "<span style='font-family:Courier;color:#FF00FF;font-style:italics'>" + s + "</span>";
    }

    private String boundedTypeString(Class<?> type, Object object) {
        if (object instanceof AbstractBounded) {
            AbstractBounded ab = (AbstractBounded)object;
            String str = "&lt;" + this.classString(type.getSimpleName()) + "&nbsp;(";
            str = str + ab.getLowerBound().toString() + "&lt;";
            if (!ab.isLowerBoundStrict()) {
                str = str + "=";
            }
            str = ab.getValue() != null ? str + ab.getValue().toString() : str + this.classString(ab.getLowerBound().getClass().getSimpleName());
            str = str + "&lt;";
            if (!ab.isUpperBoundStrict()) {
                str = str + "=";
            }
            str = str + ab.getUpperBound().toString() + ")&gt;";
            return this.fixedSpan(str);
        }
        return this.fixedSpan("&lt;" + this.classString(type.getSimpleName()) + "&gt;");
    }

    private String normalizeArgDescription(String desc, String longDesc) {
        if (longDesc != null && longDesc.length() > 0) {
            return longDesc;
        }
        if (desc != null && (desc = desc.trim()).endsWith(":")) {
            desc = desc.substring(0, desc.length() - 1);
        }
        return desc;
    }
}

